/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createindustry.blocks.engines.radial;

import com.drmangotea.createindustry.blocks.engines.radial.input.RadialEngineInputBlockEntity;
import com.drmangotea.createindustry.registry.TFMGBlocks;
import com.drmangotea.createindustry.registry.TFMGFluids;
import com.drmangotea.createindustry.registry.TFMGSoundEvents;
import com.drmangotea.createindustry.registry.TFMGTags;
import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class RadialEngineBlockEntity
extends GeneratingKineticBlockEntity
implements IHaveGoggleInformation,
IWrenchable {
    public LazyOptional<IFluidHandler> fluidCapability;
    protected FluidTank tankInventory;
    protected FluidTank lubricationOilTank;
    protected FluidTank coolantTank;
    protected int soundTimer = 0;
    public int inputSingal = 0;
    public int fuelConsumption = 0;
    public float stressTotal = 0.0f;
    public float speed = 0.0f;
    public float stressBase = 0.0f;
    public int efficiency = 1;
    public final int idealSpeed = 12;
    public int consumptionTimer = 0;
    public Fluid lubricationOil = (Fluid)TFMGFluids.LUBRICATION_OIL.get();
    public Fluid coolant = (Fluid)TFMGFluids.COOLING_FLUID.get();
    public float powerModifier = 1.0f;
    public float efficiencyModifier = 1.4f;
    public List<BlockPos> inputs = new ArrayList<BlockPos>();
    public int signal = 0;
    boolean signalChanged;

    public RadialEngineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tankInventory = this.createInventory();
        this.lubricationOilTank = this.createUpgradeTankInventory(this.lubricationOil);
        this.coolantTank = this.createUpgradeTankInventory(this.coolant);
        this.fluidCapability = LazyOptional.of(() -> new CombinedTankWrapper(new IFluidHandler[]{this.tankInventory, this.lubricationOilTank, this.coolantTank}));
        this.setLazyTickRate(40);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public boolean spawnInput(Direction side) {
        BlockPos posToSpawn = this.m_58899_().m_121945_(side);
        if (side.m_122434_() == ((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)).m_122434_()) {
            return false;
        }
        if (!this.f_58857_.m_8055_(posToSpawn).m_60795_()) {
            if (this.f_58857_.m_8055_(posToSpawn).m_60713_((Block)TFMGBlocks.RADIAL_ENGINE_INPUT.get())) {
                this.inputs.remove(posToSpawn);
                this.f_58857_.m_7731_(posToSpawn, Blocks.f_50016_.m_49966_(), 3);
                return true;
            }
            return false;
        }
        this.f_58857_.m_7731_(posToSpawn, (BlockState)TFMGBlocks.RADIAL_ENGINE_INPUT.getDefaultState().m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)).m_122424_()), 3);
        this.inputs.add(posToSpawn);
        ((RadialEngineInputBlockEntity)this.f_58857_.m_7702_(posToSpawn)).setEngine(this);
        return true;
    }

    public void initialize() {
        super.initialize();
        this.sendData();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    public float getGeneratedSpeed() {
        int signal = Math.max(this.signal, this.inputSingal);
        if (!this.f_58857_.f_46443_) {
            this.calculateEfficiency();
            this.fuelConsumption = (int)(this.speed / (float)(this.efficiency / 10) / 7.0f + 1.0f);
            if (this.fuelConsumption < 1) {
                this.fuelConsumption = 0;
            }
            if (!this.tankInventory.isEmpty()) {
                if (this.consumptionTimer >= 45) {
                    if (signal != 0) {
                        this.tankInventory.drain(this.fuelConsumption, IFluidHandler.FluidAction.EXECUTE);
                    }
                    this.consumptionTimer = 0;
                }
                ++this.consumptionTimer;
                return (float)(signal * signal) * 0.8f * this.powerModifier;
            }
        }
        return 0.0f;
    }

    public void setInputSingal(int inputSingal) {
        this.inputSingal = inputSingal;
    }

    public void calculateEfficiency() {
        int signal = Math.max(this.signal, this.inputSingal);
        if (signal == 0 || this.tankInventory.isEmpty()) {
            this.efficiency = 0;
            return;
        }
        this.efficiency = 100;
        if (signal >= 12) {
            this.efficiency = (int)((float)(100 - (signal - 12) * 5) / this.efficiencyModifier);
        }
        if (signal < 12) {
            this.efficiency = (int)((float)(100 - (12 - signal) * 3) / this.efficiencyModifier);
        }
        if (this.efficiency > 100) {
            this.efficiency = 100;
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.translate((String)"goggles.engine_stats", (Object[])new Object[0]).forGoggles(tooltip);
        this.stressBase = this.calculateAddedStressCapacity();
        Lang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(ChatFormatting.GRAY).space().forGoggles(tooltip);
        this.speed = this.getTheoreticalSpeed();
        if (this.speed != this.getGeneratedSpeed() && this.speed != 0.0f) {
            this.speed = Math.abs(this.speed);
        }
        this.stressTotal = this.stressBase * this.speed;
        Lang.number((double)this.stressTotal).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.DARK_AQUA).space().add(Lang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        Lang.translate((String)"goggles.engine_redstone_input", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        Lang.translate((String)"tooltip.engine_analog_strength", (Object[])new Object[]{this.signal}).style(ChatFormatting.DARK_AQUA).forGoggles(tooltip, 1);
        Lang.translate((String)"goggles.engine.efficiency", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        Lang.translate((String)"goggles.get_engine_efficiency", (Object[])new Object[]{this.efficiency}).style(ChatFormatting.DARK_AQUA).add(Lang.translate((String)"goggles.misc.percent_symbol", (Object[])new Object[0])).forGoggles(tooltip, 1);
        LazyOptional<IFluidHandler> handler = this.fluidCapability;
        Optional resolve = handler.resolve();
        if (!resolve.isPresent()) {
            return false;
        }
        IFluidHandler tank = (IFluidHandler)resolve.get();
        if (tank.getTanks() == 0) {
            return false;
        }
        LangBuilder mb = Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        Lang.translate((String)"goggles.fuel_container", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        boolean isEmpty = true;
        for (int i = 0; i < tank.getTanks(); ++i) {
            FluidStack fluidStack = tank.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            Lang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            Lang.builder().add(Lang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.DARK_AQUA)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)tank.getTankCapacity(i)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (tank.getTanks() > 1) {
            if (isEmpty) {
                tooltip.remove(tooltip.size() - 1);
            }
            return true;
        }
        if (!isEmpty) {
            return true;
        }
        Lang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(Lang.number((double)tank.getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_AQUA)).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
        return true;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.SUCCESS;
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("Signal", this.signal);
        compound.m_128365_("TankContent", (Tag)this.tankInventory.writeToNBT(new CompoundTag()));
        compound.m_128365_("Coolant", (Tag)this.coolantTank.writeToNBT(new CompoundTag()));
        compound.m_128365_("LubricationOil", (Tag)this.lubricationOilTank.writeToNBT(new CompoundTag()));
        compound.m_128365_("Inputs", (Tag)RadialEngineBlockEntity.writeInputs(new CompoundTag(), this.inputs));
        super.write(compound, clientPacket);
    }

    public static CompoundTag writeInputs(CompoundTag nbt, List<BlockPos> inputs) {
        int x = 0;
        for (BlockPos input : inputs) {
            nbt.m_128405_("X" + x, input.m_123341_());
            nbt.m_128405_("Y" + x, input.m_123342_());
            nbt.m_128405_("Z" + x, input.m_123343_());
            ++x;
        }
        return nbt;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.tankInventory.readFromNBT(compound.m_128469_("TankContent"));
        this.coolantTank.readFromNBT(compound.m_128469_("Coolant"));
        this.lubricationOilTank.readFromNBT(compound.m_128469_("LubricationOil"));
        this.inputs = this.readInputs(compound.m_128469_("Inputs"));
        this.signal = compound.m_128451_("Signal");
        super.read(compound, clientPacket);
    }

    public void loadInputs() {
        for (BlockPos pos : this.inputs) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof RadialEngineInputBlockEntity)) continue;
            RadialEngineInputBlockEntity be = (RadialEngineInputBlockEntity)blockEntity;
            be.setEngine(this);
        }
    }

    public List<BlockPos> readInputs(CompoundTag nbt) {
        int inputCount = nbt.m_128431_().size() / 3;
        ArrayList<BlockPos> toReturn = new ArrayList<BlockPos>();
        for (int i = 0; i < inputCount; ++i) {
            toReturn.add(new BlockPos(nbt.m_128451_("X" + i), nbt.m_128451_("Y" + i), nbt.m_128451_("Z" + i)));
        }
        return toReturn;
    }

    public float getModifier() {
        return this.getModifierForSignal(this.signal);
    }

    public void neighbourChanged() {
        if (!this.m_58898_()) {
            return;
        }
        int power = this.f_58857_.m_46755_(this.f_58858_);
        if (power != this.signal) {
            this.signalChanged = true;
        }
    }

    public void lazyTick() {
        super.lazyTick();
        this.neighbourChanged();
    }

    public void tick() {
        super.tick();
        this.loadInputs();
        if (this.signalChanged) {
            this.signalChanged = false;
            this.analogSignalChanged(this.f_58857_.m_46755_(this.f_58858_));
        }
        for (int i = 0; i < this.inputs.size(); ++i) {
            BlockPos pos = this.inputs.get(i);
            if (this.f_58857_.m_7702_(pos) instanceof RadialEngineInputBlockEntity) {
                ((RadialEngineInputBlockEntity)this.f_58857_.m_7702_(pos)).setEngine(this);
                if (this.f_58857_.m_8055_(pos).m_61143_((Property)DirectionalBlock.f_52588_) == this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_)) continue;
                this.f_58857_.m_8055_(pos).m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_)));
                continue;
            }
            this.inputs.remove(pos);
        }
        this.calculateUpgradeModifier();
        int random1 = Create.RANDOM.nextInt(125);
        int random2 = Create.RANDOM.nextInt(200);
        if (random1 == 69) {
            this.coolantTank.drain(1, IFluidHandler.FluidAction.EXECUTE);
        }
        if (random2 == 69) {
            this.lubricationOilTank.drain(1, IFluidHandler.FluidAction.EXECUTE);
        }
        int signal = Math.max(this.signal, this.inputSingal);
        ++this.soundTimer;
        if ((double)this.soundTimer >= ((double)(16 - signal) / 0.8 + 1.0) / 8.0 && signal != 0 && this.tankInventory.getFluidAmount() != 0 && !this.overStressed && this.f_58857_.f_46443_) {
            this.makeSound();
        }
        this.updateGeneratedRotation();
        this.calculateEfficiency();
        this.stressBase = this.calculateAddedStressCapacity();
        this.speed = this.getTheoreticalSpeed();
        if (this.speed != this.getGeneratedSpeed() && this.speed != 0.0f) {
            this.stressBase *= this.getGeneratedSpeed() / this.speed;
        }
        this.speed = Math.abs(this.speed);
        this.stressTotal = this.stressBase * this.speed;
    }

    public void calculateUpgradeModifier() {
        float newPowerModifier = 1.0f;
        float newEfficiencyModifier = 1.4f;
        if (this.lubricationOilTank.getFluidAmount() > 0) {
            newEfficiencyModifier -= 0.1f;
        }
        if (this.coolantTank.getFluidAmount() > 0) {
            newPowerModifier += 0.3f;
            newEfficiencyModifier -= 0.3f;
        }
        this.powerModifier = newPowerModifier;
        this.efficiencyModifier = newEfficiencyModifier;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void makeSound() {
        this.soundTimer = 0;
        TFMGSoundEvents.ENGINE.playAt(this.f_58857_, (Vec3i)this.f_58858_, 0.6f, 1.0f, false);
    }

    protected void analogSignalChanged(int newSignal) {
        this.signal = newSignal;
    }

    protected float getModifierForSignal(int newPower) {
        if (newPower == 0) {
            return 1.0f;
        }
        return 1.0f + (float)(newPower + 1) / 16.0f;
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(1000, this::onFluidStackChanged){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_205067_(RadialEngineBlockEntity.this.validFuel());
            }
        };
    }

    protected SmartFluidTank createUpgradeTankInventory(final Fluid validFluid) {
        return new SmartFluidTank(1000, this::onFluidStackChanged){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_6212_(validFluid);
            }
        };
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
    }

    public float getFillState() {
        return (float)this.tankInventory.getFluidAmount() / (float)this.tankInventory.getCapacity();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return super.getCapability(cap, side);
    }

    public void invalidate() {
        super.invalidate();
        this.fluidCapability.invalidate();
    }

    public IFluidTank getTankInventory() {
        return this.tankInventory;
    }

    public TagKey<Fluid> validFuel() {
        return TFMGTags.TFMGFluidTags.GASOLINE.tag;
    }
}

