/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createindustry.blocks.machines.metal_processing.casting_basin;

import com.drmangotea.createindustry.blocks.machines.TFMGMachineBlockEntity;
import com.drmangotea.createindustry.blocks.machines.metal_processing.casting_basin.CastingBasinBlock;
import com.drmangotea.createindustry.blocks.machines.metal_processing.casting_basin.CastingMoldItem;
import com.drmangotea.createindustry.recipes.casting.CastingRecipe;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class CastingBasinBlockEntity
extends TFMGMachineBlockEntity
implements IHaveGoggleInformation {
    public MoldType f_58855_;
    private CastingRecipe recipe;
    public int timer = -1;
    public SmartInventory outputInventory = new SmartInventory(1, (SyncedBlockEntity)this).withMaxStackSize(64);
    public SmartInventory moldInventory = new SmartInventory(1, (SyncedBlockEntity)this).withMaxStackSize(1);
    public LazyOptional<IItemHandlerModifiable> itemCapability = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.outputInventory, this.moldInventory}));
    private static final Object CastingRecipesKey = new Object();

    public CastingBasinBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tank1.getPrimaryHandler().setCapacity(4000);
        this.tank2.forbidExtraction();
        this.tank2.forbidInsertion();
        this.moldInventory.forbidExtraction();
        this.moldInventory.forbidInsertion();
        this.outputInventory.forbidInsertion();
    }

    public void tick() {
        super.tick();
        this.f_58855_ = (MoldType)((Object)this.m_58900_().m_61143_(CastingBasinBlock.MOLD_TYPE));
        this.findRecipe();
        this.setMold();
        this.setCapacity();
        if (this.f_58855_ == MoldType.NONE) {
            return;
        }
        if (this.recipe == null) {
            return;
        }
        if (this.outputInventory.getStackInSlot(0).m_41613_() != 0) {
            return;
        }
        if (this.tank1.getPrimaryHandler().getCapacity() == this.tank1.getPrimaryHandler().getFluidAmount()) {
            if (this.timer == -1) {
                this.timer = this.recipe.getProcessingDuration();
            }
            if (this.timer > 0) {
                --this.timer;
            }
            if (this.timer == 0) {
                if (this.f_58855_ == MoldType.INGOT) {
                    this.outputInventory.setStackInSlot(0, this.recipe.getIngotResult());
                }
                if (this.f_58855_ == MoldType.BLOCK) {
                    this.outputInventory.setStackInSlot(0, this.recipe.getBlockResult());
                }
                this.tank1.getPrimaryHandler().setFluid(new FluidStack(Fluids.f_76191_, 0));
                this.timer = -1;
            }
        }
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.moldInventory);
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.outputInventory);
    }

    public void setMold() {
        MoldType oldMoldType;
        if (this.moldInventory.m_7983_()) {
            return;
        }
        MoldType moldType = ((CastingMoldItem)this.moldInventory.getStackInSlot(0).m_41720_()).getType();
        if (moldType == (oldMoldType = (MoldType)((Object)this.m_58900_().m_61143_(CastingBasinBlock.MOLD_TYPE)))) {
            return;
        }
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(CastingBasinBlock.MOLD_TYPE, (Comparable)((Object)moldType)), 2);
        this.f_58855_ = (MoldType)((Object)this.m_58900_().m_61143_(CastingBasinBlock.MOLD_TYPE));
    }

    public void findRecipe() {
        CastingRecipe recipe;
        CombinedTankWrapper tankIn = new CombinedTankWrapper(new IFluidHandler[]{this.tank1.getPrimaryHandler(), this.tank2.getPrimaryHandler()});
        if (!(this.recipe != null && this.recipe.matches(tankIn, this.f_58857_) || (recipe = this.getMatchingRecipes()) == null)) {
            this.recipe = recipe;
            this.sendData();
        }
    }

    public void setCapacity() {
        if (this.f_58855_ == null) {
            if (this.tank1.getPrimaryHandler().getCapacity() < 4000) {
                this.tank1.getPrimaryHandler().setCapacity(4000);
            }
        } else if (this.tank1.getPrimaryHandler().getCapacity() != this.f_58855_.getRequiredFluidAmount()) {
            this.tank1.getPrimaryHandler().setCapacity(this.f_58855_.getRequiredFluidAmount());
        }
    }

    protected CastingRecipe getMatchingRecipes() {
        List list = RecipeFinder.get((Object)this.getRecipeCacheKey(), (Level)this.f_58857_, this::matchStaticFilters);
        for (int i = 0; i < list.toArray().length; ++i) {
            CastingRecipe recipe = (CastingRecipe)((Object)list.get(i));
            for (int y = 0; y < ((FluidIngredient)recipe.getFluidIngredients().get(0)).getMatchingFluidStacks().toArray().length; ++y) {
                if (this.tank1.getPrimaryHandler().getFluid().getFluid() != ((FluidStack)((FluidIngredient)recipe.getFluidIngredients().get(0)).getMatchingFluidStacks().get(y)).getFluid() || this.tank1.getPrimaryHandler().getFluidAmount() < ((FluidIngredient)recipe.getFluidIngredients().get(0)).getRequiredAmount()) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        LazyOptional handler = this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        Optional resolve = handler.resolve();
        if (!resolve.isPresent()) {
            return false;
        }
        IFluidHandler tank = (IFluidHandler)resolve.get();
        if (tank.getTanks() == 0) {
            return false;
        }
        LangBuilder mb = Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        boolean isEmpty = true;
        for (int i = 0; i < tank.getTanks(); ++i) {
            FluidStack fluidStack = tank.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            Lang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            Lang.builder().add(Lang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.DARK_GREEN)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)tank.getTankCapacity(i)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (tank.getTanks() > 1) {
            if (isEmpty) {
                tooltip.remove(tooltip.size() - 1);
            }
            return true;
        }
        if (!isEmpty) {
            return true;
        }
        Lang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(Lang.number((double)tank.getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GREEN)).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
        return true;
    }

    protected <C extends Container> boolean matchStaticFilters(Recipe<C> r) {
        return r instanceof CastingRecipe;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.outputInventory.deserializeNBT(compound.m_128469_("OutputItems"));
        this.moldInventory.deserializeNBT(compound.m_128469_("CurrentMold"));
        this.timer = compound.m_128451_("Timer");
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("OutputItems", (Tag)this.outputInventory.serializeNBT());
        compound.m_128365_("CurrentMold", (Tag)this.moldInventory.serializeNBT());
        compound.m_128405_("Timer", this.timer);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.itemCapability.invalidate();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemCapability.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    protected Object getRecipeCacheKey() {
        return CastingRecipesKey;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
    }

    public static enum MoldType implements StringRepresentable
    {
        INGOT("ingot", 112),
        BLOCK("block", 1000),
        NONE("none", 4000);

        private final String name;
        private final int fluidAmountNeeded;

        private MoldType(String name, int amountNeeded) {
            this.name = name;
            this.fluidAmountNeeded = amountNeeded;
        }

        public int getRequiredFluidAmount() {
            return this.fluidAmountNeeded;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

