/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createindustry.blocks.machines.oil_processing.pumpjack.base;

import com.drmangotea.createindustry.blocks.machines.oil_processing.pumpjack.crank.PumpjackCrankBlockEntity;
import com.drmangotea.createindustry.blocks.machines.oil_processing.pumpjack.hammer.PumpjackBlockEntity;
import com.drmangotea.createindustry.registry.TFMGBlocks;
import com.drmangotea.createindustry.registry.TFMGFluids;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class PumpjackBaseBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public PumpjackBlockEntity controllerHammer;
    public boolean isRunning = false;
    int depositCheckTimer = 0;
    public int miningRate = 0;
    protected LazyOptional<IFluidHandler> fluidCapability;
    public FluidTank tankInventory = this.createInventory();
    public BlockPos deposit;

    public PumpjackBaseBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidCapability = LazyOptional.of(() -> this.tankInventory);
    }

    public void tick() {
        super.tick();
        if (this.controllerHammer == null || this.controllerHammer.crank != null) {
            // empty if block
        }
        if (this.controllerHammer != null && !(this.f_58857_.m_7702_(this.controllerHammer.m_58899_()) instanceof PumpjackBlockEntity)) {
            this.controllerHammer = null;
        }
        if (this.controllerHammer != null && this.controllerHammer.base == null) {
            this.controllerHammer = null;
        }
        if (this.controllerHammer != null && !this.controllerHammer.isRunning()) {
            this.controllerHammer = null;
        }
        if (this.controllerHammer == null) {
            return;
        }
        this.isRunning = this.controllerHammer.isRunning();
        if (!this.isRunning) {
            this.deposit = null;
            this.controllerHammer = null;
            this.miningRate = 0;
            return;
        }
        ++this.depositCheckTimer;
        if (this.depositCheckTimer > 50) {
            this.depositCheckTimer = 0;
            this.findDeposit();
        }
        PumpjackCrankBlockEntity crank = null;
        if (this.controllerHammer.crank != null) {
            crank = this.controllerHammer.crank;
        }
        if (crank == null) {
            return;
        }
        this.miningRate = (int)Math.abs(crank.getMachineInputSpeed() * crank.heightModifier);
        this.process();
    }

    public void findDeposit() {
        for (int i = 0; i < this.m_58899_().m_123342_() + 64; ++i) {
            BlockPos checkedPos = new BlockPos(this.m_58899_().m_123341_(), this.m_58899_().m_123342_() - 1 - i, this.m_58899_().m_123343_());
            if (this.f_58857_.m_8055_(new BlockPos((Vec3i)checkedPos)).m_60713_((Block)TFMGBlocks.OIL_DEPOSIT.get())) {
                this.deposit = checkedPos;
                return;
            }
            if (this.f_58857_.m_8055_(new BlockPos((Vec3i)checkedPos)).m_60713_((Block)TFMGBlocks.INDUSTRIAL_PIPE.get())) continue;
            this.deposit = null;
            return;
        }
        this.deposit = null;
    }

    public void process() {
        if (this.deposit == null) {
            return;
        }
        if (this.tankInventory.getFluidAmount() + this.miningRate > 8000) {
            return;
        }
        this.tankInventory.setFluid(new FluidStack((Fluid)TFMGFluids.CRUDE_OIL.getSource(), this.tankInventory.getFluidAmount() + this.miningRate));
    }

    public void setControllerHammer(PumpjackBlockEntity controllerHammer) {
        this.controllerHammer = controllerHammer;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(8000, this::onFluidStackChanged){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_6212_((Fluid)TFMGFluids.CRUDE_OIL.getSource());
            }
        };
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        LazyOptional handler;
        Optional resolve;
        Lang.translate((String)"goggles.pumpjack_info", (Object[])new Object[0]).forGoggles(tooltip);
        LangBuilder mb = Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        if (this.deposit == null) {
            Lang.translate((String)"goggles.zero", (Object[])new Object[0]).style(ChatFormatting.DARK_RED).forGoggles(tooltip, 1);
        }
        if (!(resolve = (handler = this.getCapability(ForgeCapabilities.FLUID_HANDLER)).resolve()).isPresent()) {
            return false;
        }
        IFluidHandler tank = (IFluidHandler)resolve.get();
        if (tank.getTanks() == 0) {
            return false;
        }
        boolean isEmpty = true;
        for (int i = 0; i < tank.getTanks(); ++i) {
            FluidStack fluidStack = tank.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            Lang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            Lang.builder().add(Lang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.DARK_GREEN)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)tank.getTankCapacity(i)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (tank.getTanks() > 1) {
            if (isEmpty) {
                tooltip.remove(tooltip.size() - 1);
            }
            return true;
        }
        if (!isEmpty) {
            return true;
        }
        Lang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(Lang.number((double)tank.getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GREEN)).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
        return true;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.tankInventory.readFromNBT(compound.m_128469_("TankContent"));
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128365_("TankContent", (Tag)this.tankInventory.writeToNBT(new CompoundTag()));
        super.write(compound, clientPacket);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }
}

