/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createindustry.blocks.machines.simple.welding_machine;

import com.drmangotea.createindustry.blocks.machines.simple.welding_machine.WeldingBehaviour;
import com.drmangotea.createindustry.blocks.machines.simple.welding_machine.WeldingMachineBlock;
import com.drmangotea.createindustry.blocks.machines.simple.welding_machine.WeldingMachineBlockEntity;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;

public class WeldingMachineInstance
extends BlockEntityInstance<WeldingMachineBlockEntity>
implements DynamicInstance {
    private final OrientedData pressHead;

    public WeldingMachineInstance(MaterialManager materialManager, WeldingMachineBlockEntity blockEntity) {
        super(materialManager, (BlockEntity)blockEntity);
        this.pressHead = (OrientedData)materialManager.defaultSolid().material(Materials.ORIENTED).getModel(AllPartialModels.MECHANICAL_PRESS_HEAD, this.blockState).createInstance();
        Quaternion q = Vector3f.f_122225_.m_122240_(AngleHelper.horizontalAngle((Direction)((Direction)this.blockState.m_61143_((Property)WeldingMachineBlock.f_54117_))));
        this.pressHead.setRotation(q);
        this.transformModels();
    }

    public void beginFrame() {
        this.transformModels();
    }

    private void transformModels() {
        float renderedHeadOffset = this.getRenderedHeadOffset((WeldingMachineBlockEntity)this.blockEntity);
        this.pressHead.setPosition(this.getInstancePosition()).nudge(0.0f, -renderedHeadOffset, 0.0f);
    }

    private float getRenderedHeadOffset(WeldingMachineBlockEntity press) {
        WeldingBehaviour pressingBehaviour = press.getWeldingBehaviour();
        return pressingBehaviour.getRenderedHeadOffset(AnimationTickHolder.getPartialTicks()) * pressingBehaviour.mode.headOffset;
    }

    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.pressHead});
    }

    public void remove() {
        this.pressHead.delete();
    }
}

