/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createindustry.mixins;

import com.drmangotea.createindustry.worldgen.TFMGLayeredPatterns;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.data.DynamicDataProvider;
import com.simibubi.create.infrastructure.worldgen.AllLayerPatterns;
import com.simibubi.create.infrastructure.worldgen.AllOreFeatureConfigEntries;
import com.simibubi.create.infrastructure.worldgen.OreFeatureConfigEntry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={AllOreFeatureConfigEntries.class})
public class AllOreFeatureConfigEntriesMixin {
    @Shadow
    public static final OreFeatureConfigEntry STRIATED_ORES_OVERWORLD = AllOreFeatureConfigEntriesMixin.create("striated_ores_overworld", 32, 0.055555556f, -30, 70).layeredDatagenExt().withLayerPattern(TFMGLayeredPatterns.BAUXITE).withLayerPattern(TFMGLayeredPatterns.LIGNITE).withLayerPattern(TFMGLayeredPatterns.FIRECLAY).withLayerPattern(TFMGLayeredPatterns.GALENA).withLayerPattern(AllLayerPatterns.SCORIA).withLayerPattern(AllLayerPatterns.CINNABAR).withLayerPattern(AllLayerPatterns.MAGNETITE).withLayerPattern(AllLayerPatterns.MALACHITE).withLayerPattern(AllLayerPatterns.LIMESTONE).withLayerPattern(AllLayerPatterns.OCHRESTONE).biomeTag(BiomeTags.f_215817_).parent();
    @Shadow
    public static final OreFeatureConfigEntry STRIATED_ORES_NETHER = AllOreFeatureConfigEntriesMixin.create("striated_ores_nether", 32, 0.055555556f, 40, 90).layeredDatagenExt().withLayerPattern(TFMGLayeredPatterns.SULFUR).withLayerPattern(AllLayerPatterns.SCORIA_NETHER).withLayerPattern(AllLayerPatterns.SCORCHIA_NETHER).biomeTag(BiomeTags.f_207612_).parent();

    private static OreFeatureConfigEntry create(String name, int clusterSize, float frequency, int minHeight, int maxHeight) {
        ResourceLocation id = Create.asResource((String)name);
        OreFeatureConfigEntry configDrivenFeatureEntry = new OreFeatureConfigEntry(id, clusterSize, frequency, minHeight, maxHeight);
        return configDrivenFeatureEntry;
    }

    @Shadow
    public static void fillConfig(ForgeConfigSpec.Builder builder, String namespace) {
        OreFeatureConfigEntry.ALL.forEach((id, entry) -> {
            if (id.m_135827_().equals(namespace)) {
                builder.push(entry.getName());
                entry.addToConfig(builder);
                builder.pop();
            }
        });
    }

    @Shadow
    public static void init() {
    }

    @Shadow
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        RegistryAccess registryAccess = (RegistryAccess)RegistryAccess.f_123049_.get();
        HashMap<ResourceLocation, ConfiguredFeature> configuredFeatures = new HashMap<ResourceLocation, ConfiguredFeature>();
        for (Map.Entry entry : OreFeatureConfigEntry.ALL.entrySet()) {
            OreFeatureConfigEntry.DatagenExtension datagenExt = ((OreFeatureConfigEntry)entry.getValue()).datagenExt();
            if (datagenExt == null) continue;
            configuredFeatures.put((ResourceLocation)entry.getKey(), datagenExt.createConfiguredFeature(registryAccess));
        }
        DynamicDataProvider configuredFeatureProvider = DynamicDataProvider.create((DataGenerator)generator, (String)"Create's Configured Features", (RegistryAccess)registryAccess, (ResourceKey)Registry.f_122881_, configuredFeatures);
        if (configuredFeatureProvider != null) {
            generator.m_236039_(true, (DataProvider)configuredFeatureProvider);
        }
        HashMap<ResourceLocation, PlacedFeature> placedFeatures = new HashMap<ResourceLocation, PlacedFeature>();
        for (Map.Entry entry : OreFeatureConfigEntry.ALL.entrySet()) {
            OreFeatureConfigEntry.DatagenExtension datagenExt = ((OreFeatureConfigEntry)entry.getValue()).datagenExt();
            if (datagenExt == null) continue;
            placedFeatures.put((ResourceLocation)entry.getKey(), datagenExt.createPlacedFeature(registryAccess));
        }
        DynamicDataProvider placedFeatureProvider = DynamicDataProvider.create((DataGenerator)generator, (String)"Create's Placed Features", (RegistryAccess)registryAccess, (ResourceKey)Registry.f_194567_, placedFeatures);
        if (placedFeatureProvider != null) {
            generator.m_236039_(true, (DataProvider)placedFeatureProvider);
        }
        HashMap<ResourceLocation, BiomeModifier> hashMap = new HashMap<ResourceLocation, BiomeModifier>();
        for (Map.Entry entry : OreFeatureConfigEntry.ALL.entrySet()) {
            OreFeatureConfigEntry.DatagenExtension datagenExt = ((OreFeatureConfigEntry)entry.getValue()).datagenExt();
            if (datagenExt == null) continue;
            hashMap.put((ResourceLocation)entry.getKey(), datagenExt.createBiomeModifier(registryAccess));
        }
        DynamicDataProvider biomeModifierProvider = DynamicDataProvider.create((DataGenerator)generator, (String)"Create's Biome Modifiers", (RegistryAccess)registryAccess, (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, hashMap);
        if (biomeModifierProvider != null) {
            generator.m_236039_(true, (DataProvider)biomeModifierProvider);
        }
    }
}

