/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createindustry.registry;

import com.drmangotea.createindustry.CreateTFMG;
import com.drmangotea.createindustry.base.util.TFMGUtils;
import com.drmangotea.createindustry.blocks.concrete.ConcreteFluid;
import com.drmangotea.createindustry.blocks.concrete.ConcreteFluidType;
import com.drmangotea.createindustry.blocks.concrete.asphalt.AsphaltFluid;
import com.drmangotea.createindustry.blocks.fluids.AcidFluidType;
import com.drmangotea.createindustry.blocks.fluids.FlammableFluid;
import com.drmangotea.createindustry.blocks.fluids.FlammableFluidType;
import com.drmangotea.createindustry.blocks.fluids.HotFluidType;
import com.drmangotea.createindustry.blocks.fluids.PlasticFluidType;
import com.drmangotea.createindustry.registry.TFMGTags;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.decoration.palettes.AllPaletteStoneTypes;
import com.simibubi.create.content.fluids.VirtualFluid;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class TFMGFluids {
    public static final ResourceLocation CONCRETE_RL = CreateTFMG.asResource("fluid/liquid_concrete");
    public static final ResourceLocation PLASTIC_STILL_RL = CreateTFMG.asResource("fluid/liquid_plastic_still");
    public static final ResourceLocation PLASTIC_FLOW_RL = CreateTFMG.asResource("fluid/liquid_plastic_flow");
    public static final ResourceLocation ASPHALT_RL = CreateTFMG.asResource("fluid/liquid_asphalt");
    public static final ResourceLocation COOLING_FLUID_STILL_RL = CreateTFMG.asResource("fluid/cooling_fluid_still");
    public static final ResourceLocation COOLING_FLUID_FLOW_RL = CreateTFMG.asResource("fluid/cooling_fluid_flow");
    public static final ResourceLocation SULFURIC_AXID_STILL_RL = CreateTFMG.asResource("fluid/sulfuric_acid_still");
    public static final ResourceLocation SULFURIC_AXID_FLOW_RL = CreateTFMG.asResource("fluid/sulfuric_acid_flow");
    public static final ResourceLocation MOLTEN_STEEL_STILL_RL = CreateTFMG.asResource("fluid/molten_steel_still");
    public static final ResourceLocation MOLTEN_STEEL_FLOW_RL = CreateTFMG.asResource("fluid/molten_steel_flow");
    public static final ResourceLocation MOLTEN_SLAG_STILL_RL = CreateTFMG.asResource("fluid/molten_slag_still");
    public static final ResourceLocation MOLTEN_SLAG_FLOW_RL = CreateTFMG.asResource("fluid/molten_slag_flow");
    public static final FluidEntry<VirtualFluid> AIR = TFMGFluids.gas("air", new TagKey[0]);
    public static final FluidEntry<VirtualFluid> CARBON_DIOXIDE = TFMGFluids.gas("carbon_dioxide", new TagKey[0]);
    public static final FluidEntry<VirtualFluid> ETHYLENE = TFMGFluids.gas("ethylene", new TagKey[0]);
    public static final FluidEntry<VirtualFluid> PROPYLENE = TFMGFluids.gas("propylene", new TagKey[0]);
    public static final FluidEntry<VirtualFluid> PROPANE = TFMGFluids.gas("propane", TFMGTags.TFMGFluidTags.FLAMMABLE.tag);
    public static final FluidEntry<VirtualFluid> BUTANE = TFMGFluids.gas("butane", TFMGTags.TFMGFluidTags.FLAMMABLE.tag);
    public static final FluidEntry<VirtualFluid> LPG = TFMGFluids.gas("lpg", TFMGTags.TFMGFluidTags.LPG.tag, TFMGTags.TFMGFluidTags.FLAMMABLE.tag);
    public static final FluidEntry<VirtualFluid> NEON = TFMGFluids.gas("neon", new TagKey[0]);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> CRUDE_OIL = TFMGFluids.flammableFluid("crude_oil", TFMGTags.TFMGFluidTags.CRUDE_OIL.tag);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> HEAVY_OIL = TFMGFluids.flammableFluid("heavy_oil", TFMGTags.TFMGFluidTags.HEAVY_OIL.tag);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> LUBRICATION_OIL = TFMGFluids.flammableFluid("lubrication_oil", TFMGTags.TFMGFluidTags.FLAMMABLE.tag);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> NAPALM = TFMGFluids.flammableFluid("napalm", TFMGTags.TFMGFluidTags.FLAMMABLE.tag);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> NAPHTHA = TFMGFluids.fuel("naphtha", TFMGTags.TFMGFluidTags.NAPHTHA.tag, TFMGTags.TFMGFluidTags.FLAMMABLE.tag);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> KEROSENE = TFMGFluids.fuel("kerosene", TFMGTags.TFMGFluidTags.KEROSENE.tag, TFMGTags.TFMGFluidTags.FLAMMABLE.tag);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> GASOLINE = TFMGFluids.fuel("gasoline", TFMGTags.TFMGFluidTags.GASOLINE.tag, TFMGTags.TFMGFluidTags.FLAMMABLE.tag);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> DIESEL = TFMGFluids.fuel("diesel", TFMGTags.TFMGFluidTags.DIESEL.tag, TFMGTags.TFMGFluidTags.FLAMMABLE.tag);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> CREOSOTE = TFMGFluids.fuel("creosote", TFMGTags.TFMGFluidTags.FLAMMABLE.tag);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> COOLING_FLUID = ((FluidBuilder)CreateTFMG.REGISTRATE.fluid("cooling_fluid", COOLING_FLUID_STILL_RL, COOLING_FLUID_FLOW_RL, ConcreteFluidType.create(0x333333, () -> Float.valueOf(0.041666668f))).lang("Cooling Fluid").properties(b -> b.viscosity(1000).density(1000)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(10).slopeFindDistance(5).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> SULFURIC_ACID = ((FluidBuilder)CreateTFMG.REGISTRATE.fluid("sulfuric_acid", SULFURIC_AXID_STILL_RL, SULFURIC_AXID_FLOW_RL, AcidFluidType.create(0x333333, () -> Float.valueOf(0.041666668f))).lang("Sulfuric Acid").properties(b -> b.viscosity(1000).density(1000)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(10).slopeFindDistance(5).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> LIQUID_CONCRETE = ((FluidBuilder)CreateTFMG.REGISTRATE.fluid("liquid_concrete", CONCRETE_RL, CONCRETE_RL, ConcreteFluidType.create(0x333333, () -> Float.valueOf(0.041666668f))).lang("Liquid Concrete").properties(b -> b.viscosity(9999).density(9999)).fluidProperties(p -> p.levelDecreasePerBlock(0).tickRate(99999).slopeFindDistance(0).explosionResistance(4.0f)).source(ConcreteFluid.Source::new).bucket().build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> LIQUID_ASPHALT = ((FluidBuilder)CreateTFMG.REGISTRATE.fluid("liquid_asphalt", ASPHALT_RL, ASPHALT_RL, ConcreteFluidType.create(0x333333, () -> Float.valueOf(0.041666668f))).lang("Liquid Asphalt").properties(b -> b.viscosity(9999).density(9999)).fluidProperties(p -> p.levelDecreasePerBlock(0).tickRate(99999).slopeFindDistance(0).explosionResistance(4.0f)).source(AsphaltFluid.Source::new).bucket().build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> LIQUID_PLASTIC = ((FluidBuilder)CreateTFMG.REGISTRATE.fluid("liquid_plastic", PLASTIC_STILL_RL, PLASTIC_FLOW_RL, PlasticFluidType.create(0xC4C4C4, () -> Float.valueOf(0.041666668f))).lang("Liquid Plastic").properties(b -> b.viscosity(1500).density(1000)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(10).slopeFindDistance(2).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.forgeItemTag((String)"buckets/plastic")}).build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MOLTEN_STEEL = ((FluidBuilder)CreateTFMG.REGISTRATE.fluid("molten_steel", MOLTEN_STEEL_STILL_RL, MOLTEN_STEEL_FLOW_RL, HotFluidType.create(0xFBFBBB, () -> Float.valueOf(0.041666668f))).lang("Molten Steel").properties(b -> b.viscosity(1500).density(1000)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(10).slopeFindDistance(2).explosionResistance(100.0f)).tag(new TagKey[]{TFMGTags.TFMGFluidTags.MOLTEN_STEEL.tag}).source(ForgeFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.forgeItemTag((String)"buckets/steel")}).build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MOLTEN_SLAG = ((FluidBuilder)CreateTFMG.REGISTRATE.fluid("molten_slag", MOLTEN_SLAG_STILL_RL, MOLTEN_SLAG_FLOW_RL, HotFluidType.create(0xFBFBBB, () -> Float.valueOf(0.041666668f))).lang("Molten Slag").properties(b -> b.viscosity(1500).density(1000)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(10).slopeFindDistance(2).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.forgeItemTag((String)"buckets/slag")}).build()).register();

    @SafeVarargs
    public static FluidEntry<ForgeFlowingFluid.Flowing> fuel(String name, TagKey<Fluid> ... tags) {
        TagKey[] fuelTag = new TagKey[]{TFMGTags.TFMGFluidTags.FUEL.tag};
        TagKey[] tagsWithFuelTag = new TagKey[tags.length + 1];
        System.arraycopy(tags, 0, tagsWithFuelTag, 0, tags.length);
        System.arraycopy(fuelTag, 0, tagsWithFuelTag, tags.length, 0);
        return TFMGFluids.flammableFluid(name, tags);
    }

    @SafeVarargs
    public static FluidEntry<ForgeFlowingFluid.Flowing> flammableFluid(String name, TagKey<Fluid> ... tags) {
        return ((FluidBuilder)CreateTFMG.REGISTRATE.fluid(name, CreateTFMG.asResource("fluid/" + name + "_still"), CreateTFMG.asResource("fluid/" + name + "_flow"), FlammableFluidType.create(0x606060, () -> Float.valueOf(0.041666668f))).lang(TFMGUtils.fromId(name)).properties(b -> b.viscosity(1000).density(1000)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(10).slopeFindDistance(5).explosionResistance(100.0f)).tag(tags).source(FlammableFluid.Source::new).bucket().tag(new TagKey[]{AllTags.forgeItemTag((String)("buckets/" + name))}).build()).register();
    }

    @SafeVarargs
    public static FluidEntry<VirtualFluid> gas(String name, TagKey<Fluid> ... tags) {
        TagKey tag = FluidTags.create((ResourceLocation)CreateTFMG.asResource(name));
        TagKey<Fluid>[] fluidTags = tags;
        if (tags.length == 0) {
            fluidTags = new TagKey[]{tag};
        }
        return ((FluidBuilder)CreateTFMG.REGISTRATE.virtualFluid(name, CreateTFMG.asResource("fluid/" + name), CreateTFMG.asResource("fluid/" + name)).lang(TFMGUtils.fromId(name)).tag(tags).tag(new TagKey[]{TFMGTags.TFMGFluidTags.GAS.tag}).bucket().lang(TFMGUtils.fromId(name) + " Tank").tag(new TagKey[]{AllTags.forgeItemTag((String)("buckets/" + name))}).build()).register();
    }

    public static void register() {
    }

    public static void registerFluidInteractions() {
        FluidInteractionRegistry.addInteraction((FluidType)((ForgeFlowingFluid.Flowing)COOLING_FLUID.get()).getFluidType(), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ForgeMod.LAVA_TYPE.get(), fluidState -> ((Block)AllPaletteStoneTypes.LIMESTONE.baseBlock.get()).m_49966_()));
    }
}

