/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.listeners.bossbar;

import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.bossevents.CustomBossEvents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.level.Level;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.GenerationTask;
import org.popcraft.chunky.event.task.GenerationTaskUpdateEvent;
import org.popcraft.chunky.platform.ForgeWorld;
import org.popcraft.chunky.platform.World;

public class BossBarTaskUpdateListener
implements Consumer<GenerationTaskUpdateEvent> {
    @Override
    public void accept(GenerationTaskUpdateEvent event) {
        GenerationTask task = event.generationTask();
        Chunky chunky = task.getChunky();
        World world = task.getSelection().world();
        ResourceLocation worldIdentifier = ResourceLocation.m_135820_((String)world.getKey());
        ResourceLocation barIdentifier = ResourceLocation.m_135820_((String)("chunky:progress_" + world.getKey().replace(':', '_')));
        if (worldIdentifier == null || barIdentifier == null || !(world instanceof ForgeWorld)) {
            return;
        }
        MinecraftServer server = ((ForgeWorld)world).getWorld().m_7654_();
        CustomBossEvents bossBarManager = server.m_129901_();
        CustomBossEvent existingBossBar = bossBarManager.m_136297_(barIdentifier);
        CustomBossEvent bossBar = existingBossBar == null ? this.createNewBossBar(bossBarManager, barIdentifier, worldIdentifier) : existingBossBar;
        boolean silent = chunky.getConfig().isSilent();
        if (silent == bossBar.m_8323_()) {
            bossBar.m_8321_(!silent);
        }
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            if (player.m_20310_(2)) {
                bossBar.m_6543_(player);
                continue;
            }
            bossBar.m_6539_(player);
        }
        GenerationTask.Progress progress = task.getProgress();
        bossBar.m_6456_(Component.m_130674_((String)String.format("%s | %s%% | %s:%s:%s", worldIdentifier, String.format("%.2f", Float.valueOf(progress.getPercentComplete())), String.format("%01d", progress.getHours()), String.format("%02d", progress.getMinutes()), String.format("%02d", progress.getSeconds()))));
        bossBar.m_142711_(task.getProgress().getPercentComplete() / 100.0f);
        if (progress.isComplete()) {
            bossBar.m_7706_();
            bossBarManager.m_136302_(bossBar);
        }
    }

    private CustomBossEvent createNewBossBar(CustomBossEvents bossBarManager, ResourceLocation barIdentifier, ResourceLocation worldIdentifier) {
        CustomBossEvent bossBar = bossBarManager.m_136299_(barIdentifier, Component.m_130674_((String)barIdentifier.toString()));
        if (Level.f_46428_.m_135782_().equals((Object)worldIdentifier)) {
            bossBar.m_6451_(BossEvent.BossBarColor.GREEN);
        } else if (Level.f_46429_.m_135782_().equals((Object)worldIdentifier)) {
            bossBar.m_6451_(BossEvent.BossBarColor.RED);
        } else if (Level.f_46430_.m_135782_().equals((Object)worldIdentifier)) {
            bossBar.m_6451_(BossEvent.BossBarColor.PURPLE);
        } else {
            bossBar.m_6451_(BossEvent.BossBarColor.BLUE);
        }
        return bossBar;
    }
}

