/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.tom.createores.Registration;
import com.tom.createores.block.IOBlock;
import com.tom.createores.block.KineticInputBlock;
import com.tom.createores.block.MultiblockBlock;
import com.tom.createores.util.IOBlockType;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public interface MultiblockPart
extends IWrenchable {
    public static NonNullUnaryOperator<BlockBehaviour.Properties> props() {
        return p -> p.m_60978_(10.0f).m_60988_().m_60955_();
    }

    public static NonNullUnaryOperator<BlockBehaviour.Properties> propsGhost() {
        return MultiblockPart.props().andThen(p -> p.m_222994_());
    }

    public InteractionResult onActivate(BlockState var1, Level var2, BlockPos var3, Player var4, InteractionHand var5, BlockHitResult var6);

    public ItemStack pickBlock(BlockGetter var1, BlockPos var2, BlockState var3);

    public static interface MultiblockMainPart
    extends MultiblockPart {
        public MultiblockPartType[][][] getMultiblockLayout();

        default public InteractionResult onWrenched(BlockState state, UseOnContext context) {
            return InteractionResult.PASS;
        }

        default public Vec3i getSize(Direction facing) {
            MultiblockPartType[][][] layout = this.getMultiblockLayout();
            int x = layout[0].length;
            int y = layout.length;
            int z = layout[0][0].length;
            return facing.m_122434_() == Direction.Axis.Z ? new Vec3i(x, y, z) : new Vec3i(z, y, x);
        }

        public Vec3i getStart(Direction var1);

        default public MultiblockPartType getPartTypeAt(Direction facing, int x, int y, int z) {
            Vec3i size = this.getSize(facing);
            switch (facing) {
                case EAST: {
                    int t = x;
                    x = z;
                    z = size.m_123341_() - t - 1;
                    break;
                }
                case NORTH: {
                    break;
                }
                case SOUTH: {
                    x = size.m_123341_() - x - 1;
                    z = size.m_123343_() - z - 1;
                    break;
                }
                case WEST: {
                    int t = x;
                    x = size.m_123343_() - z - 1;
                    z = t;
                    break;
                }
                default: {
                    return null;
                }
            }
            MultiblockPartType[][][] layout = this.getMultiblockLayout();
            return layout[y][z][x];
        }

        default public Direction getGhostDirection(Direction facing, int xIn, int yIn, int zIn) {
            MultiblockPartType[][][] layout = this.getMultiblockLayout();
            for (int x = 0; x < layout[0][0].length; ++x) {
                for (int y = 0; y < layout.length; ++y) {
                    for (int z = 0; z < layout[0].length; ++z) {
                        if (layout[y][z][x] != MultiblockPartType.MAIN) continue;
                        if (y == yIn) {
                            if (x == xIn) {
                                if (z > zIn) {
                                    return Direction.SOUTH;
                                }
                                return Direction.NORTH;
                            }
                            if (x > xIn) {
                                return Direction.EAST;
                            }
                            return Direction.WEST;
                        }
                        if (y > yIn) {
                            return Direction.UP;
                        }
                        return Direction.DOWN;
                    }
                }
            }
            return null;
        }

        default public Direction getBlockRotation(Direction facing, MultiblockPartType part) {
            return facing;
        }

        public static enum MultiblockPartType {
            BLANK(() -> ((MultiblockBlock)Registration.GHOST_BLOCK.get()).m_49966_()),
            MAIN,
            KINETIC(f -> (BlockState)Registration.KINETIC_INPUT.getDefaultState().m_61124_((Property)KineticInputBlock.SHAFT_FACING, (Comparable)f)),
            ITEM_IN(IOBlockType.ITEM_IN),
            ITEM_OUT(IOBlockType.ITEM_OUT),
            FLUID_IN(IOBlockType.FLUID_IN),
            FLUID_OUT(IOBlockType.FLUID_OUT);

            private final Function<Direction, BlockState> stateSupplier;

            private MultiblockPartType() {
                this.stateSupplier = null;
            }

            private MultiblockPartType(Supplier<BlockState> place) {
                this.stateSupplier = __ -> (BlockState)place.get();
            }

            private MultiblockPartType(Function<Direction, BlockState> place) {
                this.stateSupplier = place;
            }

            private MultiblockPartType(IOBlockType type) {
                this(() -> (BlockState)((IOBlock)Registration.IO_BLOCK.get()).m_49966_().m_61124_(IOBlock.TYPE, (Comparable)((Object)type)));
            }

            public BlockState getBlockState(Direction facing) {
                return this.stateSupplier.apply(facing);
            }
        }
    }

    public static interface MultiblockGhostPart
    extends MultiblockPart {
        public static UseOnContext makeCtx(UseOnContext context, BlockPos pos) {
            return new UseOnContext(context.m_43725_(), context.m_43723_(), context.m_43724_(), context.m_43722_(), new BlockHitResult(new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), context.m_43719_(), pos, false));
        }

        default public InteractionResult onWrenched(BlockState state, UseOnContext context) {
            Level level = context.m_43725_();
            BlockPos pos = context.m_8083_();
            for (int i = 0; i < 5 && state.m_60734_() instanceof MultiblockGhostPart; ++i) {
                Direction d = ((MultiblockGhostPart)state.m_60734_()).getParentDir(state);
                pos = pos.m_5484_(d, 1);
                state = level.m_8055_(pos);
            }
            if (state.m_60734_() instanceof MultiblockPart) {
                MultiblockPart d = (MultiblockPart)state.m_60734_();
                if (d instanceof MultiblockGhostPart) {
                    return InteractionResult.PASS;
                }
                return d.onWrenched(state, MultiblockGhostPart.makeCtx(context, pos));
            }
            return InteractionResult.PASS;
        }

        default public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
            Level level = context.m_43725_();
            BlockPos pos = context.m_8083_();
            for (int i = 0; i < 5 && state.m_60734_() instanceof MultiblockGhostPart; ++i) {
                Direction d = ((MultiblockGhostPart)state.m_60734_()).getParentDir(state);
                pos = pos.m_5484_(d, 1);
                state = level.m_8055_(pos);
            }
            if (state.m_60734_() != this && state.m_60734_() instanceof MultiblockPart) {
                MultiblockPart d = (MultiblockPart)state.m_60734_();
                if (d instanceof MultiblockGhostPart) {
                    return InteractionResult.PASS;
                }
                return d.onSneakWrenched(state, MultiblockGhostPart.makeCtx(context, pos));
            }
            return InteractionResult.PASS;
        }

        public Direction getParentDir(BlockState var1);

        default public void destroyParent(Level level, BlockPos pos, BlockState state, Player pPlayer) {
            for (int i = 0; i < 5 && state.m_60734_() instanceof MultiblockGhostPart; ++i) {
                Direction d = ((MultiblockGhostPart)state.m_60734_()).getParentDir(state);
                pos = pos.m_5484_(d, 1);
                state = level.m_8055_(pos);
            }
            if (state.m_60734_() instanceof MultiblockPart && !(state.m_60734_() instanceof MultiblockGhostPart)) {
                level.m_46961_(pos, !pPlayer.m_7500_());
            }
        }

        default public boolean hasParent(BlockState state, LevelReader level, BlockPos pos) {
            BlockState p = level.m_8055_(pos.m_5484_(this.getParentDir(state), 1));
            return p.m_60734_() instanceof MultiblockPart;
        }

        @Override
        default public InteractionResult onActivate(BlockState state, Level level, BlockPos pos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
            for (int i = 0; i < 5 && state.m_60734_() instanceof MultiblockGhostPart; ++i) {
                Direction d = ((MultiblockGhostPart)state.m_60734_()).getParentDir(state);
                pos = pos.m_5484_(d, 1);
                state = level.m_8055_(pos);
            }
            if (state.m_60734_() != this && state.m_60734_() instanceof MultiblockPart) {
                MultiblockPart d = (MultiblockPart)state.m_60734_();
                if (d instanceof MultiblockGhostPart) {
                    return InteractionResult.PASS;
                }
                return d.onActivate(state, level, pos, pPlayer, pHand, new BlockHitResult(new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), pHit.m_82434_(), pos, false));
            }
            return InteractionResult.PASS;
        }

        @Override
        default public ItemStack pickBlock(BlockGetter level, BlockPos pos, BlockState state) {
            for (int i = 0; i < 5 && state.m_60734_() instanceof MultiblockGhostPart; ++i) {
                Direction d = ((MultiblockGhostPart)state.m_60734_()).getParentDir(state);
                pos = pos.m_5484_(d, 1);
                state = level.m_8055_(pos);
            }
            if (state.m_60734_() != this && state.m_60734_() instanceof MultiblockPart) {
                MultiblockPart d = (MultiblockPart)state.m_60734_();
                if (d instanceof MultiblockGhostPart) {
                    return ItemStack.f_41583_;
                }
                return d.pickBlock(level, pos, state);
            }
            return ItemStack.f_41583_;
        }
    }
}

