/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.recipe;

import com.google.gson.JsonObject;
import com.tom.createores.Config;
import java.util.Collection;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.biome.Biome;

public interface IRecipe {
    public static final IRecipe EMPTY = new IRecipe(){

        @Override
        public int getWeight() {
            return Config.generationChance;
        }

        @Override
        public ResourceLocation getRecipeId() {
            return null;
        }

        @Override
        public Component getName() {
            return null;
        }

        @Override
        public boolean canGenerate(ServerLevel lvl, Holder<Biome> b) {
            return true;
        }
    };

    public ResourceLocation getRecipeId();

    public int getWeight();

    public Component getName();

    public boolean canGenerate(ServerLevel var1, Holder<Biome> var2);

    public static enum ThreeState {
        DEFAULT,
        ALWAYS,
        NEVER;

        public static final ThreeState[] VALUES;

        public static ThreeState get(JsonObject json, String name) {
            if (GsonHelper.m_13855_((JsonObject)json, (String)("always" + name), (boolean)false)) {
                return ALWAYS;
            }
            if (GsonHelper.m_13855_((JsonObject)json, (String)("never" + name), (boolean)false)) {
                return NEVER;
            }
            return DEFAULT;
        }

        public void toJson(JsonObject json, String name) {
            switch (this) {
                case ALWAYS: {
                    json.addProperty("always" + name, Boolean.valueOf(true));
                    break;
                }
                case NEVER: {
                    json.addProperty("never" + name, Boolean.valueOf(true));
                    break;
                }
            }
        }

        static {
            VALUES = ThreeState.values();
        }
    }

    public static class RandomizerBuilder
    extends SimpleWeightedRandomList.Builder<IRecipe> {
        public RandomizerBuilder() {
            this.add(EMPTY);
        }

        public void add(IRecipe add) {
            this.m_146271_(add, add.getWeight());
        }

        public void addAll(Collection<? extends IRecipe> add) {
            add.forEach(this::add);
        }
    }

    public static interface IResourceRecipe {
        public ThreeState isFinite();

        public float getMinAmount();

        public float getMaxAmount();
    }
}

