/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.block;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelDataManager;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.extensions.IForgeBlock;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.FramedBlocksAPI;
import xfacthd.framedblocks.api.FramedBlocksClientAPI;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.update.CullingUpdateTracker;
import xfacthd.framedblocks.api.data.CamoContainer;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.ConTexMode;
import xfacthd.framedblocks.api.util.CtmPredicate;
import xfacthd.framedblocks.api.util.FramedBlockData;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;

public interface IFramedBlock
extends EntityBlock,
IForgeBlock {
    public static final String LOCK_MESSAGE = Utils.translationKey("msg", "lock_state");
    public static final Component STATE_LOCKED = Utils.translate("msg", "lock_state.locked").m_130940_(ChatFormatting.RED);
    public static final Component STATE_UNLOCKED = Utils.translate("msg", "lock_state.unlocked").m_130940_(ChatFormatting.GREEN);

    public IBlockType getBlockType();

    public static BlockBehaviour.Properties createProperties(IBlockType type) {
        return IFramedBlock.createProperties(type, Material.f_76320_);
    }

    public static BlockBehaviour.Properties createProperties(IBlockType type, Material material) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_60939_((Material)material).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_60971_(IFramedBlock::isBlockSuffocating).m_60960_(IFramedBlock::isBlockSuffocating);
        if (!type.canOccludeWithSolidCamo()) {
            props.m_60955_();
        }
        return props;
    }

    private static boolean isBlockSuffocating(BlockState state, BlockGetter level, BlockPos pos) {
        return ((IFramedBlock)state.m_60734_()).isSuffocating(state, level, pos);
    }

    @Deprecated(forRemoval=true, since="1.19.3")
    default public Pair<IFramedBlock, BlockItem> createItemBlock() {
        return Pair.of((Object)this, (Object)new BlockItem((Block)this, new Item.Properties().m_41491_(FramedBlocksAPI.getInstance().defaultCreativeTab())));
    }

    default public BlockItem createBlockItem() {
        return (BlockItem)this.createItemBlock().getSecond();
    }

    default public void tryApplyCamoImmediately(Level level, BlockPos pos, @javax.annotation.Nullable LivingEntity placer, ItemStack stack) {
        if (level.m_5776_()) {
            return;
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("BlockEntityTag")) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof FramedBlockEntity) {
                FramedBlockEntity be = (FramedBlockEntity)blockEntity;
                be.checkCamoSolid();
            }
            return;
        }
        if (placer instanceof Player) {
            BlockEntity blockEntity;
            BlockItem item;
            Player player = (Player)placer;
            if (player.m_21205_() != stack) {
                return;
            }
            ItemStack otherStack = player.m_21206_();
            Item item2 = otherStack.m_41720_();
            if ((item2 instanceof BlockItem && !((item = (BlockItem)item2).m_40614_() instanceof IFramedBlock) || otherStack.m_204117_(Tags.Items.DUSTS_GLOWSTONE)) && (blockEntity = level.m_7702_(pos)) instanceof FramedBlockEntity) {
                FramedBlockEntity be = (FramedBlockEntity)blockEntity;
                if (!FramedBlocksAPI.getInstance().isFramedDoubleBlockEntity(be)) {
                    Vec3 hitVec = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                    be.handleInteraction(player, InteractionHand.OFF_HAND, new BlockHitResult(hitVec, Direction.UP, pos, false));
                }
            }
        }
    }

    default public InteractionResult handleUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.getBlockType().canLockState() && hand == InteractionHand.MAIN_HAND && this.lockState(level, pos, player, player.m_21120_(hand))) {
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (player.m_21120_(hand).m_204117_(Utils.WRENCH)) {
            Rotation rot = player.m_6144_() ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
            BlockState newState = this.rotate(state, hit, rot);
            if (newState != state) {
                if (!level.m_5776_()) {
                    level.m_46597_(pos, newState);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.handleInteraction(player, hand, hit);
        }
        return InteractionResult.FAIL;
    }

    default public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getLight(state, level, pos);
    }

    @Deprecated(forRemoval=true)
    default public int getLight(BlockState state, BlockGetter level, BlockPos pos) {
        if (this.getBlockType().canOccludeWithSolidCamo() && !((Boolean)state.m_61143_((Property)FramedProperties.GLOWING)).booleanValue()) {
            return 0;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.getLightValue();
        }
        return 0;
    }

    @Deprecated(forRemoval=true, since="1.19.2")
    default public int getLight(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.getLightValue();
        }
        return 0;
    }

    default public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.getCamoSound(state, level, pos);
    }

    @Deprecated(forRemoval=true)
    default public SoundType getCamoSound(BlockState state, LevelReader level, BlockPos pos) {
        FramedBlockEntity be;
        CamoContainer camo;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && !(camo = (be = (FramedBlockEntity)blockEntity).getCamo()).isEmpty()) {
            return camo.getSoundType();
        }
        return ((Block)this).m_49962_(state);
    }

    default public List<ItemStack> getCamoDrops(List<ItemStack> drops, LootContext.Builder builder) {
        Object object = builder.m_78982_(LootContextParams.f_81462_);
        if (object instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)((Object)object);
            be.addAdditionalDrops(drops, FramedBlocksAPI.getInstance().shouldConsumeCamo());
        }
        return drops;
    }

    default public CtmPredicate getCtmPredicate() {
        return this.getBlockType().getCtmPredicate();
    }

    default public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, @javax.annotation.Nullable BlockState queryState, @javax.annotation.Nullable BlockPos queryPos) {
        Block block;
        Direction conFace;
        BlockState air = Blocks.f_50016_.m_49966_();
        if (!FMLEnvironment.dist.isClient()) {
            return air;
        }
        ConTexMode mode = FramedBlocksClientAPI.getInstance().getConTexMode();
        if (mode == ConTexMode.NONE) {
            return air;
        }
        CtmPredicate pred = this.getCtmPredicate();
        if (mode.atleast(ConTexMode.FULL_FACE) && pred.test(state, side)) {
            return IFramedBlock.getCamo(level, pos, side, air);
        }
        if (mode.atleast(ConTexMode.FULL_CON_FACE) && queryPos != null && pred.test(state, conFace = Direction.m_175360_((BlockPos)queryPos.m_121996_((Vec3i)pos)))) {
            return IFramedBlock.getCamo(level, pos, conFace, air);
        }
        if (mode == ConTexMode.DETAILED && queryPos != null && !queryPos.equals((Object)pos) && (block = level.m_8055_(queryPos).m_60734_()) instanceof IFramedBlock) {
            IFramedBlock block2 = (IFramedBlock)block;
            Direction conFace2 = Direction.m_175360_((BlockPos)queryPos.m_121996_((Vec3i)pos));
            if (conFace2 != null && IFramedBlock.isSideHiddenInModelData(level, pos, block2, conFace2)) {
                return IFramedBlock.getCamo(level, pos, conFace2, air);
            }
        }
        return air;
    }

    private static boolean isSideHiddenInModelData(BlockAndTintGetter level, BlockPos pos, IFramedBlock block, Direction side) {
        ModelDataManager manager = level.getModelDataManager();
        if (manager == null) {
            return false;
        }
        ModelData data = manager.getAt(pos);
        if (data == null) {
            return false;
        }
        if (block.getBlockType().isDoubleBlock()) {
            return false;
        }
        FramedBlockData fbData = (FramedBlockData)data.get(FramedBlockData.PROPERTY);
        return fbData != null && fbData.isSideHidden(side);
    }

    private static BlockState getCamo(BlockAndTintGetter level, BlockPos pos, Direction side, BlockState air) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.getCamo(side).getState();
        }
        return air;
    }

    default public boolean isSideHidden(BlockGetter level, BlockPos pos, BlockState state, Direction side) {
        IFramedBlock block;
        if (level == null) {
            return false;
        }
        BlockPos neighborPos = pos.m_121945_(side);
        BlockState neighborState = level.m_8055_(neighborPos);
        Block block2 = neighborState.m_60734_();
        if (block2 instanceof IFramedBlock && (block = (IFramedBlock)block2).shouldPreventNeighborCulling(level, neighborPos, neighborState, pos, state)) {
            return false;
        }
        if (neighborState.m_60804_(level, neighborPos)) {
            return false;
        }
        SideSkipPredicate pred = FramedBlocksAPI.getInstance().detailedCullingEnabled() ? this.getBlockType().getSideSkipPredicate() : SideSkipPredicate.CTM;
        return pred.test(level, pos, state, neighborState, side);
    }

    default public boolean shouldPreventNeighborCulling(BlockGetter level, BlockPos pos, BlockState state, BlockPos adjPos, BlockState adjState) {
        if (!FramedBlocksAPI.getInstance().enableIntangibility() || this.isIntangible(adjState, level, adjPos, null)) {
            return false;
        }
        if (this.getBlockType().allowMakingIntangible()) {
            return this.isIntangible(state, level, pos, null);
        }
        return false;
    }

    default public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.getCamoSlipperiness(state, level, pos, entity);
    }

    @Deprecated(forRemoval=true)
    default public float getCamoSlipperiness(BlockState state, LevelReader level, BlockPos pos, @javax.annotation.Nullable Entity entity) {
        FramedBlockEntity be;
        CamoContainer camo;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && !(camo = (be = (FramedBlockEntity)blockEntity).getCamo(Direction.UP)).isEmpty()) {
            return camo.getState().getFriction(level, pos, entity);
        }
        return state.m_60734_().m_49958_();
    }

    default public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.getCamoExplosionResistance(state, level, pos, explosion);
    }

    @Deprecated(forRemoval=true)
    default public float getCamoExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        FramedBlockEntity be;
        float resistance;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && (resistance = (be = (FramedBlockEntity)blockEntity).getCamoExplosionResistance(explosion)) > 0.0f) {
            return resistance;
        }
        return state.m_60734_().m_7325_();
    }

    default public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.isCamoFlammable(level, pos, face);
    }

    @Deprecated(forRemoval=true)
    default public boolean isCamoFlammable(BlockGetter level, BlockPos pos, Direction face) {
        if (FramedBlocksAPI.getInstance().areBlocksFireproof()) {
            return false;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.isCamoFlammable(face);
        }
        return true;
    }

    default public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getCamoFlammability(level, pos, face);
    }

    @Deprecated(forRemoval=true)
    default public int getCamoFlammability(BlockGetter level, BlockPos pos, Direction face) {
        FramedBlockEntity be;
        int flammability;
        if (FramedBlocksAPI.getInstance().areBlocksFireproof()) {
            return 0;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && (flammability = (be = (FramedBlockEntity)blockEntity).getCamoFlammability(face)) > -1) {
            return flammability;
        }
        return 20;
    }

    default public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        FramedBlockEntity be;
        int spreadSpeed;
        if (FramedBlocksAPI.getInstance().areBlocksFireproof()) {
            return 0;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && (spreadSpeed = (be = (FramedBlockEntity)blockEntity).getCamoFireSpreadSpeed(face)) > -1) {
            return spreadSpeed;
        }
        return 5;
    }

    default public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }

    default public boolean isIntangible(BlockState state, BlockGetter level, BlockPos pos, @javax.annotation.Nullable CollisionContext ctx) {
        FramedBlockEntity be;
        if (!FramedBlocksAPI.getInstance().enableIntangibility() || !this.getBlockType().allowMakingIntangible()) {
            return false;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        return blockEntity instanceof FramedBlockEntity && (be = (FramedBlockEntity)blockEntity).isIntangible(ctx);
    }

    default public boolean isSuffocating(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState stateAtPos;
        if (FramedBlocksAPI.getInstance().enableIntangibility() && this.getBlockType().allowMakingIntangible() && (state != (stateAtPos = level.m_8055_(pos)) || this.isIntangible(state, level, pos, null))) {
            return false;
        }
        return state.m_60767_().m_76334_() && state.m_60838_(level, pos);
    }

    default public boolean useCamoOcclusionShapeForLightOcclusion(BlockState state) {
        if (this.getBlockType() != null && !this.getBlockType().canOccludeWithSolidCamo()) {
            return false;
        }
        return state.m_61138_((Property)FramedProperties.SOLID) && (Boolean)state.m_61143_((Property)FramedProperties.SOLID) != false && (Boolean)state.m_61143_((Property)FramedProperties.GLOWING) == false;
    }

    default public VoxelShape getCamoOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        if (this.getBlockType().canOccludeWithSolidCamo() && !((Boolean)state.m_61143_((Property)FramedProperties.SOLID)).booleanValue()) {
            return Shapes.m_83040_();
        }
        return state.m_60808_(level, pos);
    }

    default public VoxelShape getCamoVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (this.getBlockType().canOccludeWithSolidCamo() && !((Boolean)state.m_61143_((Property)FramedProperties.SOLID)).booleanValue()) {
            return Shapes.m_83040_();
        }
        return state.m_60742_(level, pos, ctx);
    }

    default public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return this.doesHideNeighborFace(level, pos, state, neighborState, dir);
    }

    @Deprecated(forRemoval=true)
    default public boolean doesHideNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        if (!FramedBlocksAPI.getInstance().canHideNeighborFaceInLevel(level)) {
            return false;
        }
        if (neighborState.m_60734_() instanceof IFramedBlock) {
            return false;
        }
        if (this.shouldPreventNeighborCulling(level, pos, state, pos.m_121945_(dir), neighborState)) {
            return false;
        }
        BlockEntity blockEntity = level.getExistingBlockEntity(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            if (neighborState.m_60734_() instanceof HalfTransparentBlock && SideSkipPredicate.CTM.test(level, pos, state, neighborState, dir)) {
                return true;
            }
            return be.isSolidSide(dir) && !be.isIntangible(null);
        }
        return false;
    }

    default public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        this.onStateChange(level, pos, oldState, newState);
    }

    @Deprecated(forRemoval=true)
    default public void onStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        BlockEntity blockEntity;
        if (level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            be.m_155250_(newState);
            this.onStateChangeClient(level, pos, oldState, newState, be);
        }
    }

    @Deprecated(forRemoval=true)
    default public void onStateChangeClient(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState, FramedBlockEntity be) {
    }

    @Deprecated(forRemoval=true)
    default public void updateCulling(LevelAccessor level, BlockPos pos, @javax.annotation.Nullable BlockState neighborState, @javax.annotation.Nullable Direction side, boolean rerender) {
        this.updateCulling((LevelReader)level, pos);
    }

    default public void updateCulling(LevelReader level, BlockPos pos) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && level instanceof Level) {
            Level realLevel = (Level)level;
            CullingUpdateTracker.enqueueCullingUpdate(realLevel, pos);
        } else if (level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            be.updateCulling(true, false);
        }
    }

    default public boolean needCullingUpdateAfterStateChange(LevelReader level, BlockState oldState, BlockState newState) {
        if (!level.m_5776_() || oldState.m_60734_() != newState.m_60734_()) {
            return false;
        }
        if (this.getBlockType().canOccludeWithSolidCamo()) {
            if (oldState.m_61124_((Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf((Boolean)oldState.m_61143_((Property)FramedProperties.SOLID) == false)) == newState) {
                return false;
            }
            if (oldState.m_61124_((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf((Boolean)oldState.m_61143_((Property)FramedProperties.GLOWING) == false)) == newState) {
                return false;
            }
        }
        return true;
    }

    default public boolean lockState(Level level, BlockPos pos, Player player, ItemStack stack) {
        if (stack.m_41720_() != Utils.FRAMED_KEY.get()) {
            return false;
        }
        if (!level.m_5776_()) {
            BlockState state = level.m_8055_(pos);
            boolean locked = (Boolean)state.m_61143_((Property)FramedProperties.STATE_LOCKED);
            player.m_5661_((Component)Component.m_237110_((String)LOCK_MESSAGE, (Object[])new Object[]{locked ? STATE_UNLOCKED : STATE_LOCKED}), true);
            level.m_46597_(pos, (BlockState)state.m_61122_((Property)FramedProperties.STATE_LOCKED));
        }
        return true;
    }

    default public BlockState updateShapeLockable(BlockState state, LevelAccessor level, BlockPos pos, Supplier<BlockState> updateShape) {
        if (!((Boolean)state.m_61143_((Property)FramedProperties.STATE_LOCKED)).booleanValue()) {
            return updateShape.get();
        }
        if (this.getBlockType().supportsWaterLogging() && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return state;
    }

    default public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        return this.rotate(state, hit.m_82434_(), rot);
    }

    default public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        return state.m_60717_(rot);
    }

    default public MaterialColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MaterialColor defaultColor) {
        return this.getCamoMapColor(level, pos, defaultColor);
    }

    @Deprecated(forRemoval=true)
    default public MaterialColor getCamoMapColor(BlockGetter level, BlockPos pos, MaterialColor defaultColor) {
        FramedBlockEntity be;
        MaterialColor color;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && (color = (be = (FramedBlockEntity)blockEntity).getMapColor()) != null) {
            return color;
        }
        return defaultColor;
    }

    default public float[] getBeaconColorMultiplier(BlockState state, LevelReader level, BlockPos pos, BlockPos beaconPos) {
        if (!this.doesBlockOccludeBeaconBeam(state, level, pos)) {
            return null;
        }
        return this.getCamoBeaconColorMultiplier(level, pos, beaconPos);
    }

    default public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        return false;
    }

    @Deprecated(forRemoval=true)
    default public float[] getCamoBeaconColorMultiplier(LevelReader level, BlockPos pos, BlockPos beaconPos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.getCamoBeaconColorMultiplier(level, pos, beaconPos);
        }
        return null;
    }

    default public boolean canCamoSustainPlant(BlockState state, BlockGetter level, BlockPos pos, Direction side, IPlantable plant) {
        BlockEntity blockEntity;
        if (state.m_60659_(level, pos, side, SupportType.FULL) && (blockEntity = level.m_7702_(pos)) instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            if (!be.isSolidSide(side)) {
                return false;
            }
            BlockState camoState = be.getCamo(side).getState();
            return camoState.m_204336_(Utils.CAMO_SUSTAIN_PLANT) && camoState.canSustainPlant(level, pos, side, plant);
        }
        return false;
    }

    default public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter level, BlockPos pos, FluidState fluid) {
        BlockEntity blockEntity;
        if (!this.getBlockType().canOccludeWithSolidCamo()) {
            return false;
        }
        if (!((Boolean)state.m_61143_((Property)FramedProperties.SOLID)).booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.shouldCamoDisplayFluidOverlay(level, pos, fluid);
        }
        return false;
    }

    default public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        FramedBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && (be = (FramedBlockEntity)blockEntity).doesCamoPreventDestructionByEntity(entity)) {
            return false;
        }
        return super.canEntityDestroy(state, level, pos, entity);
    }

    default public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedBlockEntity(pos, state);
    }

    default public Optional<MutableComponent> printCamoBlock(CompoundTag beTag) {
        BlockState camoState = CamoContainer.load(beTag.m_128469_("camo")).getState();
        if (camoState.m_60795_()) {
            return Optional.empty();
        }
        return Optional.of(camoState.m_60734_().m_49954_().m_130940_(ChatFormatting.WHITE));
    }

    public static boolean toggleYSlope(BlockState state, Level level, BlockPos pos, Player player) {
        if (player.m_21205_().m_41720_() == Utils.FRAMED_WRENCH.get()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE) == false)));
            return true;
        }
        return false;
    }
}

