/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.pane;

import com.google.common.base.Preconditions;
import com.mojang.math.Vector3f;
import fuzs.diagonalwindows.api.world.level.block.DiagonalBlock;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.pane.FramedPaneModel;

public class FramedDiagonalPaneModel
extends FramedPaneModel {
    private final boolean northEast;
    private final boolean southEast;
    private final boolean northWest;
    private final boolean southWest;
    private final boolean noPillar;

    FramedDiagonalPaneModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        boolean hasProps = state.m_60734_() instanceof DiagonalBlock && ((DiagonalBlock)state.m_60734_()).hasProperties();
        this.northEast = hasProps && (Boolean)state.m_61143_((Property)DiagonalBlock.NORTH_EAST) != false;
        this.southEast = hasProps && (Boolean)state.m_61143_((Property)DiagonalBlock.SOUTH_EAST) != false;
        this.northWest = hasProps && (Boolean)state.m_61143_((Property)DiagonalBlock.NORTH_WEST) != false;
        this.southWest = hasProps && (Boolean)state.m_61143_((Property)DiagonalBlock.SOUTH_WEST) != false;
        this.noPillar = this.northEast && this.southWest && !this.southEast && !this.northWest || this.southEast && this.northWest && !this.northEast && !this.southWest;
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        super.transformQuad(quadMap, quad);
        Direction face = quad.m_111306_();
        if (Utils.isY(face)) {
            if (this.northEast) {
                FramedDiagonalPaneModel.createDiagonalTopBottomEdgeQuad(quadMap, quad, Direction.NORTH, this.noPillar);
            }
            if (this.southEast) {
                FramedDiagonalPaneModel.createDiagonalTopBottomEdgeQuad(quadMap, quad, Direction.EAST, this.noPillar);
            }
            if (this.southWest) {
                FramedDiagonalPaneModel.createDiagonalTopBottomEdgeQuad(quadMap, quad, Direction.SOUTH, this.noPillar);
            }
            if (this.northWest) {
                FramedDiagonalPaneModel.createDiagonalTopBottomEdgeQuad(quadMap, quad, Direction.WEST, this.noPillar);
            }
        } else {
            if (this.isDiagonalSideNotInset(face)) {
                FramedDiagonalPaneModel.createDiagonalSideEdgeQuad(quadMap, quad);
            }
            if (Utils.isX(face)) {
                if (this.northEast) {
                    FramedDiagonalPaneModel.createDiagonalSideQuad(quadMap.get(null), quad, Direction.NORTH, this.noPillar);
                }
                if (this.southWest) {
                    FramedDiagonalPaneModel.createDiagonalSideQuad(quadMap.get(null), quad, Direction.SOUTH, this.noPillar);
                }
            }
            if (Utils.isZ(face)) {
                if (this.southEast) {
                    FramedDiagonalPaneModel.createDiagonalSideQuad(quadMap.get(null), quad, Direction.EAST, this.noPillar);
                }
                if (this.northWest) {
                    FramedDiagonalPaneModel.createDiagonalSideQuad(quadMap.get(null), quad, Direction.WEST, this.noPillar);
                }
            }
        }
    }

    @Override
    protected boolean isPillarVisible() {
        return !this.noPillar;
    }

    protected static void createDiagonalTopBottomEdgeQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction dir, boolean noPillar) {
        Preconditions.checkArgument((!Utils.isY(dir) ? 1 : 0) != 0, (Object)String.format("Invalid direction: %s!", dir));
        QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(dir.m_122424_(), noPillar ? 0.5f : 0.4375f)).apply(Modifiers.cutTopBottom(dir.m_122427_().m_122434_(), 0.5625f)).apply(FramedDiagonalPaneModel.rotate(dir)).export(quadMap.get(null));
    }

    protected static void createDiagonalSideEdgeQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(0.5625f)).apply(FramedDiagonalPaneModel.rotate(quad.m_111306_())).export(quadMap.get(null));
    }

    private static void createDiagonalSideQuad(List<BakedQuad> quadList, BakedQuad quad, Direction dir, boolean noPillar) {
        QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(dir.m_122424_(), noPillar ? 0.5f : 0.4375f)).apply(Modifiers.setPosition(0.5625f)).apply(FramedDiagonalPaneModel.rotate(dir)).export(quadList);
    }

    protected boolean isDiagonalSideNotInset(Direction face) {
        return switch (face) {
            case Direction.NORTH -> this.northEast;
            case Direction.EAST -> this.southEast;
            case Direction.SOUTH -> this.southWest;
            case Direction.WEST -> this.northWest;
            default -> throw new IllegalArgumentException(String.format("Invalid face: %s!", face));
        };
    }

    private static QuadModifier.Modifier rotate(Direction dir) {
        return Modifiers.rotateCentered(Direction.Axis.Y, -45.0f, true, new Vector3f((float)dir.m_122429_(), 1.0f, (float)dir.m_122431_()));
    }
}

