/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopepanel;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.slopepanel.FramedSlopePanelModel;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedFlatSlopePanelCornerModel
extends FramedBlockModel {
    private final Direction facing;
    private final HorizontalRotation rotation;
    private final HorizontalRotation rotRotation;
    private final Direction orientation;
    private final Direction rotOrientation;
    private final boolean front;
    private final boolean ySlope;

    public FramedFlatSlopePanelCornerModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        this.rotRotation = this.rotation.rotate(Rotation.COUNTERCLOCKWISE_90);
        this.orientation = this.rotation.withFacing(this.facing);
        this.rotOrientation = this.rotRotation.withFacing(this.facing);
        this.front = (Boolean)state.m_61143_((Property)PropertyHolder.FRONT);
        this.ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction face = quad.m_111306_();
        if (face == this.orientation.m_122424_()) {
            FramedFlatSlopePanelCornerModel.createSideTriangle(quadMap, quad, this.facing, this.rotRotation, this.front, false);
        } else if (face == this.rotOrientation.m_122424_()) {
            FramedFlatSlopePanelCornerModel.createSideTriangle(quadMap, quad, this.facing, this.rotation, this.front, false);
        } else if (face == this.facing.m_122424_()) {
            if (!this.ySlope || !Utils.isY(this.orientation)) {
                QuadModifier.geometry(quad).apply(FramedFlatSlopePanelCornerModel.createSlopeTriangle(this.facing, this.orientation, false)).apply(FramedSlopePanelModel.createSlope(this.facing, this.orientation)).applyIf(Modifiers.offset(this.facing, 0.5f), !this.front).export(quadMap.get(null));
            }
            if (!this.ySlope || !Utils.isY(this.rotOrientation)) {
                QuadModifier.geometry(quad).apply(FramedFlatSlopePanelCornerModel.createSlopeTriangle(this.facing, this.rotOrientation, true)).apply(FramedSlopePanelModel.createSlope(this.facing, this.rotOrientation)).applyIf(Modifiers.offset(this.facing, 0.5f), !this.front).export(quadMap.get(null));
            }
        } else if (this.ySlope && Utils.isY(this.orientation) && face == this.orientation) {
            QuadModifier.geometry(quad).apply(FramedFlatSlopePanelCornerModel.createVerticalSlopeTriangle(this.facing, this.orientation, false)).apply(FramedSlopePanelModel.createVerticalSlope(this.facing, this.orientation)).applyIf(Modifiers.offset(this.facing.m_122424_(), 0.5f), this.front).export(quadMap.get(null));
        } else if (this.ySlope && Utils.isY(this.rotOrientation) && face == this.rotOrientation) {
            QuadModifier.geometry(quad).apply(FramedFlatSlopePanelCornerModel.createVerticalSlopeTriangle(this.facing, this.rotOrientation, true)).apply(FramedSlopePanelModel.createVerticalSlope(this.facing, this.rotOrientation)).applyIf(Modifiers.offset(this.facing.m_122424_(), 0.5f), this.front).export(quadMap.get(null));
        } else if (face == this.facing && this.front) {
            QuadModifier.geometry(quad).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
        }
    }

    public static QuadModifier.Modifier createSlopeTriangle(Direction facing, Direction orientation, boolean second) {
        if (Utils.isY(orientation)) {
            boolean down = orientation == Direction.UP;
            float right = down != second ? 0.0f : 1.0f;
            float left = down != second ? 1.0f : 0.0f;
            return Modifiers.cutSideUpDown(down, right, left);
        }
        boolean right = orientation == facing.m_122427_();
        float top = right != second ? 0.0f : 1.0f;
        float bot = right != second ? 1.0f : 0.0f;
        return Modifiers.cutSideLeftRight(right, top, bot);
    }

    public static QuadModifier.Modifier createVerticalSlopeTriangle(Direction facing, Direction orientation, boolean second) {
        boolean down = orientation == Direction.DOWN;
        float right = second == down ? 0.0f : 1.0f;
        float left = second == down ? 1.0f : 0.0f;
        return Modifiers.cutTopBottom(facing.m_122424_(), right, left);
    }

    public static void createSideTriangle(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction facing, HorizontalRotation rotation, boolean front, boolean extended) {
        Direction face = quad.m_111306_();
        Direction orientation = rotation.withFacing(facing);
        boolean yAxis = Utils.isY(orientation);
        if (yAxis) {
            float top;
            boolean up;
            boolean bl = up = orientation == Direction.UP;
            float f = up ? (front ? 0.5f : 0.0f) : (top = front ? 1.0f : 0.5f);
            float bottom = up ? (front ? 1.0f : 0.5f) : (front ? 0.5f : 0.0f);
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(facing.m_122424_(), top, bottom)).applyIf(Modifiers.cutSideLeftRight(facing, 0.5f), front && !extended).export(quadMap.get(face));
        } else {
            float right;
            boolean rightRot;
            boolean bl = rightRot = rotation == HorizontalRotation.RIGHT;
            float f = rightRot ? (front ? 1.0f : 0.5f) : (right = front ? 0.5f : 0.0f);
            float left = rightRot ? (front ? 0.5f : 0.0f) : (front ? 1.0f : 0.5f);
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(facing.m_122424_(), right, left)).applyIf(Modifiers.cutTopBottom(facing, 0.5f), front && !extended).export(quadMap.get(face));
        }
    }

    @Override
    protected void applyInHandTransformation(PoseStack poseStack, ItemTransforms.TransformType type) {
        poseStack.m_85837_(0.0, 0.5, 0.0);
    }

    public static BlockState itemSource() {
        return (BlockState)((BlockState)((Block)FBContent.blockFramedFlatSlopePanelCorner.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH)).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)HorizontalRotation.RIGHT));
    }
}

