/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.common.block.interactive.FramedSignBlock;
import xfacthd.framedblocks.common.blockentity.FramedSignBlockEntity;

public class FramedSignRenderer
implements BlockEntityRenderer<FramedSignBlockEntity> {
    private static final int OUTLINE_RENDER_DISTANCE = Mth.m_144944_((int)16);
    private final Font fontrenderer;

    public FramedSignRenderer(BlockEntityRendererProvider.Context ctx) {
        this.fontrenderer = ctx.m_173586_();
    }

    public void render(FramedSignBlockEntity tile, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int light, int overlay) {
        int textLight;
        int outlineColor;
        int textColor;
        boolean showOutline;
        matrix.m_85836_();
        BlockState state = tile.m_58900_();
        if (state.m_60734_() instanceof FramedSignBlock) {
            matrix.m_85837_(0.5, 0.5, 0.5);
            rot = -((float)((Integer)state.m_61143_((Property)BlockStateProperties.f_61390_) * 360) / 16.0f);
            matrix.m_85845_(Vector3f.f_122225_.m_122240_(rot));
        } else {
            matrix.m_85837_(0.5, 0.5, 0.5);
            rot = -((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)).m_122435_();
            matrix.m_85845_(Vector3f.f_122225_.m_122240_(rot));
            matrix.m_85837_(0.0, -0.3125, -0.4375);
        }
        matrix.m_85837_(0.0, 0.33, 0.065);
        matrix.m_85841_(0.01f, -0.01f, 0.01f);
        if (tile.hasGlowingText()) {
            showOutline = FramedSignRenderer.showOutline(tile);
            textColor = tile.getTextColor().m_41071_();
            outlineColor = FramedSignRenderer.getDarkTextColor(tile);
            textLight = 0xF000F0;
        } else {
            showOutline = false;
            textColor = FramedSignRenderer.getDarkTextColor(tile);
            outlineColor = 0;
            textLight = light;
        }
        for (int line = 0; line < 4; ++line) {
            FormattedCharSequence text = tile.getRenderedLine(line, component -> {
                List parts = this.fontrenderer.m_92923_((FormattedText)component, 90);
                return parts.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)parts.get(0);
            });
            if (text == null) continue;
            float xOff = (float)(-this.fontrenderer.m_92724_(text)) / 2.0f;
            float y = line * 10 - 20;
            if (showOutline) {
                this.fontrenderer.m_168645_(text, xOff, y, textColor, outlineColor, matrix.m_85850_().m_85861_(), buffer, textLight);
                continue;
            }
            this.fontrenderer.m_92733_(text, xOff, y, textColor, false, matrix.m_85850_().m_85861_(), buffer, false, 0, textLight);
        }
        matrix.m_85849_();
    }

    private static int getDarkTextColor(FramedSignBlockEntity sign) {
        int color = sign.getTextColor().m_41071_();
        if (color == DyeColor.BLACK.m_41071_() && sign.hasGlowingText()) {
            return -988212;
        }
        int r = (int)((double)NativeImage.m_85085_((int)color) * 0.4);
        int g = (int)((double)NativeImage.m_85103_((int)color) * 0.4);
        int b = (int)((double)NativeImage.m_85119_((int)color) * 0.4);
        return NativeImage.m_84992_((int)0, (int)b, (int)g, (int)r);
    }

    private static boolean showOutline(FramedSignBlockEntity sign) {
        if (sign.getTextColor().m_41071_() == DyeColor.BLACK.m_41071_()) {
            return true;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && mc.f_91066_.m_92176_().m_90612_() && mc.f_91074_.m_150108_()) {
            return true;
        }
        Entity camera = mc.m_91288_();
        return camera != null && camera.m_20238_(Vec3.m_82512_((Vec3i)sign.m_58899_())) < (double)OUTLINE_RENDER_DISTANCE;
    }
}

