/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen.overlay;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.screen.overlay.BlockInteractOverlay;
import xfacthd.framedblocks.client.util.ClientConfig;
import xfacthd.framedblocks.common.FBContent;

public final class CamoRotationOverlay
extends BlockInteractOverlay {
    public static final Component ROTATEABLE_FALSE = Utils.translate("tooltip", "camo_rotation.false");
    public static final Component ROTATEABLE_TRUE = Utils.translate("tooltip", "camo_rotation.true");
    private static final ResourceLocation SYMBOL_TEXTURE = Utils.rl("textures/overlay/camo_rotation_symbols.png");
    private static final BlockInteractOverlay.Texture TEXTURE_FALSE = new BlockInteractOverlay.Texture(SYMBOL_TEXTURE, 0, 0, 22, 22, 44, 22);
    private static final BlockInteractOverlay.Texture TEXTURE_TRUE = new BlockInteractOverlay.Texture(SYMBOL_TEXTURE, 22, 0, 22, 22, 44, 22);

    public CamoRotationOverlay() {
        super(List.of(ROTATEABLE_FALSE), List.of(ROTATEABLE_TRUE), TEXTURE_FALSE, TEXTURE_TRUE, () -> ClientConfig.camoRotationMode);
    }

    @Override
    protected boolean isValidTool(ItemStack stack) {
        return stack.m_41720_() == FBContent.itemFramedScrewdriver.get();
    }

    @Override
    protected boolean isValidTarget(BlockInteractOverlay.Target target) {
        return target.state().m_60734_() instanceof IFramedBlock;
    }

    @Override
    protected boolean getState(BlockInteractOverlay.Target target) {
        BlockEntity blockEntity = CamoRotationOverlay.level().m_7702_(target.pos());
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            HitResult hit = Minecraft.m_91087_().f_91077_;
            if (hit instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)hit;
                return be.getCamo(blockHit).canRotateCamo();
            }
        }
        return false;
    }
}

