/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopeslab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedSlopeSlabBlock;
import xfacthd.framedblocks.common.blockentity.FramedFlatInverseDoubleSlopeSlabCornerBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedFlatInverseDoubleSlopeSlabCornerBlock
extends AbstractFramedDoubleBlock {
    public FramedFlatInverseDoubleSlopeSlabCornerBlock() {
        super(BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, BlockStateProperties.f_61362_, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = FramedFlatInverseDoubleSlopeSlabCornerBlock.withCornerFacing(this.m_49966_(), context.m_43719_(), context.m_8125_(), context.m_43720_());
        state = FramedFlatInverseDoubleSlopeSlabCornerBlock.withTop(state, context.m_43719_(), context.m_43720_());
        return FramedFlatInverseDoubleSlopeSlabCornerBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction face = hit.m_82434_();
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        if (face == dir.m_122424_() || face == dir.m_122427_()) {
            Vec3 vec = Utils.fraction(hit.m_82450_());
            if (vec.f_82480_ > 0.5 != top) {
                face = top ? Direction.DOWN : Direction.UP;
            }
        } else if (face == dir || face == dir.m_122428_()) {
            double hor;
            Vec3 vec = Utils.fraction(hit.m_82450_());
            Direction perpDir = face == dir.m_122427_() ? dir : dir.m_122428_();
            double d = hor = Utils.isX(perpDir) ? vec.m_7096_() : vec.m_7094_();
            if (!Utils.isPositive(perpDir)) {
                hor = 1.0 - hor;
            }
            double y = vec.m_7098_();
            y = top ? (y -= 0.5) : 0.5 - y;
            if (y * 2.0 >= hor) {
                face = top ? Direction.DOWN : Direction.UP;
            }
        }
        return this.rotate(state, face, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (Utils.isY(face)) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.m_61122_((Property)FramedProperties.TOP);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return this.rotate(state, Direction.UP, rotation);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    @Override
    protected Tuple<BlockState, BlockState> getBlockPair(BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        boolean ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)((BlockState)((Block)FBContent.blockFramedFlatInnerSlopeSlabCorner.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing.m_122424_())).m_61124_((Property)PropertyHolder.TOP_HALF, (Comparable)Boolean.valueOf(top))).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(!top))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)((BlockState)((Block)FBContent.blockFramedFlatSlopeSlabCorner.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_((Property)PropertyHolder.TOP_HALF, (Comparable)Boolean.valueOf(!top))).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedFlatInverseDoubleSlopeSlabCornerBlockEntity(pos, state);
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape shapeBot = Shapes.m_83110_((VoxelShape)Shapes.m_83113_((VoxelShape)FramedSlopeSlabBlock.SHAPE_BOTTOM.m_83216_(0.0, 0.5, 0.0), (VoxelShape)Utils.rotateShape(Direction.NORTH, Direction.WEST, FramedSlopeSlabBlock.SHAPE_BOTTOM.m_83216_(0.0, 0.5, 0.0)), (BooleanOp)BooleanOp.f_82689_), (VoxelShape)Shapes.m_83110_((VoxelShape)Utils.rotateShape(Direction.NORTH, Direction.SOUTH, FramedSlopeSlabBlock.SHAPE_TOP), (VoxelShape)Utils.rotateShape(Direction.NORTH, Direction.EAST, FramedSlopeSlabBlock.SHAPE_TOP)));
        VoxelShape shapeTop = Shapes.m_83110_((VoxelShape)Shapes.m_83113_((VoxelShape)FramedSlopeSlabBlock.SHAPE_TOP, (VoxelShape)Utils.rotateShape(Direction.NORTH, Direction.WEST, FramedSlopeSlabBlock.SHAPE_TOP), (BooleanOp)BooleanOp.f_82689_), (VoxelShape)Shapes.m_83110_((VoxelShape)Utils.rotateShape(Direction.NORTH, Direction.SOUTH, FramedSlopeSlabBlock.SHAPE_BOTTOM.m_83216_(0.0, 0.5, 0.0)), (VoxelShape)Utils.rotateShape(Direction.NORTH, Direction.EAST, FramedSlopeSlabBlock.SHAPE_BOTTOM.m_83216_(0.0, 0.5, 0.0))));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            VoxelShape shape = Utils.rotateShape(Direction.NORTH, facing, top ? shapeTop : shapeBot);
            builder.put((Object)state, (Object)shape);
        }
        return builder.build();
    }

    public static BlockState itemModelSource() {
        return (BlockState)((Block)FBContent.blockFramedFlatInverseDoubleSlopeSlabCorner.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

