/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.ui;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.customization.action.ActionRegistry;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.ModernScreen;
import de.keksuccino.fancymenu.util.rendering.text.TextFormattingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.InitialWidgetFocusScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.LogicExecutorScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseActionScreen
extends ModernScreen
implements InitialWidgetFocusScreen {
    protected final ActionInstance instance;
    protected Consumer<ActionInstance> callback;
    protected Action originalAction = null;
    protected String originalActionValue = null;
    protected ScrollArea actionsListScrollArea = new ScrollArea(0.0f, 0.0f, 0.0f, 0.0f);
    protected ScrollArea descriptionScrollArea = new ScrollArea(0.0f, 0.0f, 0.0f, 0.0f);
    protected ExtendedEditBox searchBar;
    public boolean isEdit;

    public ChooseActionScreen(@Nullable ActionInstance instanceToEdit, @NotNull Consumer<ActionInstance> callback) {
        super((Component)(instanceToEdit != null ? Component.m_237115_((String)"fancymenu.actions.screens.edit_action") : Component.m_237115_((String)"fancymenu.actions.screens.add_action")));
        boolean bl = this.isEdit = instanceToEdit != null;
        if (this.isEdit) {
            this.originalAction = instanceToEdit.action;
            this.originalActionValue = instanceToEdit.value;
        }
        this.instance = this.isEdit ? instanceToEdit : new ActionInstance(Action.EMPTY, null);
        this.callback = callback;
    }

    protected void m_7856_() {
        String oldSearchValue = this.searchBar != null ? this.searchBar.m_94155_() : "";
        this.searchBar = new ExtendedEditBox(Minecraft.m_91087_().f_91062_, 21, 66, this.f_96543_ / 2 - 40 - 2, 18, (Component)Component.m_237119_());
        this.searchBar.setHintFancyMenu(consumes -> Component.m_237115_((String)"fancymenu.actions.build_action.screen.search_action"));
        this.searchBar.m_94144_(oldSearchValue);
        this.searchBar.m_94151_(s -> this.updateActionsList());
        this.m_142416_((GuiEventListener)this.searchBar);
        UIBase.applyDefaultWidgetSkinTo(this.searchBar);
        this.setupInitialFocusWidget(this, (GuiEventListener)this.searchBar);
        this.actionsListScrollArea.setWidth(this.f_96543_ / 2 - 40, true);
        this.actionsListScrollArea.setHeight(this.f_96544_ - 85 - 25, true);
        this.actionsListScrollArea.setX(20.0f, true);
        this.actionsListScrollArea.setY(90.0f, true);
        this.m_142416_(this.actionsListScrollArea);
        this.descriptionScrollArea.setWidth(this.f_96543_ / 2 - 40, true);
        this.descriptionScrollArea.setHeight(Math.max(40, this.f_96544_ / 2 - 50 - 25), true);
        this.descriptionScrollArea.setX((float)(this.f_96543_ - 20) - this.descriptionScrollArea.getWidthWithBorder(), true);
        this.descriptionScrollArea.setY(65.0f, true);
        this.descriptionScrollArea.horizontalScrollBar.active = false;
        this.m_142416_(this.descriptionScrollArea);
        int cancelButtonX = this.f_96543_ - 20 - 150;
        int cancelButtonY = this.f_96544_ - 20 - 20 - 5 - 20;
        int doneButtonX = this.f_96543_ - 20 - 150;
        int doneButtonY = this.f_96544_ - 20 - 20;
        ExtendedButton doneOrNextButton = new ExtendedButton(doneButtonX, doneButtonY, 150, 20, (Component)Component.m_237119_(), button -> this.onNextStep()).setLabelSupplier(consumes -> this.needsValueFirst() ? Component.m_237115_((String)"fancymenu.ui.generic.next_step") : Component.m_237115_((String)"fancymenu.common_components.done"));
        this.m_142416_((GuiEventListener)doneOrNextButton);
        UIBase.applyDefaultWidgetSkinTo(doneOrNextButton);
        ExtendedButton cancelButton = new ExtendedButton(cancelButtonX, cancelButtonY, 150, 20, (Component)Component.m_237115_((String)"fancymenu.common_components.cancel"), button -> this.callback.accept(null));
        this.m_142416_((GuiEventListener)cancelButton);
        UIBase.applyDefaultWidgetSkinTo(cancelButton);
        this.updateActionsList();
        this.setDescription(this.instance.action);
        if (this.isEdit) {
            this.onNextStep();
        }
    }

    protected void onEditValue() {
        if (this.instance.action == Action.EMPTY) {
            return;
        }
        this.originalAction = null;
        this.originalActionValue = null;
        this.instance.action.editValue(LogicExecutorScreen.build(() -> {
            if (this.canClickDone()) {
                this.onDone();
            } else {
                Minecraft.m_91087_().m_91152_((Screen)this);
            }
        }), this.instance);
    }

    protected boolean hasValue() {
        return this.instance.action != Action.EMPTY && this.instance.action.hasValue();
    }

    protected void onDone() {
        this.callback.accept(this.instance.action != Action.EMPTY ? this.instance : null);
    }

    protected boolean canClickDone() {
        if (this.instance.action == Action.EMPTY) {
            return false;
        }
        return this.instance.value != null || !this.instance.action.hasValue();
    }

    protected boolean needsValueFirst() {
        return this.hasValue() && !this.canClickDone();
    }

    protected void onNextStep() {
        if (this.hasValue()) {
            this.onEditValue();
        } else if (this.canClickDone()) {
            this.onDone();
        }
    }

    public void m_7379_() {
        this.callback.accept(null);
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        graphics.fill(0, 0, this.f_96543_, this.f_96544_, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        MutableComponent titleComp = this.f_96539_.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        graphics.drawString(this.f_96547_, (Component)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        graphics.drawString(this.f_96547_, (Component)Component.m_237115_((String)"fancymenu.actions.screens.build_screen.available_actions"), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        MutableComponent descLabel = Component.m_237115_((String)"fancymenu.actions.screens.build_screen.action_description");
        int descLabelWidth = this.f_96547_.m_92852_((FormattedText)descLabel);
        graphics.drawString(this.f_96547_, (Component)descLabel, this.f_96543_ - 20 - descLabelWidth, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        super.render(graphics, mouseX, mouseY, partial);
        this.performInitialWidgetFocusActionInRender();
    }

    @Override
    public void renderBackground(@NotNull GuiGraphics graphics) {
    }

    protected void setDescription(@Nullable Action action) {
        this.descriptionScrollArea.clearEntries();
        this.descriptionScrollArea.addEntry(new CellScreen.SpacerScrollAreaEntry(this.descriptionScrollArea, 5));
        if (action != null && action.getActionDescription() != null) {
            for (Component c : action.getActionDescription()) {
                this.addDescriptionLine(c);
            }
        }
        this.descriptionScrollArea.addEntry(new CellScreen.SpacerScrollAreaEntry(this.descriptionScrollArea, 5));
    }

    protected void addDescriptionLine(@NotNull Component line) {
        ArrayList<Component> lines = new ArrayList<Component>();
        int maxWidth = (int)(this.descriptionScrollArea.getInnerWidth() - 15.0f);
        if (this.f_96547_.m_92852_((FormattedText)line) > maxWidth) {
            this.f_96547_.m_92865_().m_92414_((FormattedText)line, maxWidth, Style.f_131099_).forEach(formatted -> lines.add((Component)TextFormattingUtils.convertFormattedTextToComponent(formatted)));
        } else {
            lines.add(line);
        }
        lines.forEach(component -> {
            TextScrollAreaEntry e = new TextScrollAreaEntry(this.descriptionScrollArea, (Component)component, entry -> {});
            e.setSelectable(false);
            e.setBackgroundColorHover(e.getBackgroundColorNormal());
            e.setPlayClickSound(false);
            e.setTextBaseColor(UIBase.getUIColorTheme().description_area_text_color.getColorInt());
            this.descriptionScrollArea.addEntry(e);
        });
    }

    protected boolean actionFitsSearchValue(@NotNull Action action, @Nullable String s) {
        if (s == null || s.isBlank()) {
            return true;
        }
        s = s.toLowerCase();
        if (action.getActionDisplayName().getString().toLowerCase().contains(s)) {
            return true;
        }
        return this.actionDescriptionContains(action, s);
    }

    protected boolean actionDescriptionContains(@NotNull Action action, @NotNull String s) {
        Component[] desc;
        for (Component c : desc = Objects.requireNonNullElse(action.getActionDescription(), new Component[0])) {
            if (!c.getString().toLowerCase().contains(s)) continue;
            return true;
        }
        return false;
    }

    protected void setContentOfActionsList() {
        String searchValue;
        String string = searchValue = this.searchBar != null ? this.searchBar.m_94155_() : "";
        if (searchValue.isBlank()) {
            searchValue = null;
        }
        this.actionsListScrollArea.clearEntries();
        List<Action> actions = ActionRegistry.getActions();
        actions.sort(Comparator.comparing(action -> action.getActionDisplayName().getString(), String.CASE_INSENSITIVE_ORDER).thenComparing(action -> action.getActionDisplayName().getString()).thenComparing(Action::getIdentifier));
        for (Action action2 : actions) {
            if (LayoutEditorScreen.getCurrentInstance() != null && !action2.shouldShowUpInEditorActionMenu(LayoutEditorScreen.getCurrentInstance()) || !this.actionFitsSearchValue(action2, searchValue)) continue;
            ActionScrollEntry e = new ActionScrollEntry(this.actionsListScrollArea, action2, entry -> {
                this.instance.action = action2;
                this.instance.value = this.originalAction == action2 ? this.originalActionValue : null;
                this.setDescription(action2);
            });
            this.actionsListScrollArea.addEntry(e);
        }
    }

    protected void updateActionsList() {
        this.setContentOfActionsList();
        if (this.instance.action != Action.EMPTY) {
            for (ScrollAreaEntry e : this.actionsListScrollArea.getEntries()) {
                if (!(e instanceof ActionScrollEntry) || ((ActionScrollEntry)e).action != this.instance.action) continue;
                e.setSelected(true);
                break;
            }
        }
    }

    public class ActionScrollEntry
    extends TextListScrollAreaEntry {
        public Action action;
        protected long lastClickTime;
        protected static final long DOUBLE_CLICK_TIME = 500L;

        public ActionScrollEntry(@NotNull ScrollArea parent, @NotNull Action action, Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, ActionScrollEntry.buildLabel(action), UIBase.getUIColorTheme().listing_dot_color_1, onClick);
            this.lastClickTime = 0L;
            this.action = action;
        }

        @NotNull
        private static Component buildLabel(@NotNull Action action) {
            MutableComponent c = action.getActionDisplayName().m_6881_().m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()));
            if (action.isDeprecated()) {
                c = c.m_130948_(Style.f_131099_.m_178522_(Boolean.valueOf(true)));
                c = c.m_7220_((Component)Component.m_237113_((String)" ").m_6270_(Style.f_131099_.m_178522_(Boolean.valueOf(false))));
                c = c.m_7220_((Component)Component.m_237115_((String)"fancymenu.actions.deprecated").m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().error_text_color.getColorInt()).m_178522_(Boolean.valueOf(false))));
            }
            return c;
        }

        @Override
        public void onClick(ScrollAreaEntry entry, double mouseX, double mouseY, int button) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastClickTime < 500L && ChooseActionScreen.this.instance.action == this.action) {
                ChooseActionScreen.this.onNextStep();
                this.lastClickTime = 0L;
                return;
            }
            this.lastClickTime = currentTime;
            super.onClick(entry, mouseX, mouseY, button);
        }
    }
}

