/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.animationcontroller;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationControllerHandler;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationControllerStateController;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationKeyframe;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class AnimationControllerElement
extends AbstractElement {
    @NotNull
    public List<AnimationKeyframe> keyframes = new ArrayList<AnimationKeyframe>();
    @NotNull
    public List<TargetElement> targetElements = new ArrayList<TargetElement>();
    public boolean loop = false;
    public boolean offsetMode = false;
    public boolean ignoreSize = false;
    public boolean ignorePosition = false;

    public AnimationControllerElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
        this.allowDepthTestManipulation = true;
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (AnimationControllerElement.isEditor()) {
            if (this.shouldRender()) {
                int x = this.getAbsoluteX();
                int y = this.getAbsoluteY();
                int w = this.getAbsoluteWidth();
                int h = this.getAbsoluteHeight();
                RenderSystem.m_69478_();
                graphics.fill(x, y, x + w, y + h, this.inEditorColor.getColorInt());
                graphics.enableScissor(x, y, x + w, y + h);
                Font font = Minecraft.m_91087_().f_91062_;
                Component component = this.getDisplayName();
                int n = x + w / 2;
                int n2 = y + h / 2;
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                graphics.drawCenteredString(font, component, n, n2 - 9 / 2, -1);
                graphics.disableScissor();
            }
        } else {
            boolean shouldPlay = AnimationControllerStateController.isPlaying(this.getInstanceIdentifier());
            if (!shouldPlay) {
                AnimationControllerHandler.resetController(this);
                return;
            }
            this.targetElements.forEach(targetElement -> {
                if (this.shouldRender()) {
                    if (AnimationControllerHandler.wasAnimatedInThePast(targetElement.targetElementId) && AnimationControllerHandler.isFinished(targetElement.targetElementId) && !AnimationControllerHandler.isAnimating(targetElement.targetElementId)) {
                        targetElement.animationApplied = true;
                    } else {
                        AbstractElement target;
                        ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getActiveLayer();
                        if (layer != null && (target = layer.getElementByInstanceIdentifier(targetElement.targetElementId)) != null) {
                            targetElement.animationApplied = AnimationControllerHandler.applyAnimation(this, target);
                        }
                    }
                } else if (AnimationControllerHandler.wasAnimatedInThePast(targetElement.targetElementId) && !AnimationControllerHandler.isFinished(targetElement.targetElementId)) {
                    targetElement.animationApplied = false;
                }
            });
        }
    }

    public List<AnimationKeyframe> getKeyframes() {
        return new ArrayList<AnimationKeyframe>(this.keyframes);
    }

    public static class TargetElement {
        public String targetElementId;
        public boolean animationApplied = false;

        public TargetElement() {
        }

        public TargetElement(String targetElementId) {
            this.targetElementId = targetElementId;
        }
    }
}

