/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementGroup;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.customization.loadingrequirement.ui.BuildRequirementScreen;
import de.keksuccino.fancymenu.customization.loadingrequirement.ui.ManageRequirementsScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.ModernScreen;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.input.CharacterFilter;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildRequirementGroupScreen
extends ModernScreen {
    protected Screen parentScreen;
    protected LoadingRequirementContainer parent;
    protected LoadingRequirementGroup group;
    protected boolean isEdit;
    protected Consumer<LoadingRequirementGroup> callback;
    protected ScrollArea requirementsScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedButton groupModeButton;
    protected ExtendedButton addRequirementButton;
    protected ExtendedButton removeRequirementButton;
    protected ExtendedButton editRequirementButton;
    protected ExtendedButton doneButton;
    protected ExtendedButton cancelButton;
    protected AdvancedTextField groupIdentifierTextField;

    public BuildRequirementGroupScreen(@Nullable Screen parentScreen, @NotNull LoadingRequirementContainer parent, @Nullable LoadingRequirementGroup groupToEdit, @NotNull Consumer<LoadingRequirementGroup> callback) {
        super((Component)(groupToEdit != null ? Component.m_237113_((String)I18n.m_118938_((String)"fancymenu.requirements.screens.edit_group", (Object[])new Object[0])) : Component.m_237113_((String)I18n.m_118938_((String)"fancymenu.requirements.screens.add_group", (Object[])new Object[0]))));
        this.parentScreen = parentScreen;
        this.parent = parent;
        this.group = groupToEdit != null ? groupToEdit : new LoadingRequirementGroup("group_" + System.currentTimeMillis(), LoadingRequirementGroup.GroupMode.AND, parent);
        this.callback = callback;
        this.isEdit = groupToEdit != null;
        this.updateRequirementsScrollArea();
        this.groupIdentifierTextField = new AdvancedTextField(Minecraft.m_91087_().f_91062_, 0, 0, 150, 20, true, CharacterFilter.getBasicFilenameCharacterFilter()){

            public void m_6305_(@NotNull PoseStack pose, int mouseX, int mouseY, float partial) {
                super.m_6305_(pose, mouseX, mouseY, partial);
                BuildRequirementGroupScreen.this.group.identifier = this.m_94155_();
            }
        };
        if (this.group.identifier != null) {
            this.groupIdentifierTextField.m_94144_(this.group.identifier);
        }
    }

    protected void m_7856_() {
        Minecraft.m_91087_().m_91268_().m_85378_((double)Minecraft.m_91087_().m_91268_().m_85385_(((Integer)Minecraft.m_91087_().f_91066_.m_231928_().m_231551_()).intValue(), Minecraft.m_91087_().m_91390_()));
        this.f_96544_ = Minecraft.m_91087_().m_91268_().m_85446_();
        this.f_96543_ = Minecraft.m_91087_().m_91268_().m_85445_();
        this.groupModeButton = new ExtendedButton(0, 0, 150, 20, "", button -> {
            this.group.mode = this.group.mode == LoadingRequirementGroup.GroupMode.AND ? LoadingRequirementGroup.GroupMode.OR : LoadingRequirementGroup.GroupMode.AND;
        }){

            @Override
            public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
                if (BuildRequirementGroupScreen.this.group.mode == LoadingRequirementGroup.GroupMode.AND) {
                    this.setLabel(I18n.m_118938_((String)"fancymenu.requirements.screens.build_group_screen.mode.and", (Object[])new Object[0]));
                } else {
                    this.setLabel(I18n.m_118938_((String)"fancymenu.requirements.screens.build_group_screen.mode.or", (Object[])new Object[0]));
                }
                super.render(graphics, mouseX, mouseY, partial);
            }
        };
        this.m_7787_((GuiEventListener)this.groupModeButton);
        this.groupModeButton.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.build_group_screen.mode.desc", new String[0])));
        UIBase.applyDefaultWidgetSkinTo(this.groupModeButton);
        this.addRequirementButton = new ExtendedButton(0, 0, 150, 20, I18n.m_118938_((String)"fancymenu.requirements.screens.add_requirement", (Object[])new Object[0]), button -> {
            BuildRequirementScreen s = new BuildRequirementScreen(this, this.parent, null, call -> {
                if (call != null) {
                    this.group.addInstance((LoadingRequirementInstance)call);
                    this.updateRequirementsScrollArea();
                }
            });
            Minecraft.m_91087_().m_91152_((Screen)s);
        });
        this.m_7787_((GuiEventListener)this.addRequirementButton);
        this.addRequirementButton.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.build_group_screen.add_requirement.desc", new String[0])));
        UIBase.applyDefaultWidgetSkinTo(this.addRequirementButton);
        this.editRequirementButton = new ExtendedButton(0, 0, 150, 20, I18n.m_118938_((String)"fancymenu.requirements.screens.edit_requirement", (Object[])new Object[0]), button -> {
            LoadingRequirementInstance i = this.getSelectedInstance();
            if (i != null) {
                BuildRequirementScreen s = new BuildRequirementScreen(this, this.parent, i, call -> {
                    if (call != null) {
                        this.updateRequirementsScrollArea();
                    }
                });
                Minecraft.m_91087_().m_91152_((Screen)s);
            }
        }){

            @Override
            public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
                if (BuildRequirementGroupScreen.this.getSelectedInstance() == null) {
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.build_group_screen.no_requirement_selected", new String[0])));
                    this.f_93623_ = false;
                } else {
                    this.setTooltip(null);
                    this.f_93623_ = true;
                }
                super.render(graphics, mouseX, mouseY, partial);
            }
        };
        this.m_7787_((GuiEventListener)this.editRequirementButton);
        this.editRequirementButton.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.build_group_screen.edit_requirement.desc", new String[0])));
        UIBase.applyDefaultWidgetSkinTo(this.editRequirementButton);
        this.removeRequirementButton = new ExtendedButton(0, 0, 150, 20, I18n.m_118938_((String)"fancymenu.requirements.screens.remove_requirement", (Object[])new Object[0]), button -> {
            LoadingRequirementInstance i = this.getSelectedInstance();
            if (i != null) {
                Minecraft.m_91087_().m_91152_((Screen)ConfirmationScreen.ofStrings(call -> {
                    if (call.booleanValue()) {
                        this.group.removeInstance(i);
                        this.updateRequirementsScrollArea();
                    }
                    Minecraft.m_91087_().m_91152_((Screen)this);
                }, LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.remove_requirement.confirm", new String[0])));
            }
        }){

            @Override
            public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
                if (BuildRequirementGroupScreen.this.getSelectedInstance() == null) {
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.build_group_screen.no_requirement_selected", new String[0])));
                    this.f_93623_ = false;
                } else {
                    this.setTooltip(null);
                    this.f_93623_ = true;
                }
                super.render(graphics, mouseX, mouseY, partial);
            }
        };
        this.m_7787_((GuiEventListener)this.removeRequirementButton);
        this.removeRequirementButton.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.build_group_screen.remove_requirement.desc", new String[0])));
        UIBase.applyDefaultWidgetSkinTo(this.removeRequirementButton);
        this.doneButton = new ExtendedButton(0, 0, 150, 20, I18n.m_118938_((String)"fancymenu.common_components.done", (Object[])new Object[0]), button -> {
            Minecraft.m_91087_().m_91152_(this.parentScreen);
            this.callback.accept(this.group);
        }){

            @Override
            public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                BuildRequirementGroupScreen s = BuildRequirementGroupScreen.this;
                if (s.group.getInstances().isEmpty()) {
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.build_group_screen.finish.no_requirements_added", new String[0])));
                    this.f_93623_ = false;
                } else if (s.parent.getGroup(s.group.identifier) != null && s.parent.getGroup(s.group.identifier) != s.group) {
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.build_group_screen.finish.identifier_already_used", new String[0])));
                    this.f_93623_ = false;
                } else if (s.group.identifier == null || s.group.identifier.replace(" ", "").length() == 0) {
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.build_group_screen.finish.identifier_too_short", new String[0])));
                    this.f_93623_ = false;
                } else {
                    this.setTooltip(null);
                    this.f_93623_ = true;
                }
                super.renderWidget(graphics, mouseX, mouseY, partialTicks);
            }
        };
        this.m_7787_((GuiEventListener)this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);
        this.cancelButton = new ExtendedButton(0, 0, 150, 20, I18n.m_118938_((String)"fancymenu.common_components.cancel", (Object[])new Object[0]), button -> {
            Minecraft.m_91087_().m_91152_(this.parentScreen);
            if (this.isEdit) {
                this.callback.accept(this.group);
            } else {
                this.callback.accept(null);
            }
        });
        this.m_7787_((GuiEventListener)this.cancelButton);
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parentScreen);
        if (this.isEdit) {
            this.callback.accept(this.group);
        } else {
            this.callback.accept(null);
        }
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        graphics.fill(0, 0, this.f_96543_, this.f_96544_, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        MutableComponent titleComp = this.f_96539_.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        graphics.drawString(this.f_96547_, (Component)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        graphics.drawString(this.f_96547_, I18n.m_118938_((String)"fancymenu.requirements.screens.build_group_screen.group_requirements", (Object[])new Object[0]), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.requirementsScrollArea.setWidth(this.f_96543_ - 20 - 150 - 20 - 20, true);
        this.requirementsScrollArea.setHeight(this.f_96544_ - 85, true);
        this.requirementsScrollArea.setX(20, true);
        this.requirementsScrollArea.setY(65, true);
        this.requirementsScrollArea.render(graphics, mouseX, mouseY, partial);
        this.doneButton.setX(this.f_96543_ - 20 - this.doneButton.m_5711_());
        this.doneButton.setY(this.f_96544_ - 20 - 20);
        this.doneButton.render(graphics, mouseX, mouseY, partial);
        if (!this.isEdit) {
            this.cancelButton.setX(this.f_96543_ - 20 - this.cancelButton.m_5711_());
            this.cancelButton.setY(this.doneButton.getY() - 5 - 20);
            this.cancelButton.render(graphics, mouseX, mouseY, partial);
        } else {
            this.cancelButton.f_93623_ = false;
        }
        this.removeRequirementButton.setX(this.f_96543_ - 20 - this.removeRequirementButton.m_5711_());
        this.removeRequirementButton.setY((this.isEdit ? this.doneButton.getY() : this.cancelButton.getY()) - 15 - 20);
        this.removeRequirementButton.render(graphics, mouseX, mouseY, partial);
        this.editRequirementButton.setX(this.f_96543_ - 20 - this.editRequirementButton.m_5711_());
        this.editRequirementButton.setY(this.removeRequirementButton.getY() - 5 - 20);
        this.editRequirementButton.render(graphics, mouseX, mouseY, partial);
        this.addRequirementButton.setX(this.f_96543_ - 20 - this.addRequirementButton.m_5711_());
        this.addRequirementButton.setY(this.editRequirementButton.getY() - 5 - 20);
        this.addRequirementButton.render(graphics, mouseX, mouseY, partial);
        this.groupModeButton.setX(this.f_96543_ - 20 - this.groupModeButton.m_5711_());
        this.groupModeButton.setY(this.addRequirementButton.getY() - 5 - 20);
        this.groupModeButton.render(graphics, mouseX, mouseY, partial);
        this.groupIdentifierTextField.m_94214_(this.f_96543_ - 20 - this.groupIdentifierTextField.m_5711_());
        this.groupIdentifierTextField.setY(this.groupModeButton.getY() - 15 - 20);
        this.groupIdentifierTextField.m_6305_(graphics.pose(), mouseX, mouseY, partial);
        String idLabel = I18n.m_118938_((String)"fancymenu.requirements.screens.build_group_screen.group_identifier", (Object[])new Object[0]);
        int idLabelWidth = this.f_96547_.m_92895_(idLabel);
        graphics.drawString(this.f_96547_, idLabel, this.f_96543_ - 20 - idLabelWidth, this.groupIdentifierTextField.getY() - 15, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        super.render(graphics, mouseX, mouseY, partial);
    }

    @Override
    public void renderBackground(@NotNull GuiGraphics $$0) {
    }

    @Nullable
    protected LoadingRequirementInstance getSelectedInstance() {
        ScrollAreaEntry e = this.requirementsScrollArea.getFocusedEntry();
        if (e instanceof ManageRequirementsScreen.RequirementInstanceEntry) {
            return ((ManageRequirementsScreen.RequirementInstanceEntry)e).instance;
        }
        return null;
    }

    protected void updateRequirementsScrollArea() {
        this.requirementsScrollArea.clearEntries();
        for (LoadingRequirementInstance i : this.group.getInstances()) {
            ManageRequirementsScreen.RequirementInstanceEntry e = new ManageRequirementsScreen.RequirementInstanceEntry(this.requirementsScrollArea, i, 14);
            this.requirementsScrollArea.addEntry(e);
        }
    }
}

