/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.audio;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.elements.audio.AudioElement;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AudioTrackPlaceholder
extends Placeholder {
    private static final String DISPLAY_NAME_MAPPING_SEPARATOR = "%:%";
    private static final String DISPLAY_NAME_MAPPING_ARROW = "=>";

    public AudioTrackPlaceholder() {
        super("audio_element_current_track");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        AbstractElement element;
        ScreenCustomizationLayer activeLayer;
        String elementId = dps.values.get("element_identifier");
        String displayNameMappings = dps.values.get("display_name_mappings");
        if (elementId != null && (activeLayer = ScreenCustomizationLayerHandler.getActiveLayer()) != null && (element = activeLayer.getElementByInstanceIdentifier(elementId)) instanceof AudioElement) {
            AudioElement audio = (AudioElement)element;
            AudioElement.AudioInstance currentTrack = audio.currentAudioInstance;
            if (currentTrack != null) {
                String displayName;
                String source = currentTrack.supplier.getSourceWithoutPrefix();
                int lastSlash = source.lastIndexOf(47);
                if (lastSlash != -1 && lastSlash < source.length() - 1) {
                    source = source.substring(lastSlash + 1);
                }
                if (displayNameMappings != null && !displayNameMappings.isEmpty() && (displayName = this.getDisplayNameForTrack(source, displayNameMappings)) != null) {
                    return displayName;
                }
                return source;
            }
        }
        return "---";
    }

    @Nullable
    private String getDisplayNameForTrack(String trackName, String mappings) {
        String[] mappingEntries;
        for (String mapping : mappingEntries = mappings.split(DISPLAY_NAME_MAPPING_SEPARATOR)) {
            String[] parts = mapping.trim().split(DISPLAY_NAME_MAPPING_ARROW, 2);
            if (parts.length != 2) continue;
            String fileName = parts[0].trim();
            String displayName = parts[1].trim();
            if (!trackName.equals(fileName)) continue;
            return displayName;
        }
        return null;
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("element_identifier");
        l.add("display_name_mappings");
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.m_118938_((String)"fancymenu.placeholders.audio_element_current_track", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.audio_element_current_track.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.m_118938_((String)"fancymenu.placeholders.categories.audio", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("element_identifier", "put_identifier_of_audio_element_here");
        m.put("display_name_mappings", "track1.ogg=>Cool Track Name%:%track2.wav=>Another Name");
        return DeserializedPlaceholderString.build(this.getIdentifier(), m);
    }
}

