/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.Renderable;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import java.awt.Color;
import net.minecraft.client.sounds.SoundManager;
import org.jetbrains.annotations.NotNull;

public abstract class ScrollAreaEntry
extends UIBase
implements Renderable {
    public ScrollArea parent;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    public AdvancedButton buttonBase;
    protected Color backgroundColorIdle;
    protected Color backgroundColorHover;
    protected boolean selectable;
    protected boolean selected;
    protected boolean playClickSound;
    public boolean deselectOtherEntriesOnSelect;
    public boolean selectOnClick;
    public int index;

    public ScrollAreaEntry(ScrollArea parent, int width, int height) {
        this.backgroundColorIdle = UIBase.getUIColorTheme().area_background_color.getColor();
        this.backgroundColorHover = UIBase.getUIColorTheme().list_entry_color_selected_hovered.getColor();
        this.selectable = true;
        this.selected = false;
        this.playClickSound = true;
        this.deselectOtherEntriesOnSelect = true;
        this.selectOnClick = true;
        this.index = 0;
        this.parent = parent;
        this.width = width;
        this.height = height;
        this.buttonBase = new AdvancedButton(0, 0, 0, 0, "", true, button -> {
            if (this.selectOnClick) {
                this.setSelected(true);
            }
            this.onClick(this);
        }){

            public void m_7435_(@NotNull SoundManager p_93665_) {
                if (ScrollAreaEntry.this.playClickSound) {
                    super.m_7435_(p_93665_);
                }
            }

            public void m_6305_(@NotNull PoseStack graphics, int p_93658_, int p_93659_, float p_93660_) {
                if (ScrollAreaEntry.this.parent.isMouseInteractingWithGrabbers() || !ScrollAreaEntry.this.parent.isMouseInsideArea()) {
                    this.f_93622_ = false;
                }
                super.m_6305_(graphics, p_93658_, p_93659_, p_93660_);
            }

            public boolean m_198029_() {
                if (ScrollAreaEntry.this.parent.isMouseInteractingWithGrabbers() || !ScrollAreaEntry.this.parent.isMouseInsideArea()) {
                    return false;
                }
                return super.m_198029_();
            }

            public void m_5716_(double p_93371_, double p_93372_) {
                if (ScrollAreaEntry.this.parent.isMouseInteractingWithGrabbers() || !ScrollAreaEntry.this.parent.isMouseInsideArea()) {
                    return;
                }
                super.m_5716_(p_93371_, p_93372_);
            }
        };
        this.updateEntry();
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.updateEntry();
        this.buttonBase.m_6305_(graphics.pose(), mouseX, mouseY, partial);
    }

    public abstract void onClick(ScrollAreaEntry var1);

    public void updateEntry() {
        this.buttonBase.setX(this.x);
        this.buttonBase.setY(this.y);
        this.buttonBase.m_93674_(this.width);
        ((IMixinAbstractWidget)this.buttonBase).setHeightFancyMenu(this.height);
        if (!this.isSelected()) {
            this.buttonBase.setBackgroundColor(this.backgroundColorIdle, this.backgroundColorHover, this.backgroundColorIdle, this.backgroundColorHover, 1);
        } else {
            this.buttonBase.setBackgroundColor(this.backgroundColorHover, this.backgroundColorHover, this.backgroundColorHover, this.backgroundColorHover, 1);
        }
    }

    public void setX(int x) {
        this.x = x;
        this.updateEntry();
    }

    public int getX() {
        return this.x;
    }

    public void setY(int y) {
        this.y = y;
        this.updateEntry();
    }

    public int getY() {
        return this.y;
    }

    public void setWidth(int width) {
        this.width = width;
        this.updateEntry();
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
        this.updateEntry();
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isHovered() {
        return ((IMixinAbstractWidget)this.buttonBase).getIsHoveredFancyMenu();
    }

    public boolean isSelected() {
        return this.selectable && this.selected;
    }

    public void setSelected(boolean selected) {
        if (this.selectable) {
            this.selected = selected;
            this.updateEntry();
            if (selected && this.deselectOtherEntriesOnSelect) {
                for (ScrollAreaEntry e : this.parent.getEntries()) {
                    if (e == this) continue;
                    e.setSelected(false);
                }
            }
        }
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
        if (!selectable) {
            this.selected = false;
        }
    }

    public void setPlayClickSound(boolean playClickSound) {
        this.playClickSound = playClickSound;
    }

    public boolean isPlayClickSound() {
        return this.playClickSound;
    }

    public Color getBackgroundColorIdle() {
        return this.backgroundColorIdle;
    }

    public void setBackgroundColorIdle(Color backgroundColorIdle) {
        this.backgroundColorIdle = backgroundColorIdle;
        this.updateEntry();
    }

    public Color getBackgroundColorHover() {
        return this.backgroundColorHover;
    }

    public void setBackgroundColorHover(Color backgroundColorHover) {
        this.backgroundColorHover = backgroundColorHover;
        this.updateEntry();
    }

    public void setTooltip(String ... tooltipLines) {
        this.buttonBase.setDescription(tooltipLines);
    }
}

