/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.client.forge;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import java.lang.reflect.Field;
import net.irisshaders.iris.api.v0.IrisApi;

public class PaladinFurnitureModClientImpl {
    private static volatile Boolean cachedShaderState = null;
    private static long lastCheckTime = 0L;
    private static final long CACHE_DURATION_MS = 1000L;
    private static Field optifineShaderPackLoadedField = null;
    private static boolean optifineReflectionFailed = false;

    public static boolean areShadersOn() {
        long currentTime = System.currentTimeMillis();
        if (cachedShaderState != null && currentTime - lastCheckTime < 1000L) {
            return cachedShaderState;
        }
        boolean result = PaladinFurnitureModClientImpl.checkShadersInternal();
        cachedShaderState = result;
        lastCheckTime = currentTime;
        return result;
    }

    private static boolean checkShadersInternal() {
        if (PaladinFurnitureMod.getModList().contains("oculus") || PaladinFurnitureMod.getModList().contains("iris")) {
            try {
                return IrisApi.getInstance().isShaderPackInUse();
            }
            catch (Exception e) {
                PaladinFurnitureMod.GENERAL_LOGGER.warn("Failed to check Iris/Oculus shader state: " + e.getMessage());
            }
        }
        if (!PaladinFurnitureMod.isOptifineLoaded()) {
            return false;
        }
        return PaladinFurnitureModClientImpl.checkOptifineShaders();
    }

    private static boolean checkOptifineShaders() {
        if (optifineReflectionFailed) {
            return false;
        }
        if (optifineShaderPackLoadedField == null) {
            try {
                Class<?> shadersClass = Class.forName("net.optifine.shaders.Shaders");
                optifineShaderPackLoadedField = shadersClass.getField("shaderPackLoaded");
                optifineShaderPackLoadedField.setAccessible(true);
            }
            catch (ClassNotFoundException | NoSuchFieldException e) {
                PaladinFurnitureMod.GENERAL_LOGGER.info("Optifine shaders class not found or field missing: " + e.getMessage());
                optifineReflectionFailed = true;
                return false;
            }
        }
        try {
            return optifineShaderPackLoadedField.getBoolean(null);
        }
        catch (IllegalAccessException e) {
            PaladinFurnitureMod.GENERAL_LOGGER.warn("Couldn't access Optifine shaders field: " + e.getMessage());
            optifineReflectionFailed = true;
            return false;
        }
    }

    public static void refreshShaderCache() {
        cachedShaderState = null;
        lastCheckTime = 0L;
    }
}

