/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.mixin;

import com.unlikepaladin.pfm.utilities.PFMFileUtil;
import com.unlikepaladin.pfm.utilities.Version;
import java.net.URI;
import java.net.URISyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TitleScreen.class})
public abstract class PFMTitleScreenMixin
extends Screen {
    @Unique
    private static boolean pfm$firstInit;

    protected PFMTitleScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    public void pfm$showMissingDependencyScreen(CallbackInfo ci) {
        if (pfm$firstInit) {
            return;
        }
        pfm$firstInit = true;
        if (PFMFileUtil.getModLoader() == PFMFileUtil.ModLoader.FABRIC && PFMFileUtil.isModLoaded("sodium") && !PFMFileUtil.isModLoaded("indium")) {
            String reason = "pfm.compat.failure.reason.indiumNotFound";
            String url = "https://modrinth.com/mod/indium/versions?g=1.19";
            if (!Version.compareVersions(PFMFileUtil.getVersion("sodium").get(), "0.6")) {
                Minecraft.m_91087_().m_91152_((Screen)new ConfirmScreen(accepted -> {
                    if (accepted) {
                        try {
                            Util.m_137581_().m_137648_(new URI(url));
                        }
                        catch (URISyntaxException e) {
                            throw new IllegalStateException(e);
                        }
                    } else {
                        Minecraft.m_91087_().m_91393_();
                    }
                }, (Component)Component.m_237115_((String)"pfm.compat.failure.title").m_130940_(ChatFormatting.RED), (Component)Component.m_237115_((String)reason), (Component)Component.m_237115_((String)"pfm.compat.failure.indiumDownload"), (Component)Component.m_237115_((String)"menu.quit")));
            }
        } else if (PFMFileUtil.isModLoaded("connectormod")) {
            String reason = "pfm.compat.issue.reason.connectorMod";
            Minecraft.m_91087_().m_91152_((Screen)new ConfirmScreen(accepted -> {
                if (accepted) {
                    try {
                        Util.m_137581_().m_137648_(new URI("https://github.com/Sinytra/ForgifiedFabricAPI/issues/186"));
                    }
                    catch (URISyntaxException e) {
                        throw new IllegalStateException(e);
                    }
                } else {
                    Minecraft.m_91087_().m_91152_((Screen)this);
                }
            }, (Component)Component.m_237115_((String)"pfm.compat.issue.title").m_130940_(ChatFormatting.YELLOW), (Component)Component.m_237115_((String)reason), (Component)Component.m_237115_((String)"pfm.compat.issue.connectorReport"), (Component)Component.m_237115_((String)"options.graphics.warning.accept")));
        }
    }
}

