/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.runtime.data;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.ArmChairBlock;
import com.unlikepaladin.pfm.blocks.ArmChairColoredBlock;
import com.unlikepaladin.pfm.blocks.BasicChairBlock;
import com.unlikepaladin.pfm.blocks.BasicCoffeeTableBlock;
import com.unlikepaladin.pfm.blocks.BasicDeskBlock;
import com.unlikepaladin.pfm.blocks.BasicDeskCabinetBlock;
import com.unlikepaladin.pfm.blocks.BasicLampBlock;
import com.unlikepaladin.pfm.blocks.BasicTableBlock;
import com.unlikepaladin.pfm.blocks.BasicToiletBlock;
import com.unlikepaladin.pfm.blocks.ClassicBedBlock;
import com.unlikepaladin.pfm.blocks.ClassicChairBlock;
import com.unlikepaladin.pfm.blocks.ClassicChairDyeableBlock;
import com.unlikepaladin.pfm.blocks.ClassicCoffeeTableBlock;
import com.unlikepaladin.pfm.blocks.ClassicNightstandBlock;
import com.unlikepaladin.pfm.blocks.ClassicStoolBlock;
import com.unlikepaladin.pfm.blocks.ClassicTableBlock;
import com.unlikepaladin.pfm.blocks.CutleryBlock;
import com.unlikepaladin.pfm.blocks.DinnerChairBlock;
import com.unlikepaladin.pfm.blocks.DinnerTableBlock;
import com.unlikepaladin.pfm.blocks.FreezerBlock;
import com.unlikepaladin.pfm.blocks.FridgeBlock;
import com.unlikepaladin.pfm.blocks.FroggyChairBlock;
import com.unlikepaladin.pfm.blocks.HerringbonePlankBlock;
import com.unlikepaladin.pfm.blocks.IronStoveBlock;
import com.unlikepaladin.pfm.blocks.KitchenCabinetBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterOvenBlock;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.blocks.KitchenRangeHoodBlock;
import com.unlikepaladin.pfm.blocks.KitchenSinkBlock;
import com.unlikepaladin.pfm.blocks.KitchenStovetopBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallCounterBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallDrawerBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallDrawerSmallBlock;
import com.unlikepaladin.pfm.blocks.LogStoolBlock;
import com.unlikepaladin.pfm.blocks.LogTableBlock;
import com.unlikepaladin.pfm.blocks.MicrowaveBlock;
import com.unlikepaladin.pfm.blocks.MirrorBlock;
import com.unlikepaladin.pfm.blocks.ModernChairBlock;
import com.unlikepaladin.pfm.blocks.ModernCoffeeTableBlock;
import com.unlikepaladin.pfm.blocks.ModernDinnerTableBlock;
import com.unlikepaladin.pfm.blocks.ModernStoolBlock;
import com.unlikepaladin.pfm.blocks.PendantBlock;
import com.unlikepaladin.pfm.blocks.PlateBlock;
import com.unlikepaladin.pfm.blocks.RawLogTableBlock;
import com.unlikepaladin.pfm.blocks.ShowerTowelBlock;
import com.unlikepaladin.pfm.blocks.SimpleBedBlock;
import com.unlikepaladin.pfm.blocks.SimpleBunkLadderBlock;
import com.unlikepaladin.pfm.blocks.SimpleSofaBlock;
import com.unlikepaladin.pfm.blocks.SimpleStoolBlock;
import com.unlikepaladin.pfm.blocks.StoveBlock;
import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import com.unlikepaladin.pfm.menus.WorkbenchScreenHandler;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import com.unlikepaladin.pfm.runtime.PFMGenerator;
import com.unlikepaladin.pfm.runtime.PFMProvider;
import com.unlikepaladin.pfm.runtime.data.DynamicFurnitureRecipeJsonFactory;
import com.unlikepaladin.pfm.runtime.data.SimpleFurnitureRecipeJsonFactory;
import com.unlikepaladin.pfm.runtime.data.forge.PFMRecipeProviderImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class PFMRecipeProvider
extends PFMProvider {
    public PFMRecipeProvider(PFMGenerator parent) {
        super(parent, "PFM Recipes");
        parent.setProgress("Generating Recipes");
    }

    @Override
    public void run() {
        this.startProviderRun();
        this.createWriter();
        Path path = this.getParent().getOutput();
        HashSet set = Sets.newHashSet();
        WorkbenchScreenHandler.ALL_RECIPES.clear();
        this.generateRecipes(recipeJsonProvider -> {
            if (!set.add(recipeJsonProvider.m_6445_())) {
                this.getParent().getLogger().error("Duplicate recipe " + String.valueOf(recipeJsonProvider.m_6445_()));
                throw new IllegalStateException("Duplicate recipe " + String.valueOf(recipeJsonProvider.m_6445_()));
            }
            if (recipeJsonProvider == null) {
                this.getParent().getLogger().error("Recipe Json Provider is null");
                throw new IllegalStateException("Recipe Json Provider is null");
            }
            Path recipePath = path.resolve("data/" + recipeJsonProvider.m_6445_().m_135827_() + "/recipes/" + recipeJsonProvider.m_6445_().m_135815_() + ".json");
            this.enqueueJsonWrite(this.getWriteQueue(), recipePath, (JsonElement)recipeJsonProvider.m_125966_());
            JsonObject jsonObject = recipeJsonProvider.m_5860_();
            if (jsonObject != null) {
                Path advancementPath = path.resolve("data/" + recipeJsonProvider.m_6445_().m_135827_() + "/advancements/" + recipeJsonProvider.m_6448_().m_135815_() + ".json");
                this.enqueueJsonWrite(this.getWriteQueue(), advancementPath, jsonObject.toString());
            }
        });
        this.enqueueJsonWrite(this.getWriteQueue(), path.resolve("data/pfm/advancements/recipes/root.json"), (JsonElement)Advancement.Builder.m_138353_().m_138386_("has_planks", (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromTag((TagKey<Item>)ItemTags.f_13168_)).m_138400_());
        this.waitForWrite();
        this.endProviderRun();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    protected static ResourceLocation getId(Block block) {
        return PFMRecipeProviderImpl.getId(block);
    }

    protected void generateRecipes(Consumer<FinishedRecipe> exporter) {
        FurnitureBlock[] mirrors;
        FurnitureBlock[] showerTowels;
        FurnitureBlock[] basicToilets;
        FurnitureBlock[] cutleries;
        FurnitureBlock[] plates;
        KitchenStovetopBlock[] stovetopBlocks;
        FurnitureBlock[] ironStove;
        FurnitureBlock[] stoves;
        FurnitureBlock[] rangeHoods;
        FurnitureBlock[] microwaves;
        FurnitureBlock[] freezers;
        FurnitureBlock[] fridges;
        FurnitureBlock[] herringbonePlanks;
        FurnitureBlock[] simpleSofas;
        FurnitureBlock[] armChairs;
        FurnitureBlock[] woolClassicChairs;
        FurnitureBlock[] froggyChairs;
        ArrayList<ResourceLocation> generatedRecipes = new ArrayList<ResourceLocation>();
        PFMRecipeProvider.offerBasicChairRecipe(BasicChairBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(BasicChairBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerDinnerChairRecipe(DinnerChairBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(DinnerChairBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerClassicChairRecipe(ClassicChairBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(ClassicChairBlock.class).getVariants(), exporter);
        for (FurnitureBlock froggyChair : froggyChairs = FroggyChairBlock.streamFroggyChair().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(froggyChair.getBlock()))) continue;
            PFMRecipeProvider.offerFroggyChairRecipe((ItemLike)froggyChair.getBlock(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{froggyChair.getFroggyChairMaterial().m_5456_()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(froggyChair.getBlock()));
        }
        for (FurnitureBlock classicChair : woolClassicChairs = ClassicChairDyeableBlock.streamWoodDyeableChair().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(classicChair.getBlock()))) continue;
            PFMRecipeProvider.offerClassicChairDyedRecipe((ItemLike)classicChair.getBlock(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41837_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{classicChair.getArmChairMaterial()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(classicChair.getBlock()));
        }
        PFMRecipeProvider.offerModernChairRecipe(ModernChairBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(ModernChairBlock.class).getVariants(), exporter);
        for (FurnitureBlock armChair : armChairs = ArmChairColoredBlock.streamArmChairColored().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(armChair.getBlock()))) continue;
            PFMRecipeProvider.offerArmChairRecipe((ItemLike)armChair.getBlock(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41837_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{armChair.getArmChairMaterial().m_5456_()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(armChair.getBlock()));
        }
        for (FurnitureBlock sofa : simpleSofas = SimpleSofaBlock.streamSimpleSofas().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(sofa.getBlock()))) continue;
            PFMRecipeProvider.offerSimpleSofaRecipe((ItemLike)sofa.getBlock(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41837_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{sofa.getArmChairMaterial().m_5456_()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(sofa.getBlock()));
        }
        FurnitureBlock[] leatherArmChairs = ArmChairBlock.streamArmChairs().toList().toArray(new FurnitureBlock[0]);
        for (FurnitureBlock armChair : leatherArmChairs) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(armChair.getBlock()))) continue;
            PFMRecipeProvider.offerArmChairRecipe((ItemLike)armChair.getBlock(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41837_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{armChair.getArmChairMaterial().m_5456_()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(armChair.getBlock()));
        }
        PFMRecipeProvider.offerBasicTableRecipe(BasicTableBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(BasicTableBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerClassicTableRecipe(ClassicTableBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(ClassicTableBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerLogTableRecipe(LogTableBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(LogTableBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerLogTableRecipe(RawLogTableBlock.class, "secondary", "secondary", PaladinFurnitureMod.furnitureEntryMap.get(RawLogTableBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerDinnerTableRecipe(DinnerTableBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(DinnerTableBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerModernDinnerTableRecipe(ModernDinnerTableBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(ModernDinnerTableBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerClassicNightStandRecipe(ClassicNightstandBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(ClassicNightstandBlock.class).getVariants(), exporter);
        for (Block block2 : this.getVanillaBeds()) {
            PFMRecipeProvider.offerSimpleBedRecipe(SimpleBedBlock.class, "base", PaladinFurnitureMod.furnitureEntryMap.get(SimpleBedBlock.class).getVariants(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{block2}), exporter);
            PFMRecipeProvider.offerClassicBedRecipe(ClassicBedBlock.class, "base", PaladinFurnitureMod.furnitureEntryMap.get(ClassicBedBlock.class).getVariants(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{block2}), "fence", exporter);
        }
        PFMRecipeProvider.offerSimpleBunkLadderRecipe(SimpleBunkLadderBlock.class, "base", PaladinFurnitureMod.furnitureEntryMap.get(SimpleBunkLadderBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerLogStoolRecipe(LogStoolBlock.class, "secondary", PaladinFurnitureMod.furnitureEntryMap.get(LogStoolBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerSimpleStoolRecipe(SimpleStoolBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(SimpleStoolBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerClassicStoolRecipe(ClassicStoolBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(ClassicStoolBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerModernStoolRecipe(ModernStoolBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(ModernStoolBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerCounterRecipe(KitchenCounterBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(KitchenCounterBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerKitchenSinkRecipe(KitchenSinkBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(KitchenSinkBlock.class).getVariants(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42446_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_}), exporter);
        PFMRecipeProvider.offerCounterApplianceRecipe(KitchenDrawerBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(KitchenDrawerBlock.class).getVariants(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42009_}), exporter);
        PFMRecipeProvider.offerCounterApplianceRecipe(KitchenCounterOvenBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(KitchenCounterOvenBlock.class).getVariants(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41962_}), exporter);
        PFMRecipeProvider.offerCounterRecipe(KitchenWallCounterBlock.class, "base", "base", PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallCounterBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerWallDrawerRecipe(KitchenWallDrawerBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallDrawerBlock.class).getVariants(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42009_}), exporter);
        PFMRecipeProvider.offerWallDrawerSmallRecipe(KitchenWallDrawerSmallBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallDrawerSmallBlock.class).getVariants(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42009_}), exporter);
        PFMRecipeProvider.offerCabinetRecipe(KitchenCabinetBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(KitchenCabinetBlock.class).getVariants(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42009_}), exporter);
        for (FurnitureBlock herringbonePlank : herringbonePlanks = HerringbonePlankBlock.streamPlanks().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(herringbonePlank.getBlock()))) continue;
            PFMRecipeProvider.offerHerringbonePlanks((ItemLike)herringbonePlank.getBlock(), herringbonePlank.getSlab().m_5456_(), exporter);
        }
        for (FurnitureBlock fridge : fridges = FridgeBlock.streamFridges().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(fridge.getBlock()))) continue;
            PFMRecipeProvider.offerFridgeRecipe((ItemLike)fridge.getBlock(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{fridge.getFridgeMaterial().m_5456_()}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42009_}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(fridge.getBlock()));
        }
        for (FurnitureBlock freezer : freezers = FreezerBlock.streamFreezers().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(freezer.getBlock()))) continue;
            PFMRecipeProvider.offerFreezerRecipe((ItemLike)freezer.getBlock(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{freezer.getFridgeMaterial().m_5456_()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(freezer.getBlock()));
        }
        for (FurnitureBlock microwave : microwaves = MicrowaveBlock.streamMicrowaves().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(microwave.getBlock()))) continue;
            PFMRecipeProvider.offerMicrowaveRecipe((ItemLike)microwave.getBlock(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{microwave.getFridgeMaterial().m_5456_()}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41962_}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(microwave.getBlock()));
        }
        for (FurnitureBlock rangeHood : rangeHoods = KitchenRangeHoodBlock.streamOvenRangeHoods().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(rangeHood.getBlock()))) continue;
            PFMRecipeProvider.offerRangeHoodRecipe((ItemLike)rangeHood.getBlock(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{rangeHood.getFridgeMaterial().m_5456_()}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42105_}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(rangeHood.getBlock()));
        }
        for (FurnitureBlock stove : stoves = StoveBlock.streamStoves().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(stove.getBlock()))) continue;
            PFMRecipeProvider.offerStoveRecipe((ItemLike)stove.getBlock(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{stove.getFridgeMaterial().m_5456_()}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41962_}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(stove.getBlock()));
        }
        for (FurnitureBlock stove : ironStove = IronStoveBlock.streamIronStoves().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(stove.getBlock()))) continue;
            PFMRecipeProvider.offerStoveRecipe((ItemLike)stove.getBlock(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{stove.getFridgeMaterial().m_5456_()}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41962_}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(stove.getBlock()));
        }
        for (KitchenStovetopBlock stove : stovetopBlocks = KitchenStovetopBlock.streamKitchenStovetop().toList().toArray(new KitchenStovetopBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId((Block)stove))) continue;
            PFMRecipeProvider.offerStovetopRecipe((ItemLike)stove, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50497_}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId((Block)stove));
        }
        for (FurnitureBlock plate : plates = PlateBlock.streamPlates().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(plate.getBlock()))) continue;
            PFMRecipeProvider.offerPlateRecipe((ItemLike)plate.getBlock(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{plate.getPlateMaterial()}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42617_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{plate.getPlateDecoration()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(plate.getBlock()));
        }
        for (FurnitureBlock cutlery : cutleries = CutleryBlock.streamCutlery().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(cutlery.getBlock()))) continue;
            PFMRecipeProvider.offerCutleryRecipe((ItemLike)cutlery.getBlock(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{cutlery.getCutleryMaterial()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(cutlery.getBlock()));
        }
        PaladinFurnitureMod.furnitureEntryMap.get(PendantBlock.class).getAllBlocks().forEach(block -> {
            if (!generatedRecipes.contains(PFMRecipeProvider.getId(block))) {
                Block hang = Blocks.f_50498_;
                Block base = block == PaladinFurnitureModBlocksItems.GLASS_MODERN_PENDANT ? Blocks.f_50147_ : (block == PaladinFurnitureModBlocksItems.WHITE_MODERN_PENDANT ? Blocks.f_50542_ : Blocks.f_50497_);
                PFMRecipeProvider.offerPendantRecipe((ItemLike)block.m_5456_(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{base}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{hang}), exporter);
                generatedRecipes.add(PFMRecipeProvider.getId(block));
            }
        });
        if (!generatedRecipes.contains(Registry.f_122827_.m_7981_((Object)PaladinFurnitureModBlocksItems.LIGHT_SWITCH_ITEM))) {
            SimpleFurnitureRecipeJsonFactory.create((ItemLike)PaladinFurnitureModBlocksItems.LIGHT_SWITCH_ITEM, 6).input((ItemLike)Blocks.f_50542_, 6).input((ItemLike)Blocks.f_50498_, 2).input((ItemLike)Items.f_42451_).m_126140_(exporter, new ResourceLocation("pfm", PaladinFurnitureModBlocksItems.LIGHT_SWITCH_ITEM.m_5524_().replace("block.pfm.", "")));
            generatedRecipes.add(Registry.f_122827_.m_7981_((Object)PaladinFurnitureModBlocksItems.LIGHT_SWITCH_ITEM));
        }
        for (FurnitureBlock toilet : basicToilets = BasicToiletBlock.streamBasicToilet().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(toilet.getBlock()))) continue;
            PFMRecipeProvider.offerToiletRecipe((ItemLike)toilet.getBlock(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42083_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50333_}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(toilet.getBlock()));
        }
        if (!generatedRecipes.contains(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.WALL_TOILET_PAPER))) {
            PFMRecipeProvider.offerWallToiletPaperRecipe((ItemLike)PaladinFurnitureModBlocksItems.WALL_TOILET_PAPER, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50069_}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.WALL_TOILET_PAPER));
        }
        if (!generatedRecipes.contains(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.BASIC_SINK))) {
            PFMRecipeProvider.offerSinkRecipe((ItemLike)PaladinFurnitureModBlocksItems.BASIC_SINK, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50333_}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.BASIC_SINK));
        }
        if (!generatedRecipes.contains(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.BASIC_BATHTUB))) {
            PFMRecipeProvider.offerBathtubRecipe((ItemLike)PaladinFurnitureModBlocksItems.BASIC_BATHTUB, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50333_}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.BASIC_BATHTUB));
        }
        if (!generatedRecipes.contains(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.BASIC_SHOWER_HEAD))) {
            PFMRecipeProvider.offerShowerHeadRecipe((ItemLike)PaladinFurnitureModBlocksItems.BASIC_SHOWER_HEAD, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42447_}), exporter);
            PFMRecipeProvider.offerShowerHandleRecipe((ItemLike)PaladinFurnitureModBlocksItems.BASIC_SHOWER_HANDLE_ITEM, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50164_}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.BASIC_SHOWER_HEAD));
            generatedRecipes.add(Registry.f_122827_.m_7981_((Object)PaladinFurnitureModBlocksItems.BASIC_SHOWER_HANDLE_ITEM));
        }
        if (!generatedRecipes.contains(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.MESH_TRASHCAN))) {
            SimpleFurnitureRecipeJsonFactory.create((ItemLike)PaladinFurnitureModBlocksItems.MESH_TRASHCAN, 1).input((ItemLike)Items.f_42416_, 1).input((ItemLike)Items.f_42584_, 1).input((ItemLike)Blocks.f_50183_, 4).m_126140_(exporter, new ResourceLocation("pfm", PaladinFurnitureModBlocksItems.MESH_TRASHCAN.m_5456_().m_5524_().replace("block.pfm.", "")));
            generatedRecipes.add(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.MESH_TRASHCAN));
        }
        if (!generatedRecipes.contains(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.TRASHCAN))) {
            SimpleFurnitureRecipeJsonFactory.create((ItemLike)PaladinFurnitureModBlocksItems.TRASHCAN, 1).input((ItemLike)Items.f_42416_, 1).input((ItemLike)Items.f_42584_, 1).input((ItemLike)Blocks.f_50183_, 4).m_126140_(exporter, new ResourceLocation("pfm", PaladinFurnitureModBlocksItems.TRASHCAN.m_5456_().m_5524_().replace("block.pfm.", "")));
            generatedRecipes.add(PFMRecipeProvider.getId((Block)PaladinFurnitureModBlocksItems.TRASHCAN));
        }
        for (FurnitureBlock towel : showerTowels = ShowerTowelBlock.streamShowerTowels().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(towel.getBlock()))) continue;
            PFMRecipeProvider.offerShowerTowelRecipe((ItemLike)towel.getBlock(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{towel.getWoolColor()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(towel.getBlock()));
        }
        for (FurnitureBlock mirror : mirrors = MirrorBlock.streamMirrorBlocks().toList().toArray(new FurnitureBlock[0])) {
            if (generatedRecipes.contains(PFMRecipeProvider.getId(mirror.getBlock()))) continue;
            PFMRecipeProvider.offerMirrorRecipe((ItemLike)mirror.getBlock(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{mirror.getBaseMaterial()}), exporter);
            generatedRecipes.add(PFMRecipeProvider.getId(mirror.getBlock()));
        }
        PFMRecipeProvider.offerLampRecipes(exporter);
        PFMRecipeProvider.offerBasicCoffeeTableRecipe(BasicCoffeeTableBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(BasicCoffeeTableBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerModernCoffeeTableRecipe(ModernCoffeeTableBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(ModernCoffeeTableBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerClassicCoffeeTableRecipe(ClassicCoffeeTableBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(ClassicCoffeeTableBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerBasicDeskRecipe(BasicDeskBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(BasicDeskBlock.class).getVariants(), exporter);
        PFMRecipeProvider.offerBasicDeskCabinetRecipe(BasicDeskCabinetBlock.class, "secondary", "base", PaladinFurnitureMod.furnitureEntryMap.get(BasicDeskCabinetBlock.class).getVariants(), exporter);
        PaladinFurnitureMod.pfmModCompatibilities.forEach(pfmModCompatibility -> pfmModCompatibility.generateRecipes(exporter));
    }

    public static void offerLampRecipes(Consumer<FinishedRecipe> exporter) {
        for (DyeColor color : DyeColor.values()) {
            CompoundTag beTag = new CompoundTag();
            beTag.m_128359_("color", color.m_7912_());
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("BlockEntityTag", (Tag)beTag);
            tag.m_128379_("variantInNbt", true);
            DynamicFurnitureRecipeJsonFactory.create(BasicLampBlock.class, 1, WoodVariantRegistry.getVariants().stream().map(woodVariant -> woodVariant.identifier).toList(), (Tag)tag).vanillaInput((ItemLike)ModelHelper.getWoolColor(color.m_7912_()), 3).vanillaInput((ItemLike)Items.f_42000_).vanillaInput((ItemLike)Items.f_42451_).childInput("stripped_log", 2).offerTo(exporter, new ResourceLocation("pfm", String.format("basic_%s_lamp", color.m_7912_())));
        }
    }

    public static Tuple<Block, Block> getCounterMaterials(VariantBase<?> variantBase) {
        Block counterTop = variantBase.getSecondaryBlock();
        Block counterBase = variantBase.getBaseBlock();
        if (variantBase.identifier.m_135815_().equals("calcite") || variantBase.identifier.m_135815_().equals("netherite")) {
            Block temp = counterBase;
            counterBase = counterTop;
            counterTop = temp;
        }
        return new Tuple((Object)counterBase, (Object)counterTop);
    }

    public Block getVanillaBed(Block block) {
        if (block instanceof SimpleBedBlock) {
            String color = ((SimpleBedBlock)block).getPFMColor().m_41065_();
            return (Block)Registry.f_122824_.m_7745_(new ResourceLocation("minecraft:" + color + "_bed"));
        }
        return null;
    }

    public List<Block> getVanillaBeds() {
        ArrayList<Block> beds = new ArrayList<Block>();
        Registry.f_122824_.m_123024_().forEach(block -> {
            if (block instanceof BedBlock && Registry.f_122824_.m_7981_(block).m_135827_().equals("minecraft")) {
                beds.add((Block)block);
            }
        });
        return beds;
    }

    public static void offerBasicChairRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("chairs").childInput(legMaterial, 2).childInput(baseMaterial, 4).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerFroggyChairRecipe(ItemLike output, Ingredient baseMaterial, Consumer<FinishedRecipe> exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 4).group("chairs").criterion("has_concrete", (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(baseMaterial, 6).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
    }

    public static void offerDinnerChairRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("chairs").childInput(legMaterial, 3).childInput(baseMaterial, 3).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerClassicChairDyedRecipe(ItemLike output, Ingredient legMaterial, Ingredient baseMaterial, Consumer<FinishedRecipe> exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 4).group("chairs").criterion(PFMRecipeProvider.getCriterionNameFromOutput(output), (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 4).input(baseMaterial, 2).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
    }

    public static void offerClassicChairRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("chairs").childInput(legMaterial, 4).childInput(baseMaterial, 2).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerModernChairRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("chairs").childInput(legMaterial, 3).childInput(baseMaterial, 3).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerArmChairRecipe(ItemLike output, Ingredient baseMaterial, Ingredient legMaterial, Consumer<FinishedRecipe> exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 2).group("chairs").criterion("has_wool", (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 4).input(baseMaterial, 2).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
    }

    public static void offerSimpleSofaRecipe(ItemLike output, Ingredient baseMaterial, Ingredient legMaterial, Consumer<FinishedRecipe> exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 2).group("chairs").criterion("has_wool", (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromIngredient(baseMaterial)).input(legMaterial, 2).input(baseMaterial, 4).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
    }

    public static void offerBasicTableRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("tables").childInput(legMaterial, 5).childInput(baseMaterial, 3).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerBasicDeskRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("tables").childInput(legMaterial, 4).childInput(baseMaterial, 3).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerBasicDeskCabinetRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("tables").childInput(legMaterial, 4).childInput(baseMaterial, 3).vanillaInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42009_})).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerBasicCoffeeTableRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("tables").childInput(legMaterial, 3).childInput(baseMaterial, 3).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerModernCoffeeTableRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("tables").childInput(legMaterial, 4).childInput(baseMaterial, 3).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerClassicCoffeeTableRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("tables").childInput(legMaterial, 2).childInput(baseMaterial, 3).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerClassicTableRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("tables").childInput(legMaterial, 4).childInput(baseMaterial, 3).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerLogTableRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("tables").childInput(legMaterial, 2).childInput(baseMaterial, 3).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerHerringbonePlanks(ItemLike output, Item baseMaterial, Consumer<FinishedRecipe> exporter) {
        ShapedRecipeBuilder.m_126118_((ItemLike)output, (int)4).m_126127_(Character.valueOf('X'), (ItemLike)baseMaterial).m_126130_("XX").m_126130_("XX").m_126132_("has_wood_slabs", (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromItem((ItemLike)baseMaterial)).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
    }

    public static void offerDinnerTableRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("tables").childInput(legMaterial, 3).childInput(baseMaterial, 3).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerModernDinnerTableRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("tables").childInput(legMaterial, 5).childInput(baseMaterial, 3).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerClassicNightStandRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("bedroom").childInput(legMaterial, 6).childInput(baseMaterial, 1).vanillaInput((ItemLike)Blocks.f_50087_, 1).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static String getCriterionNameFromOutput(ItemLike output) {
        return PFMRecipeProvider.getCriterionNameFromOutput(output, "");
    }

    public static String getEmptyCriteria() {
        return "";
    }

    public static String getCriterionNameFromOutput(ItemLike output, String type) {
        if (Block.m_49814_((Item)output.m_5456_()) == null || Block.m_49814_((Item)output.m_5456_()) == Blocks.f_50016_ || !PaladinFurnitureMod.furnitureEntryMap.containsKey(Block.m_49814_((Item)output.m_5456_()).getClass())) {
            return PFMRecipeProvider.getItemPath(output);
        }
        if (PaladinFurnitureMod.furnitureEntryMap.get(Block.m_49814_((Item)output.m_5456_()).getClass()).getVariantFromEntry(Block.m_49814_((Item)output.m_5456_())) instanceof WoodVariant) {
            return type.isEmpty() ? "has_planks" : type;
        }
        return PFMRecipeProvider.getItemPath(output);
    }

    public static void offerSimpleBedRecipe(Class<? extends Block> output, String legMaterial, List<ResourceLocation> variants, Ingredient baseBed, Consumer<FinishedRecipe> exporter) {
        DyeColor color = ((BedBlock)((BlockItem)Arrays.stream(baseBed.m_43908_()).findFirst().get().m_41720_()).m_40614_()).m_49554_();
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("color", color.m_7912_());
        DynamicFurnitureRecipeJsonFactory.create(output, 1, variants, (Tag)tag).group("bedroom").childInput(legMaterial, 5).vanillaInput(baseBed, 1).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US) + "_" + color.m_7912_()));
    }

    public static void offerClassicBedRecipe(Class<? extends Block> output, String legMaterial, List<ResourceLocation> variants, Ingredient baseBed, String fence, Consumer<FinishedRecipe> exporter) {
        DyeColor color = ((BedBlock)((BlockItem)Arrays.stream(baseBed.m_43908_()).findFirst().get().m_41720_()).m_40614_()).m_49554_();
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("color", color.m_7912_());
        DynamicFurnitureRecipeJsonFactory.create(output, 1, variants, (Tag)tag).group("bedroom").childInput(legMaterial, 3).childInput(fence, 2).vanillaInput(baseBed, 1).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US) + "_" + String.valueOf(((BedBlock)((BlockItem)Arrays.stream(baseBed.m_43908_()).findFirst().get().m_41720_()).m_40614_()).m_49554_())));
    }

    public static void offerSimpleBunkLadderRecipe(Class<? extends Block> output, String base, List<ResourceLocation> variants, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("bedroom").childInput(base, 1).vanillaInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42398_}), 6).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerLogStoolRecipe(Class<? extends Block> output, String legMaterial, List<ResourceLocation> variants, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("stools").childInput(legMaterial, 1).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerSimpleStoolRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("stools").childInput(legMaterial, 2).childInput(baseMaterial, 3).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerClassicStoolRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("stools").childInput(legMaterial, 3).childInput(baseMaterial, 2).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerModernStoolRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 4, variants).group("stools").childInput(legMaterial, 1).childInput(baseMaterial, 3).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerCounterRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 6, variants).group("kitchen").childInput(legMaterial, 3).childInput(baseMaterial, 6).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerCounterApplianceRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Ingredient appliance, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 1, variants).group("kitchen").childInput(legMaterial, 3).childInput(baseMaterial, 5).vanillaInput(appliance).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerKitchenSinkRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Ingredient center, Ingredient ingot, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 1, variants).group("kitchen").childInput(legMaterial, 2).childInput(baseMaterial, 5).vanillaInput(ingot).vanillaInput(center).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerWallDrawerRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Ingredient appliace, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 1, variants).group("kitchen").childInput(legMaterial, 6).childInput(baseMaterial, 2).vanillaInput(appliace).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerWallDrawerSmallRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Ingredient appliance, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 3, variants).group("kitchen").childInput(legMaterial, 3).childInput(baseMaterial, 2).vanillaInput(appliance).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerCabinetRecipe(Class<? extends Block> output, String legMaterial, String baseMaterial, List<ResourceLocation> variants, Ingredient chest, Consumer<FinishedRecipe> exporter) {
        DynamicFurnitureRecipeJsonFactory.create(output, 3, variants).group("kitchen").childInput(legMaterial, 6).childInput(baseMaterial, 2).vanillaInput(chest).offerTo(exporter, new ResourceLocation("pfm", output.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase(Locale.US)));
    }

    public static void offerFridgeRecipe(ItemLike output, Ingredient legMaterial, Ingredient storage, Consumer<FinishedRecipe> exporter) {
        if (output.m_5456_().toString().contains("xbox")) {
            SimpleFurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(legMaterial), (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromIngredient(legMaterial)).input(legMaterial, 6).input(storage, 1).input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42451_})).input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42246_})).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
        } else {
            SimpleFurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(legMaterial), (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromIngredient(legMaterial)).input(legMaterial, 7).input(storage).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
        }
    }

    public static void offerFreezerRecipe(ItemLike output, Ingredient legMaterial, Consumer<FinishedRecipe> exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(legMaterial), (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromIngredient(legMaterial)).input(legMaterial, 7).input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42451_}), 2).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
    }

    public static void offerMicrowaveRecipe(ItemLike output, Ingredient legMaterial, Ingredient storage, Consumer<FinishedRecipe> exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(legMaterial), (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromIngredient(legMaterial)).input(legMaterial, 5).input(storage).input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42451_})).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
    }

    public static void offerRangeHoodRecipe(ItemLike output, Ingredient legMaterial, Ingredient secondMaterial, Consumer<FinishedRecipe> exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(legMaterial), (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromIngredient(legMaterial)).input(legMaterial, 4).input(secondMaterial).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
    }

    public static void offerStoveRecipe(ItemLike output, Ingredient legMaterial, Ingredient storage, Consumer<FinishedRecipe> exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(legMaterial), (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromIngredient(legMaterial)).input(legMaterial, 8).input(storage).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
    }

    public static void offerStovetopRecipe(ItemLike output, Ingredient base, Ingredient material, Consumer<FinishedRecipe> exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 1).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(base), (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 6).input(material, 2).input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42409_})).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
    }

    public static void offerPlateRecipe(ItemLike output, Ingredient base, Ingredient frame, Ingredient decoration, Consumer<FinishedRecipe> exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 4).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(base), (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 4).input(frame).input(decoration, 4).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
    }

    public static void offerCutleryRecipe(ItemLike output, Ingredient base, Consumer<FinishedRecipe> exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 4).group("kitchen").criterion("has_" + PFMRecipeProvider.getItemPath(base), (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 4).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
    }

    public static void offerPendantRecipe(ItemLike output, Ingredient base, Ingredient hang, Consumer<FinishedRecipe> exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 4).group("lighting").criterion("has_" + PFMRecipeProvider.getItemPath(base), (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 2).input(hang, 2).input((ItemLike)PaladinFurnitureModBlocksItems.SIMPLE_LIGHT).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
    }

    public static void offerToiletRecipe(ItemLike output, Ingredient base, Ingredient material, Consumer<FinishedRecipe> exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 1).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath(material), (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromIngredient(material)).input(base).input(material, 4).input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42446_})).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
    }

    public static void offerWallToiletPaperRecipe(ItemLike output, Ingredient base, Consumer<FinishedRecipe> exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 1).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath((ItemLike)Items.f_42516_), (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromItem((ItemLike)Items.f_42516_)).input(base, 1).input((ItemLike)Items.f_42516_, 8).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
    }

    public static void offerSinkRecipe(ItemLike output, Ingredient base, Consumer<FinishedRecipe> exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 1).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath(base), (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 3).input((ItemLike)Items.f_42083_, 2).input((ItemLike)Items.f_42416_, 1).input((ItemLike)Items.f_42446_, 1).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
    }

    public static void offerBathtubRecipe(ItemLike output, Ingredient base, Consumer<FinishedRecipe> exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 1).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath(base), (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 5).input((ItemLike)Items.f_42083_, 2).input((ItemLike)Items.f_42446_, 1).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
    }

    public static void offerShowerHeadRecipe(ItemLike output, Ingredient base, Consumer<FinishedRecipe> exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 1).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath(base), (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 1).input((ItemLike)Items.f_42451_, 1).input((ItemLike)Items.f_42416_, 1).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
    }

    public static void offerShowerHandleRecipe(ItemLike output, Ingredient base, Consumer<FinishedRecipe> exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 1).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath(base), (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 2).input((ItemLike)Items.f_42451_, 1).input((ItemLike)Items.f_42416_, 1).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
    }

    public static void offerShowerTowelRecipe(ItemLike output, Ingredient base, Consumer<FinishedRecipe> exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 2).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath(base), (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 4).input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42307_}), 2).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
    }

    public static void offerMirrorRecipe(ItemLike output, Ingredient base, Consumer<FinishedRecipe> exporter) {
        SimpleFurnitureRecipeJsonFactory.create(output, 2).group("bathroom").criterion("has_" + PFMRecipeProvider.getItemPath(base), (CriterionTriggerInstance)PFMRecipeProvider.conditionsFromIngredient(base)).input(base, 3).input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41904_}), 2).m_126140_(exporter, new ResourceLocation("pfm", output.m_5456_().m_5524_().replace("block.pfm.", "")));
    }

    private static InventoryChangeTrigger.TriggerInstance conditionsFromItem(MinMaxBounds.Ints count, ItemLike item) {
        return PFMRecipeProvider.conditionsFromItemPredicates(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_151443_(count).m_45077_());
    }

    public static InventoryChangeTrigger.TriggerInstance conditionsFromItem(ItemLike item) {
        return PFMRecipeProvider.conditionsFromItemPredicates(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_());
    }

    public static InventoryChangeTrigger.TriggerInstance conditionsFromIngredient(Ingredient item) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (ItemStack item1 : item.m_43908_()) {
            if (items.contains(item1.m_41720_())) continue;
            items.add(item1.m_41720_());
        }
        return PFMRecipeProvider.conditionsFromItemPredicates(ItemPredicate.Builder.m_45068_().m_151445_((ItemLike[])items.toArray(new Item[0])).m_45077_());
    }

    private static InventoryChangeTrigger.TriggerInstance conditionsFromTag(TagKey<Item> tag) {
        return PFMRecipeProvider.conditionsFromItemPredicates(ItemPredicate.Builder.m_45068_().m_204145_(tag).m_45077_());
    }

    private static InventoryChangeTrigger.TriggerInstance conditionsFromItemPredicates(ItemPredicate ... items) {
        return new InventoryChangeTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, items);
    }

    private static String getItemPath(Ingredient item) {
        ItemStack[] n = item.m_43908_();
        if (n.length > 0) {
            return Registry.f_122827_.m_7981_((Object)n[0].m_41720_()).m_135815_();
        }
        return item.toString();
    }

    private static String getItemPath(ItemLike item) {
        return Registry.f_122827_.m_7981_((Object)item.m_5456_()).m_135815_();
    }
}

