/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.api.provider;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class BlockEntityPreviewProvider
implements PreviewProvider {
    protected final int maxInvSize;
    protected final boolean canUseLootTables;
    protected final int maxRowSize;

    public BlockEntityPreviewProvider(int maxInvSize, boolean canUseLootTables) {
        this.maxInvSize = maxInvSize;
        this.canUseLootTables = canUseLootTables;
        this.maxRowSize = 9;
    }

    public BlockEntityPreviewProvider(int maxInvSize, boolean canUseLootTables, int maxRowSize) {
        this.maxInvSize = maxInvSize;
        this.canUseLootTables = canUseLootTables;
        this.maxRowSize = maxRowSize <= 0 ? 9 : maxRowSize;
    }

    @Override
    public boolean shouldDisplay(PreviewContext context) {
        CompoundTag blockEntityTag = context.stack().m_41737_("BlockEntityTag");
        if (blockEntityTag == null || this.canUseLootTables && blockEntityTag.m_128425_("LootTable", 8)) {
            return false;
        }
        return BlockEntityPreviewProvider.getItemCount(this.getInventory(context)) > 0;
    }

    @Override
    public boolean showTooltipHints(PreviewContext context) {
        return context.stack().m_41737_("BlockEntityTag") != null;
    }

    @Override
    public List<ItemStack> getInventory(PreviewContext context) {
        ListTag itemList;
        int invMaxSize = this.getInventoryMaxSize(context);
        NonNullList inv = NonNullList.m_122780_((int)invMaxSize, (Object)ItemStack.f_41583_);
        CompoundTag blockEntityTag = context.stack().m_41737_("BlockEntityTag");
        if (blockEntityTag != null && blockEntityTag.m_128425_("Items", 9) && (itemList = blockEntityTag.m_128437_("Items", 10)) != null) {
            int len = itemList.size();
            for (int i = 0; i < len; ++i) {
                int slot;
                CompoundTag itemTag = itemList.m_128728_(i);
                ItemStack s = ItemStack.m_41712_((CompoundTag)itemTag);
                if (!itemTag.m_128425_("Slot", 99) || (slot = itemTag.m_128451_("Slot")) < 0 || slot >= invMaxSize) continue;
                inv.set(slot, s);
            }
        }
        return inv;
    }

    @Override
    public int getInventoryMaxSize(PreviewContext context) {
        return this.maxInvSize;
    }

    @Override
    public List<Component> addTooltip(PreviewContext context) {
        CompoundTag blockEntityTag;
        ItemStack stack = context.stack();
        CompoundTag compound = stack.m_41783_();
        Style style = Style.f_131099_.m_131140_(ChatFormatting.GRAY);
        if (this.canUseLootTables && compound != null && compound.m_128425_("BlockEntityTag", 10) && (blockEntityTag = compound.m_128469_("BlockEntityTag")) != null && blockEntityTag.m_128425_("LootTable", 8)) {
            return switch (ShulkerBoxTooltip.config.tooltip.lootTableInfoType) {
                case Configuration.LootTableInfoType.HIDE -> Collections.emptyList();
                case Configuration.LootTableInfoType.SIMPLE -> Collections.singletonList(Component.m_237115_((String)"shulkerboxtooltip.hint.lootTable").m_6270_(style));
                default -> Arrays.asList(Component.m_237115_((String)"shulkerboxtooltip.hint.lootTable.advanced").m_7220_((Component)Component.m_237113_((String)": ")), Component.m_237113_((String)(" " + blockEntityTag.m_128461_("LootTable"))).m_6270_(style));
            };
        }
        if (ShulkerBoxTooltipApi.isFullPreviewKeyPressed()) {
            return Collections.emptyList();
        }
        return BlockEntityPreviewProvider.getItemListTooltip(new ArrayList<Component>(), this.getInventory(context), style);
    }

    public static List<Component> getItemCountTooltip(List<Component> tooltip, @Nullable List<ItemStack> items) {
        return BlockEntityPreviewProvider.getItemListTooltip(tooltip, items, Style.f_131099_.m_131140_(ChatFormatting.GRAY));
    }

    public static List<Component> getItemListTooltip(List<Component> tooltip, @Nullable List<ItemStack> items, Style style) {
        int itemCount = BlockEntityPreviewProvider.getItemCount(items);
        MutableComponent text = itemCount > 0 ? Component.m_237110_((String)"container.shulkerbox.contains", (Object[])new Object[]{itemCount}) : Component.m_237115_((String)"container.shulkerbox.empty");
        tooltip.add((Component)text.m_6270_(style));
        return tooltip;
    }

    @Override
    public int getMaxRowSize(PreviewContext context) {
        return this.maxRowSize;
    }

    private static int getItemCount(@Nullable List<ItemStack> items) {
        int itemCount = 0;
        if (items != null) {
            for (ItemStack stack : items) {
                if (stack.m_41720_() == Items.f_41852_) continue;
                ++itemCount;
            }
        }
        return itemCount;
    }
}

