/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbteams.client.MyTeamScreen;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamMessage;
import dev.ftb.mods.ftbteams.net.FTBTeamsNet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;

public class SyncMessageHistoryMessage
extends BaseS2CMessage {
    private final List<TeamMessage> messages;

    public SyncMessageHistoryMessage(FriendlyByteBuf buf) {
        long now = System.currentTimeMillis();
        int nMessages = buf.m_130242_();
        this.messages = new ArrayList<TeamMessage>(nMessages);
        for (int i = 0; i < nMessages; ++i) {
            this.messages.add(new TeamMessage(now, buf));
        }
    }

    public SyncMessageHistoryMessage(Team team) {
        this.messages = team.getMessageHistory();
    }

    public MessageType getType() {
        return FTBTeamsNet.SYNC_MESSAGE_HISTORY;
    }

    public void write(FriendlyByteBuf buf) {
        long now = System.currentTimeMillis();
        buf.m_130130_(this.messages.size());
        for (TeamMessage tm : this.messages) {
            tm.write(now, buf);
        }
    }

    public void handle(NetworkManager.PacketContext context) {
        ClientTeam team = ClientTeamManager.INSTANCE.selfTeam;
        if (team != null) {
            team.setMessageHistory(this.messages);
            MyTeamScreen.refreshIfOpen();
        }
    }
}

