/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.inventoryaccessport;

import com.hlysine.create_connected.content.inventoryaccessport.InventoryAccessPortBlock;
import com.hlysine.create_connected.content.inventoryaccessport.WrappedItemHandler;
import com.simibubi.create.content.redstone.DirectedDirectionalBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.utility.BlockFace;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryAccessPortBlockEntity
extends SmartBlockEntity {
    protected LazyOptional<IItemHandler> itemCapability = LazyOptional.empty();
    private InvManipulationBehaviour observedInventory;
    private boolean powered = false;

    public InventoryAccessPortBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        CapManipulationBehaviourBase.InterfaceProvider towardBlockFacing = (w, p, s) -> new BlockFace(p, DirectedDirectionalBlock.getTargetDirection((BlockState)s));
        this.observedInventory = new InvManipulationBehaviour((SmartBlockEntity)this, towardBlockFacing);
        behaviours.add((BlockEntityBehaviour)this.observedInventory);
    }

    public boolean isAttached() {
        return !this.powered && this.observedInventory.hasInventory() && !(this.observedInventory.getInventory() instanceof WrappedItemHandler);
    }

    public void updateConnectedInventory() {
        this.observedInventory.findNewCapability();
        boolean previouslyPowered = this.powered;
        this.powered = this.f_58857_.m_46753_(this.f_58858_);
        if (this.powered != previouslyPowered) {
            this.notifyUpdate();
        }
        if (this.isAttached() != ((Boolean)this.m_58900_().m_61143_((Property)InventoryAccessPortBlock.ATTACHED)).booleanValue()) {
            BlockState state = (BlockState)this.m_58900_().m_61122_((Property)InventoryAccessPortBlock.ATTACHED);
            this.f_58857_.m_46597_(this.f_58858_, state);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.isItemHandlerCap(cap)) {
            this.initCapability();
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.powered = compound.m_128471_("Powered");
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128379_("Powered", this.powered);
    }

    private IItemHandler getConnectedItemHandler() {
        if (this.powered) {
            return null;
        }
        IItemHandler handler = (IItemHandler)this.observedInventory.getInventory();
        if (handler instanceof WrappedItemHandler) {
            return null;
        }
        return handler;
    }

    private void initCapability() {
        this.itemCapability = LazyOptional.of(() -> new InventoryAccessHandler());
    }

    private class InventoryAccessHandler
    implements WrappedItemHandler {
        private final ThreadLocal<Boolean> recursionGuard = ThreadLocal.withInitial(() -> false);

        private InventoryAccessHandler() {
        }

        private <T> T preventRecursion(Supplier<T> value, T defaultValue) {
            if (this.recursionGuard.get().booleanValue()) {
                return defaultValue;
            }
            this.recursionGuard.set(true);
            T result = value.get();
            this.recursionGuard.set(false);
            return result;
        }

        public int getSlots() {
            return this.preventRecursion(() -> {
                IItemHandler handler = InventoryAccessPortBlockEntity.this.getConnectedItemHandler();
                return handler == null ? 0 : handler.getSlots();
            }, 0);
        }

        @NotNull
        public ItemStack getStackInSlot(int i) {
            return this.preventRecursion(() -> {
                IItemHandler handler = InventoryAccessPortBlockEntity.this.getConnectedItemHandler();
                return handler == null ? ItemStack.f_41583_ : handler.getStackInSlot(i);
            }, ItemStack.f_41583_);
        }

        @NotNull
        public ItemStack insertItem(int i, @NotNull ItemStack itemStack, boolean b) {
            return this.preventRecursion(() -> {
                IItemHandler handler = InventoryAccessPortBlockEntity.this.getConnectedItemHandler();
                return handler == null ? itemStack : handler.insertItem(i, itemStack, b);
            }, itemStack);
        }

        @NotNull
        public ItemStack extractItem(int i, int i1, boolean b) {
            return this.preventRecursion(() -> {
                IItemHandler handler = InventoryAccessPortBlockEntity.this.getConnectedItemHandler();
                return handler == null ? ItemStack.f_41583_ : handler.extractItem(i, i1, b);
            }, ItemStack.f_41583_);
        }

        public int getSlotLimit(int i) {
            return this.preventRecursion(() -> {
                IItemHandler handler = InventoryAccessPortBlockEntity.this.getConnectedItemHandler();
                return handler == null ? 0 : handler.getSlotLimit(i);
            }, 0);
        }

        public boolean isItemValid(int i, @NotNull ItemStack itemStack) {
            return this.preventRecursion(() -> {
                IItemHandler handler = InventoryAccessPortBlockEntity.this.getConnectedItemHandler();
                return handler != null && handler.isItemValid(i, itemStack);
            }, false);
        }
    }
}

