/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.datagen.advancements;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.hlysine.create_connected.CCBlocks;
import com.hlysine.create_connected.CCItems;
import com.hlysine.create_connected.datagen.advancements.CCAdvancement;
import com.mojang.logging.LogUtils;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class CCAdvancements
implements DataProvider {
    public static final List<CCAdvancement> ENTRIES = new ArrayList<CCAdvancement>();
    public static final CCAdvancement START = null;
    public static final CCAdvancement ROOT = CCAdvancements.create("root", b -> b.icon((ItemProviderEntry<?>)CCBlocks.PARALLEL_GEARBOX).title("Welcome to Create: Connected").description("Gadgets for all situations").awardedForFree().special(CCAdvancement.TaskType.SILENT));
    public static final CCAdvancement SHEAR_PIN = CCAdvancements.create("shear_pin", b -> b.icon((ItemProviderEntry<?>)CCBlocks.SHEAR_PIN).title("Snap!").description("Blow a Shear Pin").after(ROOT));
    public static final CCAdvancement OVERSTRESS_CLUTCH = CCAdvancements.create("overstress_clutch", b -> b.icon((ItemProviderEntry<?>)CCBlocks.OVERSTRESS_CLUTCH).title("Circuit Breaker").description("Trigger an Overstress Clutch").after(SHEAR_PIN));
    public static final CCAdvancement BRASS_GEARBOX = CCAdvancements.create("brass_gearbox", b -> b.icon((ItemProviderEntry<?>)CCBlocks.BRASS_GEARBOX).title("Serious Organization").description("Place down a Brass Gearbox").whenBlockPlaced((Block)CCBlocks.BRASS_GEARBOX.get()).after(ROOT));
    public static final CCAdvancement OVERPOWERED_BRAKE = CCAdvancements.create("overpowered_brake_0", b -> b.icon((ItemProviderEntry<?>)CCBlocks.BRAKE).title("Overpowered").description("Keep a network running at speed with a powered brake attached").after(ROOT).special(CCAdvancement.TaskType.SECRET));
    public static final CCAdvancement CONTROL_CHIP = CCAdvancements.create("control_chip", b -> b.icon((ItemProviderEntry<?>)CCItems.CONTROL_CHIP).title("Precise Fabrication").description("Assemble a Control Chip").whenIconCollected().after(ROOT).special(CCAdvancement.TaskType.NOISY));
    public static final CCAdvancement SEQUENCED_PULSE_GENERATOR = CCAdvancements.create("sequenced_pulse_generator", b -> b.icon((ItemProviderEntry<?>)CCBlocks.SEQUENCED_PULSE_GENERATOR).title("Computational Supremacy").description("Place down a Sequenced Pulse Generator").whenBlockPlaced((Block)CCBlocks.SEQUENCED_PULSE_GENERATOR.get()).after(CONTROL_CHIP));
    public static final CCAdvancement PULSE_GEN_INFINITE_LOOP = CCAdvancements.create("pulse_generator_infinite_loop", b -> b.icon((ItemProviderEntry<?>)CCItems.INCOMPLETE_CONTROL_CHIP).title("Infinite Loop").description("Overload a Sequenced Pulse Generator with a buggy program").after(SEQUENCED_PULSE_GENERATOR).special(CCAdvancement.TaskType.SECRET));
    public static final CCAdvancement END = null;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final DataGenerator generator;

    private static CCAdvancement create(String id, UnaryOperator<CCAdvancement.Builder> b) {
        return new CCAdvancement(id, b);
    }

    public CCAdvancements(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void m_213708_(@NotNull CachedOutput cache) throws IOException {
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = p_204017_3_ -> {
            if (!set.add(p_204017_3_.m_138327_())) {
                throw new IllegalStateException("Duplicate advancement " + p_204017_3_.m_138327_());
            }
            Path path1 = CCAdvancements.getPath(path, p_204017_3_);
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)p_204017_3_.m_138313_().m_138400_(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
            }
        };
        for (CCAdvancement advancement : ENTRIES) {
            advancement.save(consumer);
        }
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.m_138327_().m_135827_() + "/advancements/" + advancementIn.m_138327_().m_135815_() + ".json");
    }

    @NotNull
    public String m_6055_() {
        return "Advancements for Create: Connected";
    }

    public static void provideLang(BiConsumer<String, String> consumer) {
        for (CCAdvancement advancement : ENTRIES) {
            advancement.provideLang(consumer);
        }
    }

    public static void register() {
    }
}

