/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.advancedsolars.items;

import ic2.api.addons.IModule;
import ic2.api.events.ArmorSlotEvent;
import ic2.api.items.armor.IArmorModule;
import ic2.api.items.electric.ElectricItem;
import ic2.api.network.buffer.INetworkDataBuffer;
import ic2.core.IC2;
import ic2.core.item.base.PropertiesBuilder;
import ic2.core.item.wearable.base.IBaseArmorModule;
import ic2.core.item.wearable.base.IC2ModularElectricArmor;
import ic2.core.platform.registries.IC2Items;
import ic2.core.utils.collection.CollectionUtils;
import ic2.core.utils.helpers.StackUtil;
import ic2.core.utils.tooltips.ToolTipHelper;
import ic2.curioplugin.core.CurioPlugin;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import trinsdar.advancedsolars.blocks.BlockEntityAdvancedSolarPanel;
import trinsdar.advancedsolars.util.AdvancedSolarLang;

public class ItemArmorAdvancedSolarHelmet
extends IC2ModularElectricArmor
implements IBaseArmorModule {
    private int production;
    private int lowerProduction;
    private int tier;
    private final boolean nano;
    protected Object2IntMap<IArmorModule.ModuleType> alternative = new Object2IntOpenHashMap();

    public ItemArmorAdvancedSolarHelmet(String name, int pro, int lowPro, int tier) {
        super(name + "_solar_helmet", EquipmentSlot.HEAD, new PropertiesBuilder().rarity(Rarity.RARE));
        this.production = pro;
        this.lowerProduction = lowPro;
        this.tier = tier;
        this.nano = name.equals("advanced");
        IC2Items.registerItem((Item)this);
        this.addSlotType(IArmorModule.ModuleType.BATTERY, 1);
        this.addSlotType(IArmorModule.ModuleType.GENERIC, this.nano ? 2 : 3);
        MinecraftForge.EVENT_BUS.post((Event)new ArmorSlotEvent((Item)this, "Advanced Solar Helmets", this.f_40377_, this.types));
        if (this.nano) {
            this.alternative.put((Object)IArmorModule.ModuleType.HUD, 9);
            this.alternative.mergeInt((Object)IArmorModule.ModuleType.BATTERY, 1, Integer::sum);
            this.alternative.mergeInt((Object)IArmorModule.ModuleType.CHARGER, 1, Integer::sum);
            this.alternative.mergeInt((Object)IArmorModule.ModuleType.GENERIC, 3, Integer::sum);
            MinecraftForge.EVENT_BUS.post((Event)new ArmorSlotEvent((Item)this, "Advanced Solar Helmet Alternative", this.f_40377_, this.alternative));
        }
    }

    public Object2IntMap<IArmorModule.ModuleType> getModuleLimits(ItemStack stack) {
        return StackUtil.getNbtData((ItemStack)stack).m_128471_("upgraded") ? Object2IntMaps.unmodifiable(this.alternative) : Object2IntMaps.unmodifiable((Object2IntMap)this.types);
    }

    public ItemStack createDefaultArmor() {
        ItemStack stack = new ItemStack((ItemLike)this);
        Object2ObjectSortedMap types = CollectionUtils.createLinkedMap();
        Item battery = this.nano ? IC2Items.ENERGY_CRYSTAL : IC2Items.LAPOTRON_CRYSTAL;
        types.put(IArmorModule.ModuleType.BATTERY, ObjectArrayList.wrap((Object[])new ItemStack[]{new ItemStack((ItemLike)battery)}));
        if (!this.nano) {
            types.put(IArmorModule.ModuleType.GENERIC, ObjectArrayList.wrap((Object[])new ItemStack[]{new ItemStack((ItemLike)IC2Items.AUTO_FEED_MODULE), new ItemStack((ItemLike)IC2Items.AIR_REFILL_MODULE), new ItemStack((ItemLike)IC2Items.PROTECTION_MODULE)}));
        }
        ItemArmorAdvancedSolarHelmet.setAndInstallTypes((ItemStack)stack, (Map)types);
        return stack;
    }

    public double getDamageAbsorptionRatio(ItemStack stack) {
        return this.nano ? 0.9 : 1.0;
    }

    public int getEnergyPerDamage(ItemStack stack) {
        return this.nano ? 800 : 900;
    }

    public boolean isFullyAbsorbingFallDamage(ItemStack stack) {
        return !this.nano || StackUtil.getNbtData((ItemStack)stack).m_128471_("upgraded");
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public boolean canInstallInArmor(ItemStack stack, ItemStack armor, EquipmentSlot type) {
        return false;
    }

    public void addToolTip(ItemStack stack, Player player, TooltipFlag type, ToolTipHelper helper) {
        super.addToolTip(stack, player, type, helper);
        helper.addDataTooltip(AdvancedSolarLang.helmetProduction, new Object[]{this.production});
        helper.addDataTooltip(AdvancedSolarLang.helmetLowerProduction, new Object[]{this.lowerProduction});
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        super.onArmorTick(stack, world, player);
        if (!IC2.PLATFORM.isRendering() && world.m_6042_().f_223549_() && world.m_46861_(player.m_20183_())) {
            if (BlockEntityAdvancedSolarPanel.isSunVisible(world, player.m_20183_())) {
                this.chargeInventory(player, this.production, this.tier, stack);
            } else {
                this.chargeInventory(player, this.lowerProduction, this.tier, stack);
            }
        }
    }

    public void onTick(ItemStack stack, ItemStack armor, Level world, Player player) {
    }

    public String getArmorTexture() {
        return "advanced_solars:textures/models/" + this.getRegistryName().m_135815_();
    }

    public String getTextureName() {
        return this.getRegistryName().m_135815_();
    }

    public String getTextureFolder() {
        return "solar_helmets";
    }

    public int chargeInventory(Player player, int provided, int tier, ItemStack helmet) {
        List<NonNullList> invList = Arrays.asList(player.m_150109_().f_35975_, player.m_150109_().f_35976_, player.m_150109_().f_35974_);
        if (ElectricItem.MANAGER.getCharge(helmet) != ElectricItem.MANAGER.getCapacity(helmet)) {
            int charged = ElectricItem.MANAGER.charge(helmet, provided, this.tier, false, false);
            provided -= charged;
        } else {
            int i;
            for (NonNullList inventory : invList) {
                int inventorySize = inventory.size();
                for (i = 0; i < inventorySize && provided > 0; ++i) {
                    ItemStack tStack = (ItemStack)inventory.get(i);
                    if (tStack.m_41619_()) continue;
                    int charged = ElectricItem.MANAGER.charge(tStack, provided, this.tier, false, false);
                    provided -= charged;
                }
            }
            IModule plugin = IC2.PLUGINS.getModule("curio");
            if (plugin != null) {
                IItemHandler inv = new CurioPlugin().getCurioHandler(player);
                for (i = 0; i < inv.getSlots() && provided > 0; ++i) {
                    provided = (int)((double)provided - (double)ElectricItem.MANAGER.charge(inv.getStackInSlot(i), provided, tier, false, false));
                }
            }
        }
        return provided;
    }

    public IArmorModule.ModuleType getType(ItemStack itemStack) {
        return IArmorModule.ModuleType.CHARGER;
    }

    public boolean handlePacket(Player player, ItemStack itemStack, ItemStack itemStack1, String s, INetworkDataBuffer iNetworkDataBuffer, Dist dist) {
        return false;
    }
}

