/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.advancedsolars.rei;

import com.mojang.blaze3d.systems.RenderSystem;
import ic2.api.recipes.registries.IElectrolyzerRecipeList;
import ic2.core.inventory.container.ContainerComponent;
import ic2.core.inventory.gui.ComponentContainerScreen;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import trinsdar.advancedsolars.blocks.BlockEntityMolecularTransformer;
import trinsdar.advancedsolars.util.AdvancedSolarsRecipes;
import trinsdar.advancedsolars.util.Registry;

@REIPluginClient
public class AdvancedSolarsREIPlugin
implements REIClientPlugin {
    public static final CategoryIdentifier<TransformerDisplay> TRANSFORMER = CategoryIdentifier.of((ResourceLocation)new ResourceLocation("advanced_solars", "mol_transformer"));

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)TransformerCategory.INSTANCE);
        registry.addWorkstations(TRANSFORMER, new EntryStack[]{EntryStacks.of((ItemLike)Registry.MOLECULAR_TRANSFORMER.m_5456_())});
    }

    public void registerDisplays(DisplayRegistry registry) {
        AdvancedSolarsRecipes.MOLECULAR_TRANSFORMER.getRecipes().forEach(recipe -> registry.add((Display)new TransformerDisplay((IElectrolyzerRecipeList.ElectrolyzerRecipe)recipe)));
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerClickArea(ComponentContainerScreen.class, (ClickArea)new MolecularTransformerGUIHandler());
    }

    public static class TransformerCategory
    implements DisplayCategory<TransformerDisplay> {
        public static final TransformerCategory INSTANCE = new TransformerCategory();

        public CategoryIdentifier<? extends TransformerDisplay> getCategoryIdentifier() {
            return TRANSFORMER;
        }

        public List<Widget> setupDisplay(TransformerDisplay display, Rectangle bounds) {
            ObjectArrayList widgets = new ObjectArrayList();
            int minX = bounds.getMinX();
            int minY = bounds.getMinY();
            int n = bounds.getCenterY();
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            int centerY = n - 9 / 2;
            ResourceLocation texture = new ResourceLocation("advanced_solars", "textures/gui/transformer_recipe.png");
            ItemStack input = display.recipe().getInput();
            ItemStack output = display.recipe().getOutput();
            widgets.add(Widgets.createTexturedWidget((ResourceLocation)texture, (int)bounds.getMinX(), (int)bounds.getMinY(), (float)0.0f, (float)0.0f, (int)176, (int)88));
            widgets.add(TransformerCategory.createProgressBar(minX + 20, minY + 40, texture));
            widgets.add(Widgets.createSlot((Point)new Point(minX + 17, minY + 19)).entries((Collection)EntryIngredients.of((ItemStack)input)).markInput().disableBackground());
            widgets.add(Widgets.createSlot((Point)new Point(minX + 17, minY + 54)).entries((Collection)EntryIngredients.of((ItemStack)output)).markOutput().disableBackground());
            String inputName = input.m_41611_().getString().replaceAll("\\[", "").replaceAll("]", "");
            String outputName = output.m_41611_().getString().replaceAll("\\[", "").replaceAll("]", "");
            widgets.add(Widgets.createLabel((Point)new Point(minX + 50, centerY - 10), (Component)Component.m_237110_((String)"item_info.advanced_solars.molecular.input", (Object[])new Object[]{inputName})).shadow(false).leftAligned());
            widgets.add(Widgets.createLabel((Point)new Point(minX + 50, centerY), (Component)Component.m_237110_((String)"item_info.advanced_solars.molecular.output", (Object[])new Object[]{outputName})).shadow(false).leftAligned());
            widgets.add(Widgets.createLabel((Point)new Point(minX + 50, centerY + 10), (Component)Component.m_237110_((String)"item_info.advanced_solars.molecular.eu", (Object[])new Object[]{display.recipe().getEnergy()})).shadow(false).leftAligned());
            return widgets;
        }

        public Component getTitle() {
            return Registry.MOLECULAR_TRANSFORMER.m_49954_();
        }

        public Renderer getIcon() {
            return EntryStacks.of((ItemLike)Registry.MOLECULAR_TRANSFORMER.m_5456_());
        }

        public int getDisplayWidth(TransformerDisplay display) {
            return 176;
        }

        public int getDisplayHeight() {
            return 88;
        }

        private static Widget createProgressBar(int x, int y, ResourceLocation texture) {
            return Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
                RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
                helper.m_93228_(matrices, x, y, 20, 40, 10, 9);
                double i = (double)System.currentTimeMillis() / 2000.0 % 1.0 * 10.0;
                if (i < 0.0) {
                    i = 0.0;
                }
                helper.m_93228_(matrices, x, y, 177, 3, 10, (int)i);
            });
        }
    }

    public static class MolecularTransformerGUIHandler
    implements ClickArea<ComponentContainerScreen> {
        public ClickArea.Result handle(ClickArea.ClickAreaContext<ComponentContainerScreen> clickAreaContext) {
            Rectangle recipeBox;
            ComponentContainerScreen container = (ComponentContainerScreen)clickAreaContext.getScreen();
            Point mousePoint = clickAreaContext.getMousePosition();
            ContainerComponent comp = (ContainerComponent)container.getCastedContainer(ContainerComponent.class);
            if (comp.getHolder() instanceof BlockEntityMolecularTransformer && (recipeBox = new Rectangle(container.getGuiLeft() + 29, container.getGuiTop() + 29, 10, 26)).contains(mousePoint)) {
                return ClickArea.Result.success().category(TRANSFORMER);
            }
            return ClickArea.Result.success();
        }
    }

    public static class TransformerDisplay
    extends BasicDisplay {
        IElectrolyzerRecipeList.ElectrolyzerRecipe RECIPE;

        public TransformerDisplay(IElectrolyzerRecipeList.ElectrolyzerRecipe recipe) {
            this(Collections.singletonList(EntryIngredients.of((ItemStack)recipe.getInput())), Collections.singletonList(EntryIngredients.of((ItemStack)recipe.getOutput())));
            this.RECIPE = recipe;
        }

        public TransformerDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs) {
            super(inputs, outputs);
        }

        public IElectrolyzerRecipeList.ElectrolyzerRecipe recipe() {
            return this.RECIPE;
        }

        public CategoryIdentifier<?> getCategoryIdentifier() {
            return TRANSFORMER;
        }
    }
}

