/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import net.lionarius.skinrestorer.mixin.ChunkMapAccessor;
import net.lionarius.skinrestorer.mixin.TrackedEntityAccessorInvoker;
import net.lionarius.skinrestorer.util.JsonUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.BiomeManager;

public final class PlayerUtils {
    public static final String TEXTURES_KEY = "textures";

    private PlayerUtils() {
    }

    public static Component createPlayerListComponent(Collection<ServerPlayer> players) {
        MutableComponent component = Component.m_237119_();
        int index = 0;
        for (ServerPlayer player : players) {
            component.m_7220_(Objects.requireNonNull(player.m_5446_()));
            if (++index >= players.size()) continue;
            component.m_130946_(", ");
        }
        return component;
    }

    public static boolean isFakePlayer(ServerPlayer player) {
        return player.getClass() != ServerPlayer.class;
    }

    public static void refreshPlayer(ServerPlayer player) {
        ServerLevel serverLevel = player.m_9236_();
        PlayerList playerList = serverLevel.m_7654_().m_6846_();
        ChunkMap chunkMap = serverLevel.m_7726_().f_8325_;
        playerList.m_11268_((Packet)new ClientboundPlayerInfoPacket(ClientboundPlayerInfoPacket.Action.REMOVE_PLAYER, new ServerPlayer[]{player}));
        playerList.m_11268_((Packet)new ClientboundPlayerInfoPacket(ClientboundPlayerInfoPacket.Action.ADD_PLAYER, new ServerPlayer[]{player}));
        TrackedEntityAccessorInvoker trackedEntity = (TrackedEntityAccessorInvoker)((ChunkMapAccessor)chunkMap).getEntityMap().get(player.m_19879_());
        if (trackedEntity != null) {
            Set<ServerPlayerConnection> seenBy = Set.copyOf(trackedEntity.getSeenBy());
            for (ServerPlayerConnection observerConnection : seenBy) {
                ServerPlayer observer = observerConnection.m_142253_();
                trackedEntity.invokeRemovePlayer(observer);
                TrackedEntityAccessorInvoker trackedObserverEntity = (TrackedEntityAccessorInvoker)((ChunkMapAccessor)chunkMap).getEntityMap().get(observer.m_19879_());
                if (trackedObserverEntity != null) {
                    trackedObserverEntity.invokeRemovePlayer(player);
                    trackedObserverEntity.invokeUpdatePlayer(player);
                }
                trackedEntity.invokeUpdatePlayer(observer);
            }
        }
        if (!player.m_21224_()) {
            player.f_8906_.m_9829_((Packet)new ClientboundRespawnPacket(player.m_9236_().m_220362_(), player.m_9236_().m_46472_(), BiomeManager.m_47877_((long)player.m_9236_().m_7328_()), player.f_8941_.m_9290_(), player.f_8941_.m_9293_(), player.m_9236_().m_46659_(), player.m_9236_().m_8584_(), true, player.m_219759_()));
            player.f_8906_.m_9774_(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_(), player.m_146909_());
            player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
            Entity vehicle = player.m_20202_();
            if (vehicle != null) {
                player.f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket(vehicle));
            }
            if (!player.m_20197_().isEmpty()) {
                player.f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket((Entity)player));
            }
            player.m_6885_();
            player.m_6756_(0);
            playerList.m_11289_(player);
            playerList.m_11229_(player, serverLevel);
            playerList.m_11292_(player);
            PlayerUtils.sendActivePlayerEffects(player);
        }
    }

    private static void sendActivePlayerEffects(ServerPlayer player) {
        for (MobEffectInstance effect : player.m_21220_()) {
            player.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(player.m_19879_(), effect));
        }
    }

    public static GameProfile cloneGameProfile(GameProfile profile) {
        GameProfile newProfile = new GameProfile(profile.getId(), profile.getName());
        newProfile.getProperties().putAll((Multimap)profile.getProperties());
        return newProfile;
    }

    public static Property getPlayerSkin(GameProfile profile) {
        return (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)TEXTURES_KEY), null);
    }

    public static void applyRestoredSkin(GameProfile profile, Property skin) {
        profile.getProperties().removeAll((Object)TEXTURES_KEY);
        if (skin != null) {
            profile.getProperties().put((Object)TEXTURES_KEY, (Object)skin);
        }
    }

    public static boolean areSkinPropertiesEquals(Property x, Property y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x.equals(y)) {
            return true;
        }
        JsonObject xJson = JsonUtils.skinPropertyToJson(x);
        JsonObject yJson = JsonUtils.skinPropertyToJson(y);
        if (xJson == null || yJson == null) {
            return false;
        }
        return xJson.equals((Object)yJson);
    }

    public static GameProfile toProfile(MinecraftProfilePropertiesResponse response) {
        GameProfile profile = new GameProfile(response.getId(), response.getName());
        profile.getProperties().putAll((Multimap)response.getProperties());
        return profile;
    }
}

