/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.GatherTexturesContext;
import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.SpriteIdentifier;
import com.supermartijn642.fusion.api.model.data.BaseModelData;
import com.supermartijn642.fusion.api.model.data.ConnectingModelData;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.predicate.DefaultConnectionPredicates;
import com.supermartijn642.fusion.api.predicate.FusionPredicateRegistry;
import com.supermartijn642.fusion.model.types.base.BaseModelDataImpl;
import com.supermartijn642.fusion.model.types.base.BaseModelElement;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.model.types.connecting.ConnectingBakedModel;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelDataImpl;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.NamedRenderTypeManager;
import org.jetbrains.annotations.Nullable;

public class ConnectingModelType
implements ModelType<ConnectingModelData> {
    public static final String DEFAULT_CONNECTION_KEY = "default";

    @Override
    public Collection<ResourceLocation> getModelDependencies(ConnectingModelData data) {
        return DefaultModelTypes.BASE.getModelDependencies(data);
    }

    @Override
    public Collection<SpriteIdentifier> getTextureDependencies(GatherTexturesContext context, ConnectingModelData data) {
        return DefaultModelTypes.BASE.getTextureDependencies(context, data);
    }

    @Override
    @Nullable
    public BlockModel getAsVanillaModel(ConnectingModelData data) {
        return DefaultModelTypes.BASE.getAsVanillaModel(data);
    }

    @Override
    public List<ResourceLocation> getParentModels(ConnectingModelData data) {
        return data.getParents();
    }

    @Override
    public BakedModel bake(ModelBakingContext context, ConnectingModelData data) {
        ((ConnectingModelDataImpl)data).validateParents(context::getModel, context.getModelIdentifier());
        List<BaseModelQuad> quads = ((ConnectingModelDataImpl)data).bakeQuads(context);
        boolean ambientOcclusion = ((ConnectingModelDataImpl)data).findProperty(context, model -> model.f_111424_, true);
        boolean isGui3d = ((BaseModelDataImpl)((Object)data)).findProperty(context, model -> model == ModelBakery.f_119232_ ? Boolean.valueOf(false) : null, true);
        boolean usesBlockLight = ((BaseModelDataImpl)((Object)data)).findProperty(context, model -> model.f_111423_, BlockModel.GuiLight.SIDE).m_111526_();
        TextureAtlasSprite particleSprite = context.getTexture(((ConnectingModelDataImpl)data).findParticleSprite(context));
        ItemTransform transformThirdPersonLeftHand = ((ConnectingModelDataImpl)data).findProperty(context, model -> model.f_111425_.m_111810_(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND) ? model.f_111425_.m_111808_(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND) : null, ItemTransform.f_111754_);
        ItemTransform transformThirdPersonRightHand = ((ConnectingModelDataImpl)data).findProperty(context, model -> model.f_111425_.m_111810_(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) ? model.f_111425_.m_111808_(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) : null, ItemTransform.f_111754_);
        ItemTransform transformFirstPersonLeftHand = ((ConnectingModelDataImpl)data).findProperty(context, model -> model.f_111425_.m_111810_(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND) ? model.f_111425_.m_111808_(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND) : null, ItemTransform.f_111754_);
        ItemTransform transformFirstPersonRightHand = ((ConnectingModelDataImpl)data).findProperty(context, model -> model.f_111425_.m_111810_(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) ? model.f_111425_.m_111808_(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) : null, ItemTransform.f_111754_);
        ItemTransform transformHead = ((ConnectingModelDataImpl)data).findProperty(context, model -> model.f_111425_.m_111810_(ItemTransforms.TransformType.HEAD) ? model.f_111425_.m_111808_(ItemTransforms.TransformType.HEAD) : null, ItemTransform.f_111754_);
        ItemTransform transformGui = ((ConnectingModelDataImpl)data).findProperty(context, model -> model.f_111425_.m_111810_(ItemTransforms.TransformType.GUI) ? model.f_111425_.m_111808_(ItemTransforms.TransformType.GUI) : null, ItemTransform.f_111754_);
        ItemTransform transformGround = ((ConnectingModelDataImpl)data).findProperty(context, model -> model.f_111425_.m_111810_(ItemTransforms.TransformType.GROUND) ? model.f_111425_.m_111808_(ItemTransforms.TransformType.GROUND) : null, ItemTransform.f_111754_);
        ItemTransform transformFixed = ((ConnectingModelDataImpl)data).findProperty(context, model -> model.f_111425_.m_111810_(ItemTransforms.TransformType.FIXED) ? model.f_111425_.m_111808_(ItemTransforms.TransformType.FIXED) : null, ItemTransform.f_111754_);
        ItemTransforms itemTransforms = new ItemTransforms(transformThirdPersonLeftHand, transformThirdPersonRightHand, transformFirstPersonLeftHand, transformFirstPersonRightHand, transformHead, transformGui, transformGround, transformFixed);
        ItemOverrides itemOverrides = data.getVanillaModel().f_111426_.isEmpty() ? ItemOverrides.f_111734_ : new ItemOverrides(context.getModelBakery(), data.getVanillaModel(), i -> context.getModel((ResourceLocation)i).getAsVanillaModel(), data.getVanillaModel().f_111426_);
        RenderType forgeRenderType = NamedRenderTypeManager.get((ResourceLocation)data.getVanillaModel().customData.getRenderTypeHint()).block();
        return new ConnectingBakedModel(quads, ambientOcclusion, isGui3d, usesBlockLight, particleSprite, itemTransforms, itemOverrides, forgeRenderType);
    }

    @Override
    public ConnectingModelData deserialize(JsonObject json) throws JsonParseException {
        BaseModelData base = (BaseModelData)DefaultModelTypes.BASE.deserialize(json);
        HashMap<String, ConnectionPredicate> predicates = new HashMap<String, ConnectionPredicate>();
        HashMap<String, String> connectionReferences = new HashMap<String, String>();
        predicates.put(DEFAULT_CONNECTION_KEY, DefaultConnectionPredicates.isSameState());
        if (json.has("connections")) {
            JsonElement connectionsElement = json.get("connections");
            if (connectionsElement.isJsonArray() || connectionsElement.isJsonObject() && connectionsElement.getAsJsonObject().has("type")) {
                predicates.put(DEFAULT_CONNECTION_KEY, ConnectingModelType.loadPredicate(connectionsElement, "connections"));
            } else if (connectionsElement.isJsonObject()) {
                JsonObject object = connectionsElement.getAsJsonObject();
                if (object.size() == 0) {
                    throw new JsonParseException("Property 'connections' must have a 'type' key or keys per texture!");
                }
                for (String texture : object.keySet()) {
                    if (object.get(texture).isJsonPrimitive() && object.getAsJsonPrimitive(texture).isString()) {
                        connectionReferences.put(texture, object.get(texture).getAsString());
                        continue;
                    }
                    predicates.put(texture, ConnectingModelType.loadPredicate(object.get(texture), texture));
                }
            } else {
                throw new JsonParseException("Property 'connections' must be an array!");
            }
        }
        ArrayList<ConnectingModelElement> elements = new ArrayList<ConnectingModelElement>(((BaseModelDataImpl)base).getElements().size());
        JsonArray elementsJson = json.getAsJsonArray("elements");
        for (int i = 0; i < ((BaseModelDataImpl)base).getElements().size(); ++i) {
            JsonObject elementFaces = elementsJson.get(i).getAsJsonObject().getAsJsonObject("faces");
            BaseModelElement baseElement = ((BaseModelDataImpl)base).getElements().get(i);
            EnumMap<Direction, String> connectionKeys = null;
            if (elementFaces != null) {
                for (Direction side : Direction.values()) {
                    if (!elementFaces.has(side.m_122433_()) || !elementFaces.get(side.m_122433_()).isJsonObject() || !elementFaces.getAsJsonObject(side.m_122433_()).has("connections")) continue;
                    JsonElement connectionsJson = elementFaces.getAsJsonObject(side.m_122433_()).get("connections");
                    if (!connectionsJson.isJsonPrimitive() || !connectionsJson.getAsJsonPrimitive().isString()) {
                        throw new JsonParseException("Face property 'connections' must be a string!");
                    }
                    String key = connectionsJson.getAsString();
                    if (key.isEmpty()) {
                        throw new JsonParseException("Face property 'connections' must not be empty!");
                    }
                    if (connectionKeys == null) {
                        connectionKeys = new EnumMap<Direction, String>(Direction.class);
                    }
                    connectionKeys.put(side, key);
                }
            }
            elements.add(new ConnectingModelElement(baseElement.f_111308_, baseElement.f_111309_, baseElement.f_111310_, baseElement.f_111311_, baseElement.f_111312_, baseElement.light_emission, connectionKeys));
        }
        return new ConnectingModelDataImpl(base.getVanillaModel(), base.getParents(), elements, predicates, connectionReferences);
    }

    @Override
    public JsonObject serialize(ConnectingModelData value) {
        JsonObject json = DefaultModelTypes.BASE.serialize(value);
        Map<String, ConnectionPredicate> predicates = value.getAllConnectionPredicates();
        if (predicates.size() == 1 && predicates.containsKey(DEFAULT_CONNECTION_KEY)) {
            json.add("connections", (JsonElement)FusionPredicateRegistry.serializeConnectionPredicate(predicates.get(DEFAULT_CONNECTION_KEY)));
        } else if (!predicates.isEmpty()) {
            JsonObject connectionsJson = new JsonObject();
            predicates.forEach((texture, predicate) -> connectionsJson.add(texture, (JsonElement)FusionPredicateRegistry.serializeConnectionPredicate(predicate)));
            json.add("connections", (JsonElement)connectionsJson);
        }
        for (int i = 0; i < ((ConnectingModelDataImpl)value).getElements().size(); ++i) {
            JsonObject elementFaces;
            Map<Direction, String> connectionKeys = ((ConnectingModelDataImpl)value).getElements().get((int)i).faceConnectionKeys;
            if (connectionKeys.isEmpty() || (elementFaces = json.getAsJsonArray("elements").get(i).getAsJsonObject().getAsJsonObject("faces")) == null) continue;
            for (Direction side : connectionKeys.keySet()) {
                if (!elementFaces.has(side.m_122433_())) continue;
                elementFaces.getAsJsonObject(side.m_122433_()).addProperty("connections", connectionKeys.get(side));
            }
        }
        return json;
    }

    private static ConnectionPredicate loadPredicate(JsonElement element, String key) {
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            ArrayList<ConnectionPredicate> subPredicates = new ArrayList<ConnectionPredicate>();
            for (JsonElement predicateElements : array) {
                if (!predicateElements.isJsonObject()) {
                    throw new JsonParseException("Predicate '" + key + "' must only contain objects!");
                }
                ConnectionPredicate predicate = FusionPredicateRegistry.deserializeConnectionPredicate(predicateElements.getAsJsonObject());
                subPredicates.add(predicate);
            }
            return DefaultConnectionPredicates.or((ConnectionPredicate[])subPredicates.toArray(ConnectionPredicate[]::new));
        }
        if (element.isJsonObject()) {
            return FusionPredicateRegistry.deserializeConnectionPredicate(element.getAsJsonObject());
        }
        throw new JsonParseException("Predicate '" + key + "' must be an object or an array!");
    }
}

