/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.resources;

import com.supermartijn642.fusion.FusionClient;

public class FusionPackMetadata {
    private final String minimumVersion;
    private final boolean minVersionSatisfied;
    private final String overridesFolder;

    FusionPackMetadata(String minimumVersion, String overridesFolder) {
        this.overridesFolder = overridesFolder;
        this.minimumVersion = minimumVersion.matches("\\d+\\.\\d+\\.\\d+") ? minimumVersion : minimumVersion.substring(0, minimumVersion.length() - minimumVersion.replaceFirst("\\d+\\.\\d+\\.\\d+\\D", "").length() - 1);
        String[] currentVersionComponents = FusionClient.getFusionVersion().split("\\.");
        String[] minVersionComponents = this.minimumVersion.split("\\.");
        boolean satisfied = true;
        for (int i = 0; i < 3 && Integer.parseInt(currentVersionComponents[i]) <= Integer.parseInt(minVersionComponents[i]); ++i) {
            if (Integer.parseInt(currentVersionComponents[i]) >= Integer.parseInt(minVersionComponents[i])) continue;
            satisfied = false;
            break;
        }
        this.minVersionSatisfied = satisfied;
    }

    public String getMinimumVersion() {
        return this.minimumVersion;
    }

    public boolean isMinVersionSatisfied() {
        return this.minVersionSatisfied;
    }

    public boolean hasOverridesFolder() {
        return this.overridesFolder != null;
    }

    public String getOverridesFolder() {
        return this.overridesFolder;
    }
}

