/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.implementations.blockentities.ICrankable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.misc.CrankBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.Nullable;

public class CrankBlock
extends AEBaseEntityBlock<CrankBlockEntity>
implements IOrientableBlock {
    public CrankBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Override
    public InteractionResult onActivated(Level level, BlockPos pos, Player player, InteractionHand hand, @Nullable ItemStack heldItem, BlockHitResult hit) {
        if (player instanceof FakePlayer || player == null) {
            this.dropCrank(level, pos);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        CrankBlockEntity crank = (CrankBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (crank != null) {
            crank.power();
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    private void dropCrank(Level level, BlockPos pos) {
        level.m_46961_(pos, true);
        level.m_7260_(pos, this.m_49966_(), level.m_8055_(pos), 3);
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack is) {
        super.m_6402_(level, pos, state, placer, is);
        CrankBlockEntity be = (CrankBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (be != null) {
            Direction mnt = this.findCrankableDirection(level, pos);
            if (mnt == null) {
                this.dropCrank(level, pos);
                return;
            }
            Direction forward = Direction.UP;
            if (mnt == Direction.UP || mnt == Direction.DOWN) {
                forward = Direction.SOUTH;
            }
            be.setOrientation(forward, mnt.m_122424_());
        } else {
            this.dropCrank(level, pos);
        }
    }

    @Override
    protected boolean isValidOrientation(LevelAccessor levelAccessor, BlockPos pos, Direction forward, Direction up) {
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            BlockEntity be = level.m_7702_(pos);
            return !(be instanceof CrankBlockEntity) || this.isCrankable(level, pos, up.m_122424_());
        }
        return true;
    }

    private Direction findCrankableDirection(Level level, BlockPos pos) {
        for (Direction dir : Direction.values()) {
            if (!this.isCrankable(level, pos, dir)) continue;
            return dir;
        }
        return null;
    }

    private boolean isCrankable(Level level, BlockPos pos, Direction offset) {
        BlockPos o = pos.m_121945_(offset);
        return ICrankable.get(level, o, offset.m_122424_()) != null;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        CrankBlockEntity be = (CrankBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (be != null) {
            if (!this.isCrankable(level, pos, be.getUp().m_122424_())) {
                this.dropCrank(level, pos);
            }
        } else {
            this.dropCrank(level, pos);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader levelReader, BlockPos pos) {
        if (levelReader instanceof Level) {
            Level level = (Level)levelReader;
            return this.findCrankableDirection(level, pos) != null;
        }
        return true;
    }

    private Direction getUp(BlockGetter level, BlockPos pos) {
        CrankBlockEntity crank = (CrankBlockEntity)this.getBlockEntity(level, pos);
        return crank != null ? crank.getUp() : null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction up = this.getUp(level, pos);
        if (up == null) {
            return Shapes.m_83040_();
        }
        double xOff = -0.15 * (double)up.m_122429_();
        double yOff = -0.15 * (double)up.m_122430_();
        double zOff = -0.15 * (double)up.m_122431_();
        return Shapes.m_83064_((AABB)new AABB(xOff + 0.15, yOff + 0.15, zOff + 0.15, xOff + 0.85, yOff + 0.85, zOff + 0.85));
    }
}

