/*
 * Decompiled with CFR 0.152.
 */
package appeng.init;

import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;

public class InitVillager {
    public static final ResourceLocation ID = AppEng.makeId("fluix_researcher");
    public static PoiType POI_TYPE = new PoiType((Set)ImmutableSet.of((Object)AEBlocks.CHARGER.block().m_49966_()), 1, 1);
    public static final ResourceKey<PoiType> POI_KEY = ResourceKey.m_135785_((ResourceKey)Registry.f_122810_, (ResourceLocation)ID);
    public static final VillagerProfession PROFESSION = new VillagerProfession(ID.toString(), e -> e.m_203565_(POI_KEY), e -> e.m_203565_(POI_KEY), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.f_12571_);

    private InitVillager() {
    }

    public static void init() {
        ForgeRegistries.POI_TYPES.register(ID, (Object)POI_TYPE);
        ForgeRegistries.VILLAGER_PROFESSIONS.register(ID, (Object)PROFESSION);
        InitVillager.buyItems(1, AEItems.CERTUS_QUARTZ_CRYSTAL, 3, 4, 10);
        InitVillager.buyItems(1, AEItems.METEORITE_COMPASS, 2, 1, 5);
        InitVillager.sellItems(2, AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED, 3, 10, 15);
        InitVillager.sellItems(2, AEItems.SILICON, 5, 8, 13);
        InitVillager.buyItems(2, AEBlocks.SKY_STONE_BLOCK, 5, 8, 20);
        InitVillager.sellItems(3, AEBlocks.QUARTZ_GLASS, 2, 10, 10);
        InitVillager.buyItems(3, AEItems.FLUIX_CRYSTAL, 5, 4, 14);
        InitVillager.sellItems(4, AEItems.MATTER_BALL, 5, 8, 12);
        InitVillager.buyItems(4, AEItems.CALCULATION_PROCESSOR_PRESS, 10, 1, 20);
        InitVillager.buyItems(4, AEItems.ENGINEERING_PROCESSOR_PRESS, 10, 1, 20);
        InitVillager.buyItems(4, AEItems.LOGIC_PROCESSOR_PRESS, 10, 1, 20);
        InitVillager.buyItems(4, AEItems.SILICON_PRESS, 10, 1, 20);
        InitVillager.buyItems(5, (ItemLike)Items.f_42518_, 8, 5, 12);
    }

    private static void sellItems(int minLevel, ItemLike soldItem, int numberOfItems, int maxUses, int xp) {
        InitVillager.addOffers(minLevel, new VillagerTrades.ItemListing[]{new VillagerTrades.EmeraldForItems(soldItem, numberOfItems, maxUses, xp)});
    }

    private static void buyItems(int minLevel, ItemLike boughtItem, int emeraldCost, int numberOfItems, int xp) {
        InitVillager.addOffers(minLevel, new VillagerTrades.ItemListing[]{new VillagerTrades.ItemsForEmeralds(boughtItem.m_5456_(), emeraldCost, numberOfItems, xp)});
    }

    private static void addOffers(int minLevel, VillagerTrades.ItemListing ... newOffers) {
        Int2ObjectMap offersByLevel = VillagerTrades.f_35627_.computeIfAbsent(PROFESSION, key -> new Int2ObjectOpenHashMap());
        Object[] entries = (VillagerTrades.ItemListing[])offersByLevel.computeIfAbsent(minLevel, key -> new VillagerTrades.ItemListing[0]);
        entries = (VillagerTrades.ItemListing[])ArrayUtils.addAll((Object[])entries, (Object[])newOffers);
        offersByLevel.put(minLevel, (Object)entries);
    }
}

