/*
 * Decompiled with CFR 0.152.
 */
package appeng.libs.micromark;

import appeng.libs.micromark.Construct;
import appeng.libs.micromark.ContextProperty;
import appeng.libs.micromark.ParseContext;
import appeng.libs.micromark.Point;
import appeng.libs.micromark.Token;
import appeng.libs.micromark.Tokenizer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TokenizeContext {
    @Nullable
    public <T> T get(ContextProperty<T> var1);

    public <T> void set(ContextProperty<T> var1, T var2);

    public void remove(ContextProperty<?> var1);

    @Nullable
    public Tokenizer.Event getLastEvent();

    public List<Object> sliceStream(Token var1);

    public List<Object> sliceStream(Point var1, Point var2);

    default public List<Object> sliceChunks(List<Object> chunks, Point start, Point end) {
        int startIndex = start._index();
        int startBufferIndex = start._bufferIndex();
        int endIndex = end._index();
        int endBufferIndex = end._bufferIndex();
        ArrayList<Object> view = new ArrayList<Object>();
        if (startIndex == endIndex) {
            if (endBufferIndex < 0) {
                throw new IllegalArgumentException("expected non-negative end buffer index");
            }
            if (startBufferIndex < 0) {
                throw new IllegalArgumentException("expected non-negative start buffer index");
            }
            view.add(((String)chunks.get(startIndex)).substring(startBufferIndex, endBufferIndex));
        } else {
            view.addAll(chunks.subList(startIndex, endIndex));
            if (startBufferIndex > -1) {
                view.set(0, ((String)view.get(0)).substring(startBufferIndex));
            }
            if (endBufferIndex > 0) {
                view.add(((String)chunks.get(endIndex)).substring(0, endBufferIndex));
            }
        }
        return view;
    }

    public List<Tokenizer.Event> write(List<Object> var1);

    public String sliceSerialize(Point var1, Point var2);

    public String sliceSerialize(Token var1);

    public String sliceSerialize(Token var1, boolean var2);

    public void defineSkip(@NotNull Point var1);

    public Point now();

    public boolean isOnLazyLine();

    public boolean isInterrupt();

    public void setInterrupt(boolean var1);

    public int getPrevious();

    public void setPrevious(int var1);

    public Construct getCurrentConstruct();

    public void setCurrentConstruct(Construct var1);

    public Tokenizer.ContainerState getContainerState();

    public void setContainerState(Tokenizer.ContainerState var1);

    public List<Tokenizer.Event> getEvents();

    public void setEvents(List<Tokenizer.Event> var1);

    public Tokenizer getTokenizer();

    public boolean isGfmTableDynamicInterruptHack();

    public void setGfmTableDynamicInterruptHack(boolean var1);

    public boolean isGfmTasklistFirstContentOfListItem();

    public void setGfmTasklistFirstContentOfListItem(boolean var1);

    default public ParseContext getParser() {
        return this.getTokenizer().getParser();
    }
}

