/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.pathfinding;

import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridMultiblock;
import appeng.api.networking.IGridNode;
import appeng.blockentity.networking.ControllerBlockEntity;
import appeng.me.GridConnection;
import appeng.me.GridNode;
import appeng.me.pathfinding.IPathItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PathingCalculation {
    private final Set<IPathItem> multiblocksWithChannel = new HashSet<IPathItem>();
    private List<IPathItem> queue = new ArrayList<IPathItem>();
    private final Set<IPathItem> visited = new HashSet<IPathItem>();
    private int channelsInUse = 0;
    private int channelsByBlocks = 0;

    public PathingCalculation(IGrid grid) {
        for (IGridNode node : grid.getMachineNodes(ControllerBlockEntity.class)) {
            this.visited.add((IPathItem)((Object)node));
            for (IGridConnection gcc : node.getConnections()) {
                GridConnection gc = (GridConnection)gcc;
                if (gc.getOtherSide(node).getOwner() instanceof ControllerBlockEntity) continue;
                this.visited.add(gc);
                this.queue.add(gc);
                gc.setControllerRoute((GridNode)node);
            }
        }
    }

    public void step() {
        List<IPathItem> oldOpen = this.queue;
        this.queue = new ArrayList<IPathItem>();
        for (IPathItem i : oldOpen) {
            for (IPathItem pi : i.getPossibleOptions()) {
                if (this.visited.contains(pi)) continue;
                pi.setControllerRoute(i);
                if (pi.hasFlag(GridFlags.REQUIRE_CHANNEL)) {
                    if (this.multiblocksWithChannel.contains(pi)) {
                        pi.incrementChannelCount(1);
                        this.multiblocksWithChannel.remove(pi);
                    } else {
                        IGridMultiblock multiblock;
                        boolean worked = this.tryUseChannel(pi);
                        if (worked && pi.hasFlag(GridFlags.MULTIBLOCK) && (multiblock = ((IGridNode)((Object)pi)).getService(IGridMultiblock.class)) != null) {
                            Iterator<IGridNode> oni = multiblock.getMultiblockNodes();
                            while (oni.hasNext()) {
                                IGridNode otherNodes = oni.next();
                                if (otherNodes == pi) continue;
                                this.multiblocksWithChannel.add((IPathItem)((Object)otherNodes));
                            }
                        }
                    }
                }
                this.visited.add(pi);
                this.queue.add(pi);
            }
        }
    }

    private boolean tryUseChannel(IPathItem start) {
        IPathItem pi;
        boolean isCompressed = start.hasFlag(GridFlags.COMPRESSED_CHANNEL);
        for (pi = start; pi != null; pi = pi.getControllerRoute()) {
            if (!pi.canSupportMoreChannels()) {
                return false;
            }
            if (!isCompressed || !pi.hasFlag(GridFlags.CANNOT_CARRY_COMPRESSED)) continue;
            return false;
        }
        for (pi = start; pi != null; pi = pi.getControllerRoute()) {
            ++this.channelsByBlocks;
            pi.incrementChannelCount(1);
        }
        ++this.channelsInUse;
        return true;
    }

    public boolean isFinished() {
        return this.queue.isEmpty();
    }

    public int getChannelsInUse() {
        return this.channelsInUse;
    }

    public int getChannelsByBlocks() {
        return this.channelsByBlocks;
    }
}

