/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.server.ISubCommand;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ChunkLogger
implements ISubCommand {
    private boolean enabled = false;

    private void displayStack() {
        if (AEConfig.instance().isChunkLoggerTraceEnabled()) {
            boolean output = false;
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                if (output) {
                    AELog.info("\t\t" + e.getClassName() + "." + e.getMethodName() + " (" + e.getLineNumber() + ")", new Object[0]);
                    continue;
                }
                output = e.getClassName().contains("EventBus") && e.getMethodName().contains("post");
            }
        }
    }

    @SubscribeEvent
    public void onChunkLoadEvent(ChunkEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            ChunkAccess chunk = event.getChunk();
            ChunkPos chunkPos = chunk.m_7697_();
            String center = ChunkLogger.getCenter(chunk);
            AELog.info("Loaded chunk " + chunkPos.f_45578_ + "," + chunkPos.f_45579_ + " [center: " + center + "] in " + level.m_46472_().m_135782_(), new Object[0]);
            this.displayStack();
        }
    }

    @SubscribeEvent
    public void onChunkUnloadEvent(ChunkEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            ChunkAccess chunk = event.getChunk();
            ChunkPos chunkPos = chunk.m_7697_();
            String center = ChunkLogger.getCenter(chunk);
            AELog.info("Unloaded chunk " + chunkPos.f_45578_ + "," + chunkPos.f_45579_ + " [center: " + center + "] in " + level.m_46472_().m_135782_(), new Object[0]);
            this.displayStack();
        }
    }

    private static String getCenter(ChunkAccess chunk) {
        ChunkPos chunkPos = chunk.m_7697_();
        int x = chunkPos.m_151390_();
        int z = chunkPos.m_151393_();
        int y = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, x, z) + 1;
        return x + " " + y + " " + z;
    }

    @Override
    public void call(MinecraftServer srv, CommandContext<CommandSourceStack> data, CommandSourceStack sender) {
        boolean bl = this.enabled = !this.enabled;
        if (this.enabled) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            sender.m_81354_((Component)Component.m_237115_((String)"commands.ae2.ChunkLoggerOn"), true);
        } else {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            sender.m_81354_((Component)Component.m_237115_((String)"commands.ae2.ChunkLoggerOff"), true);
        }
    }
}

