/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat;

import com.copycatsplus.copycats.foundation.copycat.CopycatMaterialStore;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.utility.BlockEntityUtils;
import com.copycatsplus.copycats.utility.ItemUtils;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.ITransformableBlockEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.redstone.RoseQuartzLampBlock;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockEntityItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.blockEntity.IMergeableBE;
import com.simibubi.create.foundation.utility.IPartialSafeNBT;
import com.simibubi.create.foundation.utility.Iterate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.ApiStatus;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface ICopycatBlockEntity
extends ISpecialBlockEntityItemRequirement,
ITransformableBlockEntity,
IPartialSafeNBT,
IMergeableBE {
    public void notifyUpdate();

    public Level m_58904_();

    public BlockPos m_58899_();

    public BlockState m_58900_();

    public void m_155250_(BlockState var1);

    public void m_142339_(Level var1);

    public BlockState getMaterial();

    public ItemStack getConsumedItem();

    public boolean isCTEnabled();

    @ApiStatus.OverrideOnly
    public void setMaterialInternal(BlockState var1);

    @ApiStatus.OverrideOnly
    public void setConsumedItemInternal(ItemStack var1);

    @ApiStatus.OverrideOnly
    public void setCTEnabledInternal(boolean var1);

    default public void init() {
        this.setMaterialInternal(AllBlocks.COPYCAT_BASE.getDefaultState());
        this.setConsumedItemInternal(ItemStack.f_41583_);
        this.setCTEnabledInternal(true);
    }

    default public ICopycatBlock getBlock() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof ICopycatBlock) {
            ICopycatBlock copycatBlock = (ICopycatBlock)block;
            return copycatBlock;
        }
        return new ICopycatBlock(){};
    }

    default public boolean hasCustomMaterial() {
        return !AllBlocks.COPYCAT_BASE.has(this.getMaterial());
    }

    default public void setMaterial(BlockState blockState) {
        BlockState wrapperState = this.m_58900_();
        if (!this.getMaterial().m_60713_(blockState.m_60734_())) {
            for (Direction side : Iterate.directions) {
                ICopycatBlockEntity cbe;
                BlockState otherMaterial;
                BlockEntity blockEntity;
                BlockPos neighbour = this.m_58899_().m_121945_(side);
                BlockState neighbourState = this.m_58904_().m_8055_(neighbour);
                if (neighbourState != wrapperState || !((blockEntity = this.m_58904_().m_7702_(neighbour)) instanceof ICopycatBlockEntity) || !(otherMaterial = (cbe = (ICopycatBlockEntity)blockEntity).getMaterial()).m_60713_(blockState.m_60734_())) continue;
                blockState = otherMaterial;
                break;
            }
        }
        this.setMaterialInternal(blockState);
        BlockEntityUtils.redraw((BlockEntity)this);
    }

    default public boolean cycleMaterial() {
        BlockState material = this.getMaterial();
        if (material.m_61138_((Property)TrapDoorBlock.f_57515_) && material.m_61145_((Property)TrapDoorBlock.f_57514_).orElse(false).booleanValue()) {
            this.setMaterial((BlockState)material.m_61122_((Property)TrapDoorBlock.f_57515_));
        } else if (material.m_61138_((Property)BlockStateProperties.f_61372_)) {
            this.setMaterial((BlockState)material.m_61122_((Property)BlockStateProperties.f_61372_));
        } else if (material.m_61138_((Property)BlockStateProperties.f_61374_)) {
            this.setMaterial((BlockState)material.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)material.m_61143_((Property)BlockStateProperties.f_61374_)).m_122427_()));
        } else if (material.m_61138_((Property)BlockStateProperties.f_61365_)) {
            this.setMaterial((BlockState)material.m_61122_((Property)BlockStateProperties.f_61365_));
        } else if (material.m_61138_((Property)BlockStateProperties.f_61364_)) {
            this.setMaterial((BlockState)material.m_61122_((Property)BlockStateProperties.f_61364_));
        } else if (material.m_61138_((Property)BlockStateProperties.f_61443_)) {
            this.setMaterial((BlockState)material.m_61122_((Property)BlockStateProperties.f_61443_));
        } else if (material.m_61138_((Property)RoseQuartzLampBlock.POWERING)) {
            this.setMaterial((BlockState)material.m_61122_((Property)RoseQuartzLampBlock.POWERING));
        } else {
            return false;
        }
        return true;
    }

    default public void setConsumedItem(ItemStack stack) {
        this.setConsumedItemInternal(ItemUtils.copyStackWithSize(stack, 1));
        this.notifyUpdate();
    }

    default public void setCTEnabled(boolean value) {
        this.setCTEnabledInternal(value);
        this.notifyUpdate();
    }

    default public void invalidate() {
        CopycatMaterialStore.setMaterial((BlockGetter)this.m_58904_(), this.m_58899_(), Blocks.f_50016_.m_49966_());
    }

    default public ItemRequirement getRequiredItems(BlockState state) {
        if (this.getConsumedItem().m_41619_()) {
            return ItemRequirement.NONE;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, this.getConsumedItem());
    }

    default public void accept(BlockEntity other) {
        if (other instanceof ICopycatBlockEntity) {
            ICopycatBlockEntity be = (ICopycatBlockEntity)other;
            this.setMaterial(be.getMaterial());
            this.setConsumedItem(be.getConsumedItem());
            this.setCTEnabled(be.isCTEnabled());
            BlockEntityUtils.redraw((BlockEntity)this);
        }
    }

    default public void transform(StructureTransform transform) {
        this.setMaterialInternal(transform.apply(this.getMaterial()));
        this.notifyUpdate();
    }

    public static void read(ICopycatBlockEntity self, CompoundTag tag, boolean clientPacket) {
        if (tag.m_128441_("EnableCT")) {
            self.setCTEnabled(tag.m_128471_("EnableCT"));
        } else {
            self.setCTEnabled(true);
        }
        self.setConsumedItem(ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item")));
        BlockState prevMaterial = self.getMaterial();
        if (!tag.m_128441_("Material")) {
            self.setConsumedItem(ItemStack.f_41583_);
            return;
        }
        self.setMaterialInternal(NbtUtils.m_129241_((CompoundTag)tag.m_128469_("Material")));
        if (self.getMaterial() != null && !clientPacket) {
            BlockState blockState = self.m_58900_();
            if (blockState == null) {
                return;
            }
            Block block = blockState.m_60734_();
            if (!(block instanceof ICopycatBlock)) {
                return;
            }
            ICopycatBlock cb = (ICopycatBlock)block;
            BlockState acceptedBlockState = cb.getAcceptedBlockState(self.m_58904_(), self.m_58899_(), self.getConsumedItem(), null);
            if (acceptedBlockState != null && self.getMaterial().m_60713_(acceptedBlockState.m_60734_())) {
                return;
            }
            self.setConsumedItem(ItemStack.f_41583_);
            self.setMaterialInternal(AllBlocks.COPYCAT_BASE.getDefaultState());
        }
        if (prevMaterial != self.getMaterial()) {
            BlockEntityUtils.redraw((BlockEntity)self);
        }
    }

    public static void writeSafe(ICopycatBlockEntity self, CompoundTag tag) {
        ItemStack stackWithoutNBT = self.getConsumedItem().m_41777_();
        stackWithoutNBT.m_41751_(null);
        BlockEntityUtils.saveMetadata((BlockEntity)self, tag);
        ICopycatBlockEntity.write(tag, stackWithoutNBT, self.getMaterial(), self.isCTEnabled());
    }

    public static void write(ICopycatBlockEntity self, CompoundTag tag, boolean clientPacket) {
        ICopycatBlockEntity.write(tag, self.getConsumedItem(), self.getMaterial(), self.isCTEnabled());
    }

    @ApiStatus.Internal
    public static void write(CompoundTag tag, ItemStack stack, BlockState material, boolean enableCT) {
        tag.m_128365_("Item", ItemUtils.serializeNBT(stack));
        tag.m_128365_("Material", (Tag)NbtUtils.m_129202_((BlockState)material));
        tag.m_128379_("EnableCT", enableCT);
    }
}

