/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat.model.kinetic;

import com.copycatsplus.copycats.foundation.copycat.ICopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.model.kinetic.ICopycatPartialModel;
import com.copycatsplus.copycats.foundation.copycat.model.kinetic.KineticCopycatRenderData;
import com.copycatsplus.copycats.foundation.copycat.model.kinetic.KineticCopycatRenderer;
import com.copycatsplus.copycats.utility.ChatUtils;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.RenderLayer;
import com.jozufozu.flywheel.config.BackendType;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;

public interface IKineticCopycatBlockInstance {
    @Nullable
    public KineticCopycatRenderData getRenderData();

    public MaterialManager getMaterialManager();

    public void setRenderData(KineticCopycatRenderData var1);

    public ICopycatBlockEntity getBlockEntity();

    default public Material<RotatingData> getRotatingMaterial() {
        RenderType type = RenderType.m_110466_();
        RenderLayer layer = RenderLayer.getLayer((RenderType)type);
        if (layer == null) {
            layer = RenderLayer.TRANSPARENT;
        }
        if (Backend.getBackendType() == BackendType.BATCHING && type == RenderType.m_110466_()) {
            type = RenderType.m_110457_();
            ChatUtils.sendWarningOnce("flywheel_batching_translucent", "Translucent textures may appear slightly broken when using the Flywheel batching backend. Please switch to the instancing backend instead.");
        }
        return this.getMaterialManager().state(layer, type).material(AllMaterialSpecs.ROTATING);
    }

    default public Instancer<RotatingData> getModel(ICopycatPartialModel partialModel) {
        KineticCopycatRenderData renderData = KineticCopycatRenderData.of(partialModel, this.getBlockEntity());
        this.setRenderData(renderData);
        return this.getRotatingMaterial().model((Object)renderData, () -> KineticCopycatRenderer.getInstanceModel(partialModel, this.getBlockEntity(), renderData));
    }

    default public boolean shouldReset() {
        if (this.getRenderData() == null) {
            return true;
        }
        if (!this.getRenderData().material().equals(this.getBlockEntity().getMaterial())) {
            return true;
        }
        return !this.getRenderData().state().equalsState(this.getBlockEntity().m_58900_());
    }
}

