/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.network.forge;

import com.copycatsplus.copycats.Copycats;
import com.copycatsplus.copycats.network.PacketSystem;
import com.copycatsplus.copycats.network.PlayerSelection;
import com.copycatsplus.copycats.network.forge.PlayerSelectionImpl;
import com.simibubi.create.AllPackets;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.ApiStatus;

public class PacketSystemImpl
extends PacketSystem {
    public static final Map<ResourceLocation, PacketSystem> HANDLERS = new HashMap<ResourceLocation, PacketSystem>();

    protected PacketSystemImpl(String id, int version, List<Function<FriendlyByteBuf, PacketSystem.S2CPacket>> s2cPackets, Object2IntMap<Class<? extends PacketSystem.S2CPacket>> s2cTypes, List<Function<FriendlyByteBuf, PacketSystem.C2SPacket>> c2sPackets, Object2IntMap<Class<? extends PacketSystem.C2SPacket>> c2sTypes) {
        super(id, version, s2cPackets, s2cTypes, c2sPackets, c2sTypes);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerS2CListener() {
        HANDLERS.put(this.s2cPacket, this);
    }

    @Override
    public void registerC2SListener() {
        HANDLERS.put(this.c2sPacket, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void send(SimplePacketBase packet) {
        AllPackets.getChannel().sendToServer((Object)packet);
    }

    @Override
    public void sendTo(ServerPlayer player, SimplePacketBase packet) {
        AllPackets.getChannel().send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    @Override
    public void sendTo(PlayerSelection selection, SimplePacketBase packet) {
        AllPackets.getChannel().send(((PlayerSelectionImpl)selection).target, (Object)packet);
    }

    @Override
    protected void doSendC2S(FriendlyByteBuf buf) {
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        if (connection != null) {
            connection.m_104955_((Packet)new ServerboundCustomPayloadPacket(this.c2sPacket, buf));
        } else {
            Copycats.LOGGER.error("Cannot send a C2S packet before the client connection exists, skipping!");
        }
    }

    @ApiStatus.Internal
    public static PacketSystem create(String id, int version, List<Function<FriendlyByteBuf, PacketSystem.S2CPacket>> s2cPackets, Object2IntMap<Class<? extends PacketSystem.S2CPacket>> s2cTypes, List<Function<FriendlyByteBuf, PacketSystem.C2SPacket>> c2sPackets, Object2IntMap<Class<? extends PacketSystem.C2SPacket>> c2sTypes) {
        return new PacketSystemImpl(id, version, s2cPackets, s2cTypes, c2sPackets, c2sTypes);
    }
}

