/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machines.logic.planner.encoder;

import ic2.core.block.machines.logic.planner.encoder.ReactorSetup;
import ic2.core.block.machines.logic.planner.newLogic.ReactorPrediction;
import ic2.core.block.machines.tiles.mv.ReactorPlannerTileEntity;
import net.minecraft.nbt.CompoundTag;

public interface IEncoder {
    public CompoundTag createDecodedData(String var1);

    public void processData(CompoundTag var1, ReactorPlannerTileEntity var2);

    public String createEncodedData(ReactorPlannerTileEntity var1);

    public ReactorSetup createSetup(String var1, boolean var2);

    public String getName();

    public boolean hasBitLimit();

    public int getBitLimit();

    default public ReactorSetup finishSetup(ReactorPrediction prediction, boolean isSteam, int chambers, int startingHeat) {
        ReactorSetup setup = new ReactorSetup();
        setup.breeder = prediction.breeder;
        setup.isStable = prediction.heatPerTick <= prediction.coolingPerTick;
        setup.chambersRequired = chambers;
        setup.efficiency = prediction.efficiency;
        setup.totalEfficiency = prediction.totalEfficiency;
        setup.isSteam = isSteam;
        setup.startingHeat = startingHeat;
        if (isSteam) {
            setup.duration = (int)Math.max(1.0f, (float)prediction.totalSteamProduced / Math.max(1.0f, prediction.steamPerTick));
            setup.output = prediction.steamPerTick;
            setup.totalOutput = prediction.totalSteamProduced;
            setup.input = (float)prediction.totalWaterConsumed / (float)setup.duration;
            setup.totalInput = prediction.totalWaterConsumed;
        } else {
            setup.efficiency = prediction.efficiency;
            setup.totalEfficiency = prediction.totalEfficiency;
            setup.duration = (int)Math.max(1.0f, (float)prediction.totalEnergyProduced / Math.max(1.0f, prediction.energyPerTick));
            setup.output = prediction.energyPerTick;
            setup.totalOutput = prediction.totalEnergyProduced;
        }
        return setup;
    }
}

