/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.rendering.world.impl;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import ic2.core.block.base.misc.ITubeBlock;
import ic2.core.block.rendering.world.IWorldOverlay;
import ic2.core.platform.registries.IC2Items;
import ic2.core.platform.rendering.RenderUtils;
import ic2.core.platform.rendering.misc.GLUtils;
import ic2.core.platform.rendering.misc.IC2RenderTypes;
import ic2.core.platform.rendering.misc.VertexCache;
import ic2.core.utils.helpers.WorldRegion;
import ic2.core.utils.math.ColorUtils;
import ic2.core.utils.math.geometry.Box;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.LongStream;
import net.minecraft.Util;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;

public class PipeOverlay
implements IWorldOverlay {
    static final int MINING_PIPE = ColorUtils.GREEN;
    private static final Executor RENDER_POOL = (Executor)Util.m_137469_((Object)new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 5L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()), T -> T.allowCoreThreadTimeOut(true));
    ExecutorCompletionService<CacheEntry> service = new ExecutorCompletionService(RENDER_POOL);
    Long2ObjectLinkedOpenHashMap<CacheEntry> cacheMap = new Long2ObjectLinkedOpenHashMap();
    VertexCache.BufferedVertexCache cache = new VertexCache.BufferedVertexCache(10000, VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
    boolean wasRendering = false;
    long lastRefresh = 0L;
    int counter = 0;
    int vertecies = 0;

    @Override
    public void cleanup() {
        this.vertecies = -1;
        this.lastRefresh = 0L;
        this.cacheMap.clear();
        this.cache.clear();
        this.cache.delete();
    }

    @Override
    public void update(Level world, Player player) {
        if (this.lastRefresh <= world.m_46467_()) {
            this.lastRefresh = world.m_46467_() + 20L;
            ++this.counter;
            if (this.counter > 30) {
                this.counter = 0;
                ObjectIterator iter = this.cacheMap.values().iterator();
                while (iter.hasNext()) {
                    CacheEntry entry = (CacheEntry)iter.next();
                    if (!(Math.sqrt(entry.pos().m_123331_((Vec3i)player.m_20183_())) > 200.0)) continue;
                    iter.remove();
                }
            }
            Box box = Box.withRange(player.m_20183_(), 50);
            WorldRegion region = new WorldRegion(world, box, true);
            LongStream.of(box.asLongArray()).parallel().forEach(T -> {
                BlockPos pos = BlockPos.m_122022_((long)T);
                BlockState state = region.m_8055_(pos);
                Block patt3729$temp = state.m_60734_();
                if (patt3729$temp instanceof ITubeBlock) {
                    ITubeBlock block = (ITubeBlock)patt3729$temp;
                    CacheEntry entry = (CacheEntry)this.cacheMap.get(pos.m_121878_());
                    Object[] shapes = block.getRealShapes(state, (BlockGetter)region, pos);
                    if (entry != null && Arrays.deepEquals(entry.shapeIn(), shapes)) {
                        return;
                    }
                    int color = block.getHighlightColor(state);
                    DyeColor normalColor = block.getBlockColor(state);
                    this.service.submit(new RenderEntry(state, (VoxelShape[])shapes, normalColor, pos, color));
                } else if (this.cacheMap.containsKey(T)) {
                    this.service.submit(new RenderEntry(null, null, null, pos, -1));
                }
            });
            boolean changed = false;
            Future<CacheEntry> temp = null;
            while ((temp = this.service.poll()) != null) {
                try {
                    CacheEntry entry = temp.get();
                    if (entry.cache() == null) {
                        CacheEntry existing = (CacheEntry)this.cacheMap.remove(entry.pos().m_121878_());
                        if (existing != null && existing.cache() != null) {
                            this.vertecies -= existing.cache().vertexCount();
                        }
                    } else {
                        this.cacheMap.put(entry.pos().m_121878_(), (Object)entry);
                        this.vertecies += entry.cache().vertexCount();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                changed = true;
            }
            if (changed || this.vertecies != this.cache.vertexCount()) {
                this.cache.clear();
                for (CacheEntry entry : this.cacheMap.values()) {
                    this.cache.copyFrom(entry.cache());
                }
                this.cache.finish();
                this.vertecies = this.cache.vertexCount();
            }
        }
    }

    @Override
    public void render(Level world, Player player, RenderLevelStageEvent event, Frustum helper) {
        if (this.cacheMap.isEmpty() || player.m_21205_().m_41720_() != IC2Items.TUBE_LENSE.m_5456_() && player.m_21206_().m_41720_() != IC2Items.TUBE_LENSE.m_5456_()) {
            return;
        }
        GLUtils.enableHighlight(true);
        RenderSystem.m_157427_(GameRenderer::m_172757_);
        RenderUtils.draw(event.getPoseStack(), (B, M) -> {
            Matrix4f model = M.m_85850_().m_85861_().m_27658_();
            PoseStack pose = RenderSystem.m_157191_();
            pose.m_85836_();
            pose.m_166854_(model);
            RenderSystem.m_157182_();
            IC2RenderTypes.LINES.m_110185_();
            this.cache.draw();
            IC2RenderTypes.LINES.m_110188_();
            pose.m_85849_();
            RenderSystem.m_157182_();
        });
        GLUtils.disableHighlight(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawShape(VertexConsumer bufferIn, VoxelShape[] shapeIn, DyeColor color, int xIn, int yIn, int zIn, float red, float green, float blue, float alpha) {
        shapeIn[0].m_83224_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            Vector3f normal = new Vector3f((float)(maxX - minX), (float)(maxY - minY), (float)(maxZ - minZ));
            normal.m_122278_();
            bufferIn.m_5483_((double)((float)(minX + (double)xIn)), (double)((float)(minY + (double)yIn)), (double)((float)(minZ + (double)zIn))).m_85950_(red, green, blue, alpha).m_5601_(normal.m_122239_(), normal.m_122260_(), normal.m_122269_()).m_5752_();
            bufferIn.m_5483_((double)((float)(maxX + (double)xIn)), (double)((float)(maxY + (double)yIn)), (double)((float)(maxZ + (double)zIn))).m_85950_(red, green, blue, alpha).m_5601_(normal.m_122239_(), normal.m_122260_(), normal.m_122269_()).m_5752_();
        });
        shapeIn[1].m_83224_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            Vector3f normal = new Vector3f((float)(maxX - minX), (float)(maxY - minY), (float)(maxZ - minZ));
            normal.m_122278_();
            bufferIn.m_5483_((double)((float)(minX + (double)xIn)), (double)((float)(minY + (double)yIn)), (double)((float)(minZ + (double)zIn))).m_85950_(ColorUtils.getFloatR(MINING_PIPE), ColorUtils.getFloatG(MINING_PIPE), ColorUtils.getFloatB(MINING_PIPE), ColorUtils.getFloatA(MINING_PIPE)).m_5601_(normal.m_122239_(), normal.m_122260_(), normal.m_122269_()).m_5752_();
            bufferIn.m_5483_((double)((float)(maxX + (double)xIn)), (double)((float)(maxY + (double)yIn)), (double)((float)(maxZ + (double)zIn))).m_85950_(ColorUtils.getFloatR(MINING_PIPE), ColorUtils.getFloatG(MINING_PIPE), ColorUtils.getFloatB(MINING_PIPE), ColorUtils.getFloatA(MINING_PIPE)).m_5601_(normal.m_122239_(), normal.m_122260_(), normal.m_122269_()).m_5752_();
        });
        if (color != null) {
            int text = color.m_41071_() | 0xFF000000;
            Block.m_49796_((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0).m_83224_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                Vector3f normal = new Vector3f((float)(maxX - minX), (float)(maxY - minY), (float)(maxZ - minZ));
                normal.m_122278_();
                bufferIn.m_5483_((double)((float)(minX + (double)xIn)), (double)((float)(minY + (double)yIn)), (double)((float)(minZ + (double)zIn))).m_85950_(ColorUtils.getFloatR(text), ColorUtils.getFloatG(text), ColorUtils.getFloatB(text), ColorUtils.getFloatA(text)).m_5601_(normal.m_122239_(), normal.m_122260_(), normal.m_122269_()).m_5752_();
                bufferIn.m_5483_((double)((float)(maxX + (double)xIn)), (double)((float)(maxY + (double)yIn)), (double)((float)(maxZ + (double)zIn))).m_85950_(ColorUtils.getFloatR(text), ColorUtils.getFloatG(text), ColorUtils.getFloatB(text), ColorUtils.getFloatA(text)).m_5601_(normal.m_122239_(), normal.m_122260_(), normal.m_122269_()).m_5752_();
            });
        }
    }

    public record CacheEntry(BlockPos pos, VoxelShape[] shapeIn, VertexCache cache) {
    }

    public record RenderEntry(BlockState state, VoxelShape[] shapeIn, DyeColor dye, BlockPos pos, int color) implements Callable<CacheEntry>
    {
        @Override
        public CacheEntry call() throws Exception {
            if (this.state == null) {
                return new CacheEntry(this.pos, null, null);
            }
            VertexCache cache = new VertexCache(100, VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
            PipeOverlay.drawShape((VertexConsumer)cache, this.shapeIn, this.dye, this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_(), ColorUtils.getFloatR(this.color), ColorUtils.getFloatG(this.color), ColorUtils.getFloatB(this.color), ColorUtils.getFloatA(this.color));
            return new CacheEntry(this.pos, this.shapeIn, cache);
        }
    }
}

