/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.api.reactor.IReactorPlannerComponent;
import ic2.api.reactor.planner.SimulatedStack;
import ic2.core.item.base.PropertiesBuilder;
import ic2.core.item.reactor.base.ExchangerProperty;
import ic2.core.item.reactor.base.ItemStackCoord;
import ic2.core.item.reactor.base.ReactorHeatStorageBase;
import ic2.core.item.reactor.planner.SimulatedHeatBalancer;
import ic2.core.utils.collection.CollectionUtils;
import ic2.core.utils.math.geometry.Vec2i;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ReactorHeatBalancerItem
extends ReactorHeatStorageBase {
    ExchangerProperty prop;

    public ReactorHeatBalancerItem(String name, ExchangerProperty prop) {
        super(name, prop.getTextureFolder(), prop.getTextureName(), new PropertiesBuilder().maxDamage(prop.getHeatStorage()));
        this.prop = prop;
    }

    public ReactorHeatBalancerItem(String name, PropertiesBuilder properties, ExchangerProperty prop) {
        super(name, prop.getTextureFolder(), prop.getTextureName(), (properties == null ? new PropertiesBuilder() : properties).maxDamage(prop.getHeatStorage()));
        this.prop = prop;
    }

    protected int processStep(ItemStack stack, IReactor reactor, int x, int y, int myHeat, boolean absorb, List<ItemStackCoord.ItemStackDirCoord> process) {
        int side = this.prop.getSelf();
        int react = this.prop.getReactor();
        double med = (double)this.getStoredHeat(stack, reactor, x, y) / (double)this.getMaxStoredHeat(stack, reactor, x, y);
        int c = 1;
        boolean didReactor = false;
        if (react > 0) {
            double avg = (double)reactor.getHeat() / (double)reactor.getMaxHeat();
            if (absorb ? avg >= 0.75 : avg <= 0.25) {
                ++c;
                med += avg;
                didReactor = true;
            }
        }
        if (side > 0) {
            int n = process.size();
            for (int i = 0; i < n; ++i) {
                med += process.get(i).average();
            }
        }
        med /= (double)(c + process.size());
        if (side > 0) {
            for (ItemStackCoord itemStackCoord : process) {
                IReactorComponent heatable = (IReactorComponent)itemStackCoord.stack.m_41720_();
                int add = Mth.m_14045_((int)itemStackCoord.getTransferRate(heatable, reactor, med), (int)(-side), (int)side);
                myHeat -= add;
                myHeat += itemStackCoord.storeHeat(heatable, reactor, add);
            }
        }
        if (react > 0 && didReactor) {
            int add = Mth.m_14045_((int)((int)(med * (double)reactor.getMaxHeat() - (double)reactor.getHeat())), (int)(-react), (int)react);
            myHeat -= add;
            reactor.setHeat(reactor.getHeat() + add);
        }
        return myHeat;
    }

    @Override
    public void processChamber(ItemStack stack, IReactor reactor, int x, int y, boolean heatCalculation, boolean damageTick) {
        ObjectArrayList insert = new ObjectArrayList();
        ObjectArrayList extract = new ObjectArrayList();
        List<Vec2i> offsets = this.prop.getOffsets();
        int m = offsets.size();
        for (int i = 0; i < m; ++i) {
            Vec2i pos = offsets.get(i);
            this.fetchInfo(reactor, x + pos.getX(), y + pos.getY(), (List<ItemStackCoord.ItemStackDirCoord>)insert, (List<ItemStackCoord.ItemStackDirCoord>)extract);
        }
        int myHeat = 0;
        myHeat = this.processStep(stack, reactor, x, y, myHeat, false, (List<ItemStackCoord.ItemStackDirCoord>)insert);
        myHeat = this.processStep(stack, reactor, x, y, myHeat, true, (List<ItemStackCoord.ItemStackDirCoord>)extract);
        this.storeHeat(stack, reactor, x, y, myHeat);
    }

    private void fetchInfo(IReactor reactor, int x, int y, List<ItemStackCoord.ItemStackDirCoord> insert, List<ItemStackCoord.ItemStackDirCoord> extract) {
        IReactorComponent comp;
        ItemStack thing = reactor.getStackInReactor(x, y);
        Item item = thing.m_41720_();
        if (item instanceof IReactorComponent && (comp = (IReactorComponent)item).canStoreHeat(thing, reactor, x, y)) {
            double max = comp.getMaxStoredHeat(thing, reactor, x, y);
            if (max <= 0.0) {
                return;
            }
            double average = (double)comp.getStoredHeat(thing, reactor, x, y) / max;
            if (average <= 0.25) {
                insert.add(new ItemStackCoord.ItemStackDirCoord(thing, x, y, average));
            } else if (average >= 0.75) {
                extract.add(new ItemStackCoord.ItemStackDirCoord(thing, x, y, average));
            }
        }
    }

    @Override
    public void addAffectedSlots(int x, int y, BiPredicate<Integer, Integer> slots) {
        slots.test(x, y);
        if (this.prop.getSelf() > 0) {
            slots.test(x + 1, y);
            slots.test(x - 1, y);
            slots.test(x, y + 1);
            slots.test(x, y - 1);
        }
    }

    @Override
    public SimulatedStack createSimulationComponent(ItemStack self) {
        return new SimulatedHeatBalancer(this.prop);
    }

    @Override
    public short getComponentID(ItemStack stack) {
        return this.prop.getComponentID();
    }

    @Override
    public IReactorPlannerComponent.ReactorType getSupportedReactor(ItemStack stack) {
        return IReactorPlannerComponent.ReactorType.UNIVERSAL;
    }

    @Override
    public IReactorPlannerComponent.ComponentType getType(ItemStack stack) {
        return IReactorPlannerComponent.ComponentType.HEAT_EXCHANGER;
    }

    @Override
    public List<IReactorPlannerComponent.ReactorStat> getStats(ItemStack stack) {
        ObjectList list = CollectionUtils.createList();
        list.add((IReactorPlannerComponent.ReactorStat)IReactorPlannerComponent.ReactorStat.REACTOR_BALANCING);
        list.add((IReactorPlannerComponent.ReactorStat)IReactorPlannerComponent.ReactorStat.PART_BALANCING);
        return list;
    }

    @Override
    public NumericTag getReactorStat(IReactorPlannerComponent.ReactorStat stat, ItemStack stack) {
        if (stat == IReactorPlannerComponent.ReactorStat.REACTOR_BALANCING) {
            return IntTag.m_128679_((int)this.prop.getReactor());
        }
        if (stat == IReactorPlannerComponent.ReactorStat.PART_BALANCING) {
            return IntTag.m_128679_((int)this.prop.getSelf());
        }
        return NULL_VALUE;
    }
}

