/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import ic2.api.util.DirectionList;
import ic2.core.IC2;
import ic2.core.block.machines.tiles.hv.RocketMinerTileEntity;
import ic2.core.block.machines.tiles.lv.MinerTileEntity;
import ic2.core.item.base.IC2Item;
import ic2.core.networking.PacketManager;
import ic2.core.networking.packets.server.MultiHighlightPacket;
import ic2.core.platform.registries.IC2Entities;
import ic2.core.platform.rendering.IC2Textures;
import ic2.core.platform.rendering.features.item.ISimpleItemModel;
import ic2.core.utils.helpers.AABBUtil;
import ic2.core.utils.helpers.Formatters;
import ic2.core.utils.helpers.StackUtil;
import ic2.core.utils.math.ColorUtils;
import ic2.core.utils.math.geometry.Box;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MinerRemoteItem
extends IC2Item
implements ISimpleItemModel {
    public MinerRemoteItem() {
        super("miner_remote");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getTexture() {
        return IC2Textures.getMappedEntriesItemIC2("tools").get("miner_remote");
    }

    public static BlockPos getPos(ItemStack stack) {
        CompoundTag tag = StackUtil.getNbtData(stack);
        return tag.m_128441_("target_pos") ? BlockPos.m_122022_((long)tag.m_128454_("target_pos")) : BlockPos.f_121853_;
    }

    public static void setPos(ItemStack stack, BlockPos pos) {
        stack.m_41784_().m_128356_("target_pos", pos.m_121878_());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (!playerIn.m_6144_()) {
            this.markMiners(worldIn, playerIn.m_20183_(), playerIn);
            return InteractionResultHolder.m_19090_((Object)playerIn.m_21120_(handIn));
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public static void requestRocketMinerBack(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"rocketminer").then(Commands.m_82127_((String)"home").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(T -> {
            BlockEntity entity = ((CommandSourceStack)T.getSource()).m_81372_().m_7702_(((Coordinates)T.getArgument("pos", Coordinates.class)).m_119568_((CommandSourceStack)T.getSource()));
            if (entity instanceof RocketMinerTileEntity) {
                RocketMinerTileEntity rocket = (RocketMinerTileEntity)entity;
                if (rocket.owner == null || rocket.owner.equals(((CommandSourceStack)T.getSource()).m_81375_().m_20148_()) || IC2.PLATFORM.isOp(((CommandSourceStack)T.getSource()).m_81375_().m_20148_())) {
                    rocket.sendHome();
                    ((CommandSourceStack)T.getSource()).m_243053_((Component)Component.m_237113_((String)"Requested Miner home"));
                } else {
                    ((CommandSourceStack)T.getSource()).m_243053_((Component)Component.m_237113_((String)"You don't own the miner"));
                }
                return 0;
            }
            ((CommandSourceStack)T.getSource()).m_81352_((Component)Component.m_237113_((String)("Couldn't find Rocket Miner at " + T.getArgument("pos", BlockPos.class))));
            return 0;
        }))));
    }

    private void markMiners(Level world, BlockPos pos, Player player) {
        LongArrayList list = new LongArrayList();
        AABBUtil.getBlockEntities(world, arg_0 -> this.lambda$markMiners$1(pos, player, (LongList)list, arg_0));
        if (!list.isEmpty() && IC2.PLATFORM.isSimulating()) {
            PacketManager.INSTANCE.sendToPlayer(new MultiHighlightPacket((LongList)list, 1200, ColorUtils.GREEN & 0xFFFFFF | Integer.MIN_VALUE, false), player);
        }
        if (world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            server.m_142646_().m_142690_(IC2Entities.ROCKET_MINER, T -> {
                BlockPos relative = T.m_20183_().m_121996_((Vec3i)pos);
                Object[] args = new Object[]{this.pos(T.m_20183_()).m_130940_(ChatFormatting.AQUA), this.pos(relative).m_130940_(ChatFormatting.GREEN), ChatFormatting.RED + Integer.toString((int)Math.sqrt(T.m_20183_().m_123331_((Vec3i)pos))), this.translate("tooltip.item.ic2.mining_remote.location.rocket_miner.flying").m_130940_(ChatFormatting.GOLD)};
                player.m_5661_((Component)this.translate("tooltip.item.ic2.mining_remote.location.rocket_miner", args), false);
            });
        }
    }

    private boolean hasRocketMinerNearby(Level level, BlockPos pos) {
        boolean[] result = new boolean[1];
        AABBUtil.getBlockEntities(level, T -> {
            if (T instanceof RocketMinerTileEntity) {
                result[0] = result[0] | Box.fromPos(pos, true).expand(DirectionList.HORIZONTAL, 20).expand(DirectionList.VERTICAL, 200).intersectsWith(T.m_58899_());
            }
        });
        return result[0];
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (context.m_7078_()) {
            if (this.hasRocketMinerNearby(context.m_43725_(), context.m_8083_())) {
                if (IC2.PLATFORM.isSimulating()) {
                    context.m_43723_().m_5661_((Component)this.translate("tooltip.item.ic2.mining_remote.location.to_close"), false);
                }
                return InteractionResult.FAIL;
            }
            MinerRemoteItem.setPos(stack, context.m_8083_());
            if (IC2.PLATFORM.isSimulating()) {
                context.m_43723_().m_5661_((Component)this.translate("tooltip.item.ic2.mining_remote.location.refuel_set", new Object[]{this.pos(context.m_8083_())}), false);
            }
            return InteractionResult.SUCCESS;
        }
        return super.onItemUseFirst(stack, context);
    }

    private /* synthetic */ void lambda$markMiners$1(BlockPos pos, Player player, LongList list, BlockEntity T) {
        if (T instanceof MinerTileEntity) {
            MinerTileEntity miner = (MinerTileEntity)T;
            BlockPos relative = T.m_58899_().m_121996_((Vec3i)pos);
            int dist = (int)Math.sqrt(T.m_58899_().m_123331_((Vec3i)pos));
            boolean rocket = false;
            if (T instanceof RocketMinerTileEntity) {
                RocketMinerTileEntity rockMiner = (RocketMinerTileEntity)T;
                if (rockMiner.owner != null && !player.m_20148_().equals(rockMiner.owner) && !IC2.PLATFORM.isOp(player.m_20148_())) {
                    return;
                }
                rocket = true;
            }
            Object[] args = new Object[rocket ? 5 : 4];
            args[0] = this.pos(T.m_58899_()).m_130940_(ChatFormatting.AQUA);
            args[1] = this.pos(relative).m_130940_(ChatFormatting.GREEN);
            args[2] = ChatFormatting.RED + Integer.toString(dist);
            args[rocket ? 4 : 3] = Formatters.EU_FORMAT.format(miner.getPowerLeft());
            if (rocket) {
                args[0] = this.pos(T.m_58899_()).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.AQUA).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to request the miner back home"))).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/rocketminer home " + T.m_58899_().m_123341_() + " " + T.m_58899_().m_123342_() + " " + T.m_58899_().m_123343_())));
                args[3] = ((RocketMinerTileEntity)T).state.getState().m_130940_(ChatFormatting.GOLD);
            }
            player.m_5661_((Component)this.translate("tooltip.item.ic2.mining_remote.location." + (rocket ? "rocket_miner" : "miner"), args), false);
            if (dist < 100) {
                list.add(T.m_58899_().m_121878_());
            }
        }
    }
}

