/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.recipes.mods;

import com.google.gson.JsonObject;
import ic2.core.platform.recipes.mods.BaseRecipeModifier;
import ic2.core.platform.registries.ForgeRegistryWrapper;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentModifier
extends BaseRecipeModifier {
    Enchantment enchantment;
    int level;

    public EnchantmentModifier(JsonObject obj) {
        this(ForgeRegistryWrapper.getItemValue(ResourceLocation.m_135820_((String)obj.get("item").getAsString())), obj.get("tag").getAsString(), (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_135820_((String)obj.get("enchantment").getAsString())), obj.get("level").getAsInt());
        if (obj.has("tooltip")) {
            this.setTooltip((Component)Component.Serializer.m_130701_((String)obj.get("tooltip").getAsString()));
        }
        this.usesInput = obj.has("usesInput") && obj.get("usesInput").getAsBoolean();
    }

    public EnchantmentModifier(Item type, String tag, Enchantment enchantment, int level) {
        super(type, tag);
        this.enchantment = enchantment;
        this.level = level;
    }

    public EnchantmentModifier(FriendlyByteBuf buffer) {
        super(buffer);
        this.enchantment = (Enchantment)buffer.readRegistryIdUnsafe(ForgeRegistries.ENCHANTMENTS);
        this.level = buffer.m_130242_();
    }

    @Override
    protected boolean isTagUsable(ItemStack input) {
        Map data = EnchantmentHelper.m_44831_((ItemStack)input);
        int level = data.getOrDefault(this.enchantment, 0);
        if (level <= 0) {
            for (Enchantment enchantment : data.keySet()) {
                if (enchantment.m_44695_(this.enchantment)) continue;
                return false;
            }
        }
        return level < this.level;
    }

    @Override
    public ItemStack applyChanges(ItemStack input, boolean forDisplay) {
        Map data = EnchantmentHelper.m_44831_((ItemStack)input);
        data.put(this.enchantment, this.level);
        EnchantmentHelper.m_44865_((Map)data, (ItemStack)input);
        return super.applyChanges(input, forDisplay);
    }

    @Override
    public void serialize(FriendlyByteBuf buffer) {
        super.serialize(buffer);
        buffer.writeRegistryIdUnsafe(ForgeRegistries.ENCHANTMENTS, (Object)this.enchantment);
        buffer.m_130130_(this.level);
    }

    @Override
    public JsonObject serialize() {
        JsonObject obj = new JsonObject();
        obj.addProperty("enchantment", ForgeRegistryWrapper.getEnchantmentKey(this.enchantment).toString());
        obj.addProperty("level", (Number)this.level);
        obj.addProperty("item", ForgeRegistryWrapper.getItemKey(this.type).toString());
        obj.addProperty("usesInput", Boolean.valueOf(this.usesInput));
        if (this.tooltip != null) {
            obj.addProperty("tooltip", Component.Serializer.m_130703_((Component)this.tooltip));
        }
        return obj;
    }
}

