/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.elevator;

import com.simibubi.create.AllPackets;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.elevator.ElevatorContraption;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.IntAttached;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ElevatorFloorListPacket
extends SimplePacketBase {
    private int entityId;
    private List<IntAttached<Couple<String>>> floorsList;

    public ElevatorFloorListPacket(AbstractContraptionEntity entity, List<IntAttached<Couple<String>>> floorsList) {
        this.entityId = entity.m_19879_();
        this.floorsList = floorsList;
    }

    public ElevatorFloorListPacket(FriendlyByteBuf buffer) {
        this.entityId = buffer.readInt();
        int size = buffer.readInt();
        this.floorsList = new ArrayList<IntAttached<Couple<String>>>();
        for (int i = 0; i < size; ++i) {
            this.floorsList.add(IntAttached.with(buffer.readInt(), Couple.create(buffer.m_130277_(), buffer.m_130277_())));
        }
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.floorsList.size());
        for (IntAttached<Couple<String>> entry : this.floorsList) {
            buffer.writeInt(((Integer)entry.getFirst()).intValue());
            ((Couple)entry.getSecond()).forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130070_(arg_0));
        }
    }

    @Override
    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            Entity entityByID = Minecraft.m_91087_().f_91073_.m_6815_(this.entityId);
            if (!(entityByID instanceof AbstractContraptionEntity)) {
                return;
            }
            AbstractContraptionEntity ace = (AbstractContraptionEntity)entityByID;
            Contraption patt1910$temp = ace.getContraption();
            if (!(patt1910$temp instanceof ElevatorContraption)) {
                return;
            }
            ElevatorContraption ec = (ElevatorContraption)patt1910$temp;
            ec.namesList = this.floorsList;
            ec.syncControlDisplays();
        });
        return true;
    }

    public static class RequestFloorList
    extends SimplePacketBase {
        private int entityId;

        public RequestFloorList(AbstractContraptionEntity entity) {
            this.entityId = entity.m_19879_();
        }

        public RequestFloorList(FriendlyByteBuf buffer) {
            this.entityId = buffer.readInt();
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeInt(this.entityId);
        }

        @Override
        public boolean handle(NetworkEvent.Context context) {
            context.enqueueWork(() -> {
                ServerPlayer sender = context.getSender();
                Entity entityByID = sender.m_9236_().m_6815_(this.entityId);
                if (!(entityByID instanceof AbstractContraptionEntity)) {
                    return;
                }
                AbstractContraptionEntity ace = (AbstractContraptionEntity)entityByID;
                Contraption patt2761$temp = ace.getContraption();
                if (!(patt2761$temp instanceof ElevatorContraption)) {
                    return;
                }
                ElevatorContraption ec = (ElevatorContraption)patt2761$temp;
                AllPackets.getChannel().send(PacketDistributor.PLAYER.with(() -> sender), (Object)new ElevatorFloorListPacket(ace, ec.namesList));
            });
            return true;
        }
    }
}

