/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.pulley;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.contraptions.pulley.PulleyBlockEntity;
import com.simibubi.create.content.kinetics.base.HorizontalAxisKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PulleyBlock
extends HorizontalAxisKineticBlock
implements IBE<PulleyBlockEntity> {
    public PulleyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static void onRopeBroken(Level world, BlockPos pulleyPos) {
        BlockEntity be = world.m_7702_(pulleyPos);
        if (be instanceof PulleyBlockEntity) {
            PulleyBlockEntity pulley = (PulleyBlockEntity)be;
            pulley.initialOffset = 0;
            pulley.onLengthBroken();
        }
    }

    @Override
    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, worldIn, pos, newState, isMoving);
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        if (worldIn.f_46443_) {
            return;
        }
        BlockState below = worldIn.m_8055_(pos.m_7495_());
        if (below.m_60734_() instanceof RopeBlockBase) {
            worldIn.m_46961_(pos.m_7495_(), true);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!player.m_36326_()) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (player.m_21120_(handIn).m_41619_()) {
            this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
                be.assembleNextTick = true;
            });
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.PULLEY.get((Direction.Axis)state.m_61143_(HORIZONTAL_AXIS));
    }

    @Override
    public Class<PulleyBlockEntity> getBlockEntityClass() {
        return PulleyBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends PulleyBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.ROPE_PULLEY.get();
    }

    private static class RopeBlockBase
    extends Block
    implements SimpleWaterloggedBlock {
        public RopeBlockBase(BlockBehaviour.Properties properties) {
            super(properties);
            this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
        }

        public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
            return false;
        }

        public PushReaction m_5537_(BlockState state) {
            return PushReaction.BLOCK;
        }

        public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
            return AllBlocks.ROPE_PULLEY.asStack();
        }

        public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
            if (!(isMoving || state.m_61138_((Property)BlockStateProperties.f_61362_) && newState.m_61138_((Property)BlockStateProperties.f_61362_) && state.m_61143_((Property)BlockStateProperties.f_61362_) != newState.m_61143_((Property)BlockStateProperties.f_61362_))) {
                PulleyBlock.onRopeBroken(worldIn, pos.m_7494_());
                if (!worldIn.f_46443_) {
                    BlockState above = worldIn.m_8055_(pos.m_7494_());
                    BlockState below = worldIn.m_8055_(pos.m_7495_());
                    if (above.m_60734_() instanceof RopeBlockBase) {
                        worldIn.m_46961_(pos.m_7494_(), true);
                    }
                    if (below.m_60734_() instanceof RopeBlockBase) {
                        worldIn.m_46961_(pos.m_7495_(), true);
                    }
                }
            }
            if (state.m_155947_() && state.m_60734_() != newState.m_60734_()) {
                worldIn.m_46747_(pos);
            }
        }

        public FluidState m_5888_(BlockState state) {
            return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
            super.m_7926_(builder);
        }

        public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor world, BlockPos pos, BlockPos neighbourPos) {
            if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
            }
            return state;
        }

        public BlockState m_5573_(BlockPlaceContext context) {
            FluidState FluidState2 = context.m_43725_().m_6425_(context.m_8083_());
            return (BlockState)super.m_5573_(context).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(FluidState2.m_76152_() == Fluids.f_76193_));
        }
    }

    public static class RopeBlock
    extends RopeBlockBase {
        public RopeBlock(BlockBehaviour.Properties properties) {
            super(properties);
        }

        public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
            return AllShapes.FOUR_VOXEL_POLE.get(Direction.UP);
        }
    }

    public static class MagnetBlock
    extends RopeBlockBase {
        public MagnetBlock(BlockBehaviour.Properties properties) {
            super(properties);
        }

        public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
            return AllShapes.PULLEY_MAGNET;
        }
    }
}

