/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.instruction;

import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.instruction.WorldModifyInstruction;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ReplaceBlocksInstruction
extends WorldModifyInstruction {
    private UnaryOperator<BlockState> stateToUse;
    private boolean replaceAir;
    private boolean spawnParticles;

    public ReplaceBlocksInstruction(Selection selection, UnaryOperator<BlockState> stateToUse, boolean replaceAir, boolean spawnParticles) {
        super(selection);
        this.stateToUse = stateToUse;
        this.replaceAir = replaceAir;
        this.spawnParticles = spawnParticles;
    }

    @Override
    protected void runModification(Selection selection, PonderScene scene) {
        PonderWorld world = scene.getWorld();
        selection.forEach(pos -> {
            if (!world.getBounds().m_71051_((Vec3i)pos)) {
                return;
            }
            BlockState prevState = world.m_8055_((BlockPos)pos);
            if (!this.replaceAir && prevState == Blocks.f_50016_.m_49966_()) {
                return;
            }
            if (this.spawnParticles) {
                world.addBlockDestroyEffects((BlockPos)pos, prevState);
            }
            world.m_46597_((BlockPos)pos, (BlockState)this.stateToUse.apply(prevState));
        });
    }

    @Override
    protected boolean needsRedraw() {
        return true;
    }
}

