/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.euconverter.block.entity;

import cy.jdkdigital.euconverter.Config;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.network.buffer.NetworkInfo;
import ic2.core.block.base.tiles.impls.BaseEnergyStorageTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public abstract class ConverterBlockEntity
extends BaseEnergyStorageTileEntity {
    private EnergyStorage storage;
    private LazyOptional<IEnergyStorage> energyHandler;
    @NetworkInfo
    public int production;

    public ConverterBlockEntity(BlockPos pPos, BlockState pBlockState, int tier, int output, int maxEnergy) {
        super(pPos, pBlockState, tier, output, maxEnergy);
        this.production = output;
        this.storage = new EnergyStorage(maxEnergy * 4);
        this.energyHandler = LazyOptional.of(() -> this.storage);
    }

    public void onTick() {
        super.onTick();
        if (this.gainEnergy()) {
            this.updateGuiField("energy");
        }
        this.setActive(this.energy > 0);
    }

    public boolean gainEnergy() {
        if (this.needsEnergy()) {
            int possibleAddedPower = Math.min(this.production, this.storage.getEnergyStored() / (Integer)Config.SERVER.conversionRate.get());
            int addedPower = Math.min(this.maxEnergy - this.energy, possibleAddedPower);
            this.energy += addedPower;
            this.storage.extractEnergy(addedPower * (Integer)Config.SERVER.conversionRate.get(), false);
            return true;
        }
        return false;
    }

    public boolean needsEnergy() {
        return this.energy < this.maxEnergy;
    }

    public boolean canEmitEnergy(IEnergyAcceptor acceptor, Direction side) {
        return this.getFacing() != side;
    }

    public boolean canAcceptEnergy(IEnergyEmitter emitter, Direction side) {
        return false;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY && (side == null || side.equals((Object)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_)))) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("fe")) {
            this.storage.deserializeNBT(tag.m_128423_("fe"));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("fe", this.storage.serializeNBT());
    }

    public boolean isHarvestWrenchRequired(Player player) {
        return false;
    }

    public double getDropRate(Player player) {
        return 1.0;
    }

    public int getGuiOffset() {
        return 0;
    }

    public void setFacing(Direction facing) {
        super.setFacing(facing);
        if (this.energyHandler != null) {
            this.energyHandler.invalidate();
            this.energyHandler = LazyOptional.of(() -> this.storage);
            this.addToTick();
        }
    }

    public void onUnloaded(boolean chunk) {
        if (this.energyHandler != null) {
            this.energyHandler.invalidate();
            this.energyHandler = null;
        }
        super.onUnloaded(chunk);
    }
}

