/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.pbr;

import com.mojang.blaze3d.platform.TextureUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.coderbot.iris.mixin.texture.AnimatedTextureAccessor;
import net.coderbot.iris.mixin.texture.FrameInfoAccessor;
import net.coderbot.iris.texture.pbr.PBRAtlasHolder;
import net.coderbot.iris.texture.pbr.PBRTextureManager;
import net.coderbot.iris.texture.pbr.PBRType;
import net.coderbot.iris.texture.pbr.TextureAtlasExtension;
import net.coderbot.iris.texture.util.TextureExporter;
import net.coderbot.iris.texture.util.TextureManipulationUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class PBRAtlasTexture
extends AbstractTexture {
    protected final TextureAtlas atlasTexture;
    protected final PBRType type;
    protected final ResourceLocation id;
    protected final Map<ResourceLocation, TextureAtlasSprite> sprites = new HashMap<ResourceLocation, TextureAtlasSprite>();
    protected final List<Tickable> animationTickers = new ArrayList<Tickable>();

    public PBRAtlasTexture(TextureAtlas atlasTexture, PBRType type) {
        this.atlasTexture = atlasTexture;
        this.type = type;
        this.id = type.appendToFileLocation(atlasTexture.m_118330_());
    }

    public PBRType getType() {
        return this.type;
    }

    public ResourceLocation getAtlasId() {
        return this.id;
    }

    public void addSprite(TextureAtlasSprite sprite) {
        this.sprites.put(sprite.m_118413_(), sprite);
        if (sprite.m_174746_() != null) {
            this.animationTickers.add(sprite.m_174746_());
        }
    }

    @Nullable
    public TextureAtlasSprite getSprite(ResourceLocation id) {
        return this.sprites.get(id);
    }

    public void clear() {
        this.sprites.clear();
        this.animationTickers.clear();
    }

    public void upload(int atlasWidth, int atlasHeight, int mipLevel) {
        int glId = this.m_117963_();
        TextureUtil.m_85287_((int)glId, (int)mipLevel, (int)atlasWidth, (int)atlasHeight);
        TextureManipulationUtil.fillWithColor(glId, mipLevel, this.type.getDefaultValue());
        for (TextureAtlasSprite sprite : this.sprites.values()) {
            try {
                this.uploadSprite(sprite);
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.m_127521_((Throwable)throwable, (String)"Stitching texture atlas");
                CrashReportCategory crashReportCategory = crashReport.m_127514_("Texture being stitched together");
                crashReportCategory.m_128159_("Atlas path", (Object)this.id);
                crashReportCategory.m_128159_("Sprite", (Object)sprite);
                throw new ReportedException(crashReport);
            }
        }
        if (!this.animationTickers.isEmpty()) {
            PBRAtlasHolder pbrHolder = ((TextureAtlasExtension)this.atlasTexture).getOrCreatePBRHolder();
            switch (this.type) {
                case NORMAL: {
                    pbrHolder.setNormalAtlas(this);
                    break;
                }
                case SPECULAR: {
                    pbrHolder.setSpecularAtlas(this);
                }
            }
        }
        if (PBRTextureManager.DEBUG) {
            TextureExporter.exportTextures("pbr_debug/atlas", this.id.m_135827_() + "_" + this.id.m_135815_().replaceAll("/", "_"), glId, mipLevel, atlasWidth, atlasHeight);
        }
    }

    public boolean tryUpload(int atlasWidth, int atlasHeight, int mipLevel) {
        try {
            this.upload(atlasWidth, atlasHeight, mipLevel);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected void uploadSprite(TextureAtlasSprite sprite) {
        Tickable ticker = sprite.m_174746_();
        if (ticker instanceof AnimatedTextureAccessor) {
            AnimatedTextureAccessor accessor = (AnimatedTextureAccessor)ticker;
            accessor.invokeUploadFrame(((FrameInfoAccessor)accessor.getFrames().get(accessor.getFrame())).getIndex());
            return;
        }
        sprite.m_118416_();
    }

    public void cycleAnimationFrames() {
        this.m_117966_();
        for (Tickable ticker : this.animationTickers) {
            ticker.m_7673_();
        }
    }

    public void close() {
        PBRAtlasHolder pbrHolder = ((TextureAtlasExtension)this.atlasTexture).getPBRHolder();
        if (pbrHolder != null) {
            switch (this.type) {
                case NORMAL: {
                    pbrHolder.setNormalAtlas(null);
                    break;
                }
                case SPECULAR: {
                    pbrHolder.setSpecularAtlas(null);
                }
            }
        }
    }

    public void m_6704_(ResourceManager manager) {
    }
}

